/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.service.RunnableBase;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
abstract class RunnableBaseTest<T extends RunnableBase> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected static final long TEST_TIMEOUT = 5L;
    protected T runnableBase;

    RunnableBaseTest() {
    }

    @BeforeEach
    public void setUp() {
        this.runnableBase = this.createRunnableBase();
    }

    protected abstract T createRunnableBase();

    protected CompletableFuture<Void> startRunnableBase() {
        return CompletableFuture.runAsync(this.runnableBase);
    }

    @Test
    @Timeout(value=5L)
    void destroy() throws Exception {
        CompletableFuture<Void> future = this.startRunnableBase();
        Assertions.assertThat((boolean)this.runnableBase.isAlive()).isTrue();
        this.runnableBase.destroy();
        future.get();
        Assertions.assertThat((boolean)this.runnableBase.isDestroyed()).isTrue();
    }
}

