/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.core.model.ModelConstants;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.service.SolutionBuilder;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TaskState;
import org.kie.kogito.taskassigning.service.TestUtil;
import org.mockito.Mockito;

class SolutionBuilderTest {
    private static final String TASK1 = "TASK1";
    private static final String TASK2 = "TASK2";
    private static final String TASK3 = "TASK3";
    private static final String TASK4 = "TASK4";
    private static final String TASK5 = "TASK5";
    private static final String TASK6 = "TASK6";
    private static final String TASK7 = "TASK7";
    private static final String TASK8 = "TASK8";
    private static final String TASK9 = "TASK9";
    private static final String TASK10 = "TASK10";
    private static final String TASK11 = "TASK11";
    private static final String USER1 = "USER1";
    private static final String USER2 = "USER2";
    private static final String USER3 = "USER3";
    private static final String USER4 = "USER4";
    private static final String USER_NOT_IN_THE_EXTERNAL_SYSTEM = "USER_NOT_IN_THE_EXTERNAL_SYSTEM";

    SolutionBuilderTest() {
    }

    @Test
    void build() {
        List<TaskData> taskDataList = Arrays.asList(SolutionBuilderTest.mockTaskData(TASK1, TaskState.READY.value()), SolutionBuilderTest.mockTaskData(TASK2, TaskState.RESERVED.value(), USER2), SolutionBuilderTest.mockTaskData(TASK3, TaskState.READY.value()), SolutionBuilderTest.mockTaskData(TASK4, TaskState.READY.value()), SolutionBuilderTest.mockTaskData(TASK5, TaskState.RESERVED.value(), USER2), SolutionBuilderTest.mockTaskData(TASK6, TaskState.READY.value()), SolutionBuilderTest.mockTaskData(TASK7, TaskState.RESERVED.value(), USER4), SolutionBuilderTest.mockTaskData(TASK8, TaskState.READY.value()), SolutionBuilderTest.mockTaskData(TASK9, TaskState.RESERVED.value(), USER4), SolutionBuilderTest.mockTaskData(TASK10, TaskState.RESERVED.value(), USER1), SolutionBuilderTest.mockTaskData(TASK11, TaskState.RESERVED.value(), USER_NOT_IN_THE_EXTERNAL_SYSTEM));
        List<org.kie.kogito.taskassigning.user.service.User> externalUsers = Arrays.asList(TestUtil.mockExternalUser(USER1), TestUtil.mockExternalUser(USER2), TestUtil.mockExternalUser(USER3), TestUtil.mockExternalUser(USER4));
        TaskAssigningSolution solution = SolutionBuilder.newBuilder().withTasks(taskDataList).withUsers(externalUsers).build();
        Assertions.assertThat((List)solution.getTaskAssignmentList()).hasSize(13);
        Assertions.assertThat((List)solution.getUserList()).hasSize(6);
        this.assertThatUserHasTask(solution, USER1, 1, 0, TASK10, 0, 1);
        this.assertThatUserHasTask(solution, USER2, 2, 0, TASK2, 0, 1);
        this.assertThatUserHasTask(solution, USER2, 2, 1, TASK5, 1, 2);
        this.assertThatUserNoTasks(solution, USER3);
        this.assertThatUserHasTask(solution, USER4, 2, 0, TASK7, 0, 1);
        this.assertThatUserHasTask(solution, USER4, 2, 1, TASK9, 1, 2);
        this.assertThatUserHasTask(solution, USER_NOT_IN_THE_EXTERNAL_SYSTEM, 1, 0, TASK11, 0, 1);
        this.assertThatUserNoTasks(solution, ModelConstants.PLANNING_USER_ID);
        this.assertThatTaskIsNotAssigned(solution, TASK1);
        this.assertThatTaskIsAssignedToUser(solution, TASK2, USER2);
        this.assertThatTaskIsNotAssigned(solution, TASK3);
        this.assertThatTaskIsNotAssigned(solution, TASK4);
        this.assertThatTaskIsAssignedToUser(solution, TASK5, USER2);
        this.assertThatTaskIsNotAssigned(solution, TASK6);
        this.assertThatTaskIsAssignedToUser(solution, TASK7, USER4);
        this.assertThatTaskIsNotAssigned(solution, TASK8);
        this.assertThatTaskIsAssignedToUser(solution, TASK9, USER4);
        this.assertThatTaskIsAssignedToUser(solution, TASK10, USER1);
        this.assertThatTaskIsAssignedToUser(solution, TASK11, USER_NOT_IN_THE_EXTERNAL_SYSTEM);
        this.assertThatTaskIsNotAssigned(solution, ModelConstants.DUMMY_TASK_ASSIGNMENT.getId());
        this.assertThatTaskIsNotAssigned(solution, ModelConstants.DUMMY_TASK_ASSIGNMENT_PLANNER_1738.getId());
    }

    private void assertThatUserHasTask(TaskAssigningSolution solution, String userId, int expectedTasks, int expectedTaskPosition, String expectedTask, int expectedStartTimeInMinutes, int expectedEndTimeInMinutes) {
        User user = solution.getUserList().stream().filter(u -> userId.equals(u.getId())).findFirst().orElse(null);
        ((ObjectAssert)Assertions.assertThat((Object)user).withFailMessage("User %s is not present in solution.", new Object[]{userId})).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)user.getNextElement()).withFailMessage("User %s must have %s task assignments", new Object[]{userId, expectedTasks})).isNotNull();
        ArrayList<TaskAssignment> assignments = new ArrayList<TaskAssignment>();
        for (TaskAssignment nextElement = user.getNextElement(); nextElement != null; nextElement = nextElement.getNextElement()) {
            assignments.add(nextElement);
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)assignments.size()).withFailMessage("User %s must have %s task assignments, but have %s", new Object[]{userId, expectedTasks, assignments.size()})).isEqualTo(expectedTasks);
        TaskAssignment taskAssignment = (TaskAssignment)assignments.get(expectedTaskPosition);
        ((AbstractStringAssert)Assertions.assertThat((String)taskAssignment.getId()).withFailMessage("User %s must have the task %s at the position %s", new Object[]{userId, expectedTask, expectedTaskPosition})).isEqualTo(expectedTask);
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)taskAssignment.getStartTimeInMinutes()).withFailMessage("Task %s must start at time %s", new Object[]{expectedTask, expectedStartTimeInMinutes})).isEqualTo(expectedStartTimeInMinutes);
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)taskAssignment.getEndTimeInMinutes()).withFailMessage("Task %s must finish at time %s", new Object[]{expectedTask, expectedEndTimeInMinutes})).isEqualTo(expectedEndTimeInMinutes);
    }

    private void assertThatUserNoTasks(TaskAssigningSolution solution, String userId) {
        User user = solution.getUserList().stream().filter(u -> userId.equals(u.getId())).findFirst().orElse(null);
        ((ObjectAssert)Assertions.assertThat((Object)user).withFailMessage("User %s is not present in solution.", new Object[]{userId})).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)user.getNextElement()).withFailMessage("User %s must not have task assignments", new Object[]{userId})).isNull();
    }

    private void assertThatTaskIsAssignedToUser(TaskAssigningSolution solution, String taskId, String userId) {
        TaskAssignment taskAssignment = solution.getTaskAssignmentList().stream().filter(ta -> taskId.equals(ta.getId())).findFirst().orElse(null);
        ((ObjectAssert)Assertions.assertThat((Object)taskAssignment).withFailMessage("Task %s is not present in solution.", new Object[]{taskId})).isNotNull();
        User user = solution.getUserList().stream().filter(u -> userId.equals(u.getId())).findFirst().orElse(null);
        ((ObjectAssert)Assertions.assertThat((Object)user).withFailMessage("User %s is not present in solution.", new Object[]{userId})).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)taskAssignment.getUser()).withFailMessage("Task %s must be assigned to user %s but is assigned to nobody.", new Object[]{taskId, userId})).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)taskAssignment.getUser().getId()).withFailMessage("Task %s must be assigned to user %s.", new Object[]{taskId, userId})).isEqualTo(userId);
    }

    private void assertThatTaskIsNotAssigned(TaskAssigningSolution solution, String taskId) {
        TaskAssignment taskAssignment = solution.getTaskAssignmentList().stream().filter(ta -> taskId.equals(ta.getId())).findFirst().orElse(null);
        ((ObjectAssert)Assertions.assertThat((Object)taskAssignment).withFailMessage("Task %s is not present in solution.", new Object[]{taskId})).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)taskAssignment.getUser()).withFailMessage("Task %s must not be assigned", new Object[]{taskId})).isNull();
    }

    private static TaskData mockTaskData(String taskId, String state, String actualOwner) {
        TaskData taskData = (TaskData)Mockito.mock(TaskData.class);
        ((TaskData)Mockito.doReturn((Object)taskId).when((Object)taskData)).getId();
        ((TaskData)Mockito.doReturn((Object)state).when((Object)taskData)).getState();
        ((TaskData)Mockito.doReturn((Object)actualOwner).when((Object)taskData)).getActualOwner();
        return taskData;
    }

    private static TaskData mockTaskData(String taskId, String state) {
        return SolutionBuilderTest.mockTaskData(taskId, state, null);
    }
}

