/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AddTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AddUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AssignTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.DisableUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.ReleaseTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.RemoveTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.RemoveUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.UserPropertyChangeProblemFactChange;
import org.kie.kogito.taskassigning.service.SolutionChangesBuilder;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceContext;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TaskState;
import org.kie.kogito.taskassigning.service.TestUtil;
import org.kie.kogito.taskassigning.service.event.UserDataEvent;
import org.kie.kogito.taskassigning.service.util.TaskUtil;
import org.kie.kogito.taskassigning.user.service.Group;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.api.solver.ProblemFactChange;

@ExtendWith(value={MockitoExtension.class})
class SolutionChangesBuilderTest {
    private static final String TASK_1_ID = "TASK_1_ID";
    private static final ZonedDateTime TASK_1_LAST_UPDATE = TestUtil.parseZonedDateTime("2021-03-11T10:00:00.001Z");
    private static final String USER_1 = "USER_1";
    private static final String USER_2 = "USER_2";
    private static final String GROUP_1 = "GROUP_1";
    private static final String GROUP_2 = "GROUP_2";
    private static final String ATTRIBUTE_1 = "ATTRIBUTE_1";
    private static final String ATTRIBUTE_1_VALUE = "ATTRIBUTE_1_VALUE";
    private static final String ATTRIBUTE_1_VALUE_CHANGED = "ATTRIBUTE_1_VALUE_CHANGED";
    private TaskAssigningServiceContext context;
    @Mock
    private UserServiceConnector userServiceConnector;
    @Mock
    private ScoreDirector<TaskAssigningSolution> scoreDirector;

    SolutionChangesBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        this.context = new TaskAssigningServiceContext();
    }

    @Test
    void addNewReadyTaskChange() {
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, TaskState.READY.value(), TASK_1_LAST_UPDATE);
        List<TaskData> taskDataList = SolutionChangesBuilderTest.mockTaskDataList(taskData);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.emptyList(), Collections.emptyList());
        List result = SolutionChangesBuilder.create().withContext(this.context).withUserServiceConnector(this.userServiceConnector).fromTasksData(taskDataList).forSolution(solution).build();
        AddTaskProblemFactChange expected = new AddTaskProblemFactChange(new TaskAssignment(TaskUtil.fromTaskData((TaskData)taskData)));
        this.assertChangeIsTheChangeSetId(result, 0);
        SolutionChangesBuilderTest.assertChange((List<ProblemFactChange<TaskAssigningSolution>>)result, 1, expected);
        this.assertTaskPublishStatus(taskData.getId(), false);
    }

    @Test
    void addNewReservedTaskChangeWithActualOwnerInSolution() {
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_1, TASK_1_LAST_UPDATE);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.singletonList(SolutionChangesBuilderTest.mockUser(USER_1)), Collections.emptyList());
        this.addNewReservedTaskChangeWithActualOwner(solution, taskData);
    }

    @Test
    void addNewReservedTaskChangeWithActualOwnerInExternalSystem() {
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_1, TASK_1_LAST_UPDATE);
        org.kie.kogito.taskassigning.user.service.User externalUser = SolutionChangesBuilderTest.mockExternalUser(USER_1);
        ((UserServiceConnector)Mockito.doReturn((Object)externalUser).when((Object)this.userServiceConnector)).findUser(USER_1);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.emptyList(), Collections.emptyList());
        this.addNewReservedTaskChangeWithActualOwner(solution, taskData);
        ((UserServiceConnector)Mockito.verify((Object)this.userServiceConnector)).findUser(USER_1);
    }

    @Test
    void addNewReservedTaskChangeWithActualOwnerNotInExternalSystem() {
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_1, TASK_1_LAST_UPDATE);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.emptyList(), Collections.emptyList());
        this.addNewReservedTaskChangeWithActualOwner(solution, taskData);
        ((UserServiceConnector)Mockito.verify((Object)this.userServiceConnector)).findUser(USER_1);
    }

    private void addNewReservedTaskChangeWithActualOwner(TaskAssigningSolution solution, TaskData taskData) {
        List<TaskData> taskDataList = SolutionChangesBuilderTest.mockTaskDataList(taskData);
        List result = SolutionChangesBuilder.create().withContext(this.context).withUserServiceConnector(this.userServiceConnector).fromTasksData(taskDataList).forSolution(solution).build();
        AssignTaskProblemFactChange expected = new AssignTaskProblemFactChange(new TaskAssignment(TaskUtil.fromTaskData((TaskData)taskData)), SolutionChangesBuilderTest.mockUser(USER_1), true);
        this.assertChangeIsTheChangeSetId(result, 0);
        SolutionChangesBuilderTest.assertChange((List<ProblemFactChange<TaskAssigningSolution>>)result, 1, expected);
        this.assertTaskPublishStatus(taskData.getId(), true);
    }

    @Test
    void addReleasedTaskChange() {
        TaskAssignment user1Assignment = new TaskAssignment(SolutionChangesBuilderTest.mockTask(TASK_1_ID, TaskState.RESERVED.value()));
        User user1 = TestUtil.mockUser(USER_1, Collections.singletonList(user1Assignment));
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.singletonList(user1), Collections.singletonList(user1Assignment));
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, TaskState.READY.value(), TASK_1_LAST_UPDATE);
        List result = SolutionChangesBuilder.create().withContext(this.context).withUserServiceConnector(this.userServiceConnector).fromTasksData(SolutionChangesBuilderTest.mockTaskDataList(taskData)).forSolution(solution).build();
        this.assertChangeIsTheChangeSetId(result, 0);
        SolutionChangesBuilderTest.assertChange((List<ProblemFactChange<TaskAssigningSolution>>)result, 1, new ReleaseTaskProblemFactChange(new TaskAssignment(TaskUtil.fromTaskData((TaskData)taskData))));
        this.assertTaskPublishStatus(TASK_1_ID, false);
    }

    @Test
    void addReservedTaskChangeForAnotherUserInSolution() {
        TaskAssignment user1Assignment = new TaskAssignment(SolutionChangesBuilderTest.mockTask(TASK_1_ID));
        User user1 = TestUtil.mockUser(USER_1, Collections.singletonList(user1Assignment));
        User user2 = SolutionChangesBuilderTest.mockUser(USER_2);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Arrays.asList(user1, user2), Collections.singletonList(user1Assignment));
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_2, TASK_1_LAST_UPDATE);
        this.addReservedTaskChangeForAnotherUser(solution, taskData, user2);
    }

    @Test
    void addReservedTaskChangeForAnotherUserInExternalSystem() {
        TaskAssignment user1Assignment = new TaskAssignment(SolutionChangesBuilderTest.mockTask(TASK_1_ID));
        User user1 = TestUtil.mockUser(USER_1, Collections.singletonList(user1Assignment));
        org.kie.kogito.taskassigning.user.service.User user2 = SolutionChangesBuilderTest.mockExternalUser(USER_2);
        ((UserServiceConnector)Mockito.doReturn((Object)user2).when((Object)this.userServiceConnector)).findUser(USER_2);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.singletonList(user1), Collections.singletonList(user1Assignment));
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_2, TASK_1_LAST_UPDATE);
        this.addReservedTaskChangeForAnotherUser(solution, taskData, SolutionChangesBuilderTest.mockUser(USER_2));
        ((UserServiceConnector)Mockito.verify((Object)this.userServiceConnector)).findUser(USER_2);
    }

    @Test
    void addReservedTaskChangeForAnotherUserNotInExternalSystem() {
        TaskAssignment user1Assignment = new TaskAssignment(SolutionChangesBuilderTest.mockTask(TASK_1_ID));
        User user1 = TestUtil.mockUser(USER_1, Collections.singletonList(user1Assignment));
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.singletonList(user1), Collections.singletonList(user1Assignment));
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_2, TASK_1_LAST_UPDATE);
        this.addReservedTaskChangeForAnotherUser(solution, taskData, SolutionChangesBuilderTest.mockUser(USER_2));
        ((UserServiceConnector)Mockito.verify((Object)this.userServiceConnector)).findUser(USER_2);
    }

    private void addReservedTaskChangeForAnotherUser(TaskAssigningSolution solution, TaskData taskData, User user) {
        List result = SolutionChangesBuilder.create().withContext(this.context).withUserServiceConnector(this.userServiceConnector).fromTasksData(SolutionChangesBuilderTest.mockTaskDataList(taskData)).forSolution(solution).build();
        this.assertChangeIsTheChangeSetId(result, 0);
        SolutionChangesBuilderTest.assertChange((List<ProblemFactChange<TaskAssigningSolution>>)result, 1, new AssignTaskProblemFactChange(new TaskAssignment(TaskUtil.fromTaskData((TaskData)taskData)), user, true));
        this.assertTaskPublishStatus(TASK_1_ID, true);
    }

    @Test
    void addReservedTaskChangeForSameUserButNotPinned() {
        TaskAssignment user1Assignment = new TaskAssignment(SolutionChangesBuilderTest.mockTask(TASK_1_ID));
        User user1 = TestUtil.mockUser(USER_1, Collections.singletonList(user1Assignment));
        user1Assignment.setPinned(false);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.singletonList(user1), Collections.singletonList(user1Assignment));
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_1, TASK_1_LAST_UPDATE);
        this.addReservedTaskChangeForAnotherUser(solution, taskData, user1);
    }

    @Test
    void addRemoveTaskAborted() {
        this.addRemoveTaskInTerminalStatus(TaskState.ABORTED);
    }

    @Test
    void addRemoveTaskCompleted() {
        this.addRemoveTaskInTerminalStatus(TaskState.COMPLETED);
    }

    @Test
    void addRemoveTaskSkipped() {
        this.addRemoveTaskInTerminalStatus(TaskState.SKIPPED);
    }

    void addRemoveTaskInTerminalStatus(TaskState terminalState) {
        TaskAssignment user1Assignment = new TaskAssignment(SolutionChangesBuilderTest.mockTask(TASK_1_ID));
        User user1 = TestUtil.mockUser(USER_1, Collections.singletonList(user1Assignment));
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.singletonList(user1), Collections.singletonList(user1Assignment));
        TaskData taskData = TestUtil.mockTaskData(TASK_1_ID, terminalState.value(), TASK_1_LAST_UPDATE);
        List result = SolutionChangesBuilder.create().withContext(this.context).withUserServiceConnector(this.userServiceConnector).fromTasksData(SolutionChangesBuilderTest.mockTaskDataList(taskData)).forSolution(solution).build();
        this.assertChangeIsTheChangeSetId(result, 0);
        SolutionChangesBuilderTest.assertChange((List<ProblemFactChange<TaskAssigningSolution>>)result, 1, new RemoveTaskProblemFactChange(new TaskAssignment(TaskUtil.fromTaskData((TaskData)taskData))));
    }

    @Test
    void addNewUserChange() {
        org.kie.kogito.taskassigning.user.service.User newExternalUser = SolutionChangesBuilderTest.mockExternalUser(USER_1);
        User newUser = SolutionChangesBuilderTest.mockUser(USER_1);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.emptyList(), Collections.emptyList());
        UserDataEvent event = new UserDataEvent(Collections.singletonList(newExternalUser), ZonedDateTime.now());
        List result = SolutionChangesBuilder.create().withContext(this.context).withUserServiceConnector(this.userServiceConnector).fromTasksData(Collections.emptyList()).fromUserDataEvent(event).forSolution(solution).build();
        AddUserProblemFactChange expected = new AddUserProblemFactChange(newUser);
        this.assertChangeIsTheChangeSetId(result, 0);
        SolutionChangesBuilderTest.assertChange((List<ProblemFactChange<TaskAssigningSolution>>)result, 1, expected);
    }

    @Test
    void addUpdateUserChangeByGroup() {
        HashMap<String, Object> userAttributes = new HashMap<String, Object>();
        userAttributes.put(ATTRIBUTE_1, ATTRIBUTE_1_VALUE);
        User user = SolutionChangesBuilderTest.mockUser(USER_1, Collections.singleton(new org.kie.kogito.taskassigning.core.model.Group(GROUP_1)), userAttributes);
        HashMap<String, Object> externalUserAttributes = new HashMap<String, Object>();
        externalUserAttributes.put(ATTRIBUTE_1, ATTRIBUTE_1_VALUE);
        org.kie.kogito.taskassigning.user.service.User updatedExternalUser = SolutionChangesBuilderTest.mockExternalUser(USER_1, Collections.singleton(SolutionChangesBuilderTest.mockExternalGroup(GROUP_2)), externalUserAttributes);
        this.addUpdateUserChange(user, updatedExternalUser);
    }

    @Test
    void addUpdateUserChangeByAttribute() {
        HashMap<String, Object> userAttributes = new HashMap<String, Object>();
        userAttributes.put(ATTRIBUTE_1, ATTRIBUTE_1_VALUE);
        User user = SolutionChangesBuilderTest.mockUser(USER_1, Collections.singleton(new org.kie.kogito.taskassigning.core.model.Group(GROUP_1)), userAttributes);
        HashMap<String, Object> externalUserAttributes = new HashMap<String, Object>();
        externalUserAttributes.put(ATTRIBUTE_1, ATTRIBUTE_1_VALUE_CHANGED);
        org.kie.kogito.taskassigning.user.service.User updatedExternalUser = SolutionChangesBuilderTest.mockExternalUser(USER_1, Collections.singleton(SolutionChangesBuilderTest.mockExternalGroup(GROUP_1)), externalUserAttributes);
        this.addUpdateUserChange(user, updatedExternalUser);
    }

    private void addUpdateUserChange(User user, org.kie.kogito.taskassigning.user.service.User updatedExternalUser) {
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.singletonList(user), Collections.emptyList());
        UserDataEvent event = new UserDataEvent(Collections.singletonList(updatedExternalUser), ZonedDateTime.now());
        List result = SolutionChangesBuilder.create().withContext(this.context).withUserServiceConnector(this.userServiceConnector).fromTasksData(Collections.emptyList()).fromUserDataEvent(event).forSolution(solution).build();
        Set expectedGroups = updatedExternalUser.getGroups().stream().map(externalGroup -> new org.kie.kogito.taskassigning.core.model.Group(externalGroup.getId())).collect(Collectors.toSet());
        UserPropertyChangeProblemFactChange expected = new UserPropertyChangeProblemFactChange(user, true, updatedExternalUser.getAttributes(), expectedGroups);
        this.assertChangeIsTheChangeSetId(result, 0);
        SolutionChangesBuilderTest.assertChange((List<ProblemFactChange<TaskAssigningSolution>>)result, 1, expected);
    }

    @Test
    void addDisableUserChange() {
        User user = SolutionChangesBuilderTest.mockUser(USER_1);
        user.setEnabled(true);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.singletonList(user), Collections.emptyList());
        UserDataEvent event = new UserDataEvent(Collections.emptyList(), ZonedDateTime.now());
        List result = SolutionChangesBuilder.create().withContext(this.context).withUserServiceConnector(this.userServiceConnector).fromTasksData(Collections.emptyList()).fromUserDataEvent(event).forSolution(solution).build();
        DisableUserProblemFactChange expected = new DisableUserProblemFactChange(user);
        this.assertChangeIsTheChangeSetId(result, 0);
        SolutionChangesBuilderTest.assertChange((List<ProblemFactChange<TaskAssigningSolution>>)result, 1, expected);
    }

    @Test
    void addRemoveUserChange() {
        User user = SolutionChangesBuilderTest.mockUser(USER_1);
        user.setEnabled(false);
        TaskAssigningSolution solution = SolutionChangesBuilderTest.mockSolution(Collections.singletonList(user), Collections.emptyList());
        List result = SolutionChangesBuilder.create().withContext(this.context).withUserServiceConnector(this.userServiceConnector).fromTasksData(Collections.emptyList()).forSolution(solution).build();
        RemoveUserProblemFactChange expected = new RemoveUserProblemFactChange(user);
        this.assertChangeIsTheChangeSetId(result, 0);
        SolutionChangesBuilderTest.assertChange((List<ProblemFactChange<TaskAssigningSolution>>)result, 1, expected);
    }

    private static TaskAssigningSolution mockSolution(List<User> users, List<TaskAssignment> task) {
        return new TaskAssigningSolution("1", users, task);
    }

    private static List<TaskData> mockTaskDataList(TaskData ... tasks) {
        return Arrays.asList(tasks);
    }

    private static User mockUser(String userId) {
        return new User(userId);
    }

    private static User mockUser(String userId, Set<org.kie.kogito.taskassigning.core.model.Group> groups, Map<String, Object> attributes) {
        return new User(userId, true, groups, attributes);
    }

    private static Task mockTask(String taskId, String state) {
        return Task.newBuilder().id(taskId).state(state).build();
    }

    private static Task mockTask(String taskId) {
        return Task.newBuilder().id(taskId).build();
    }

    private static org.kie.kogito.taskassigning.user.service.User mockExternalUser(String userId) {
        return SolutionChangesBuilderTest.mockExternalUser(userId, Collections.emptySet(), Collections.emptyMap());
    }

    private static org.kie.kogito.taskassigning.user.service.User mockExternalUser(String userId, Set<Group> groups, Map<String, Object> attributes) {
        org.kie.kogito.taskassigning.user.service.User result = (org.kie.kogito.taskassigning.user.service.User)Mockito.mock(org.kie.kogito.taskassigning.user.service.User.class);
        ((org.kie.kogito.taskassigning.user.service.User)Mockito.doReturn((Object)userId).when((Object)result)).getId();
        ((org.kie.kogito.taskassigning.user.service.User)Mockito.doReturn(groups).when((Object)result)).getGroups();
        ((org.kie.kogito.taskassigning.user.service.User)Mockito.doReturn(attributes).when((Object)result)).getAttributes();
        return result;
    }

    private static Group mockExternalGroup(String groupId) {
        Group result = (Group)Mockito.mock(Group.class);
        ((Group)Mockito.doReturn((Object)groupId).when((Object)result)).getId();
        return result;
    }

    private void assertChangeIsTheChangeSetId(List<ProblemFactChange<TaskAssigningSolution>> result, int index) {
        long currentChangeSetId = this.context.getCurrentChangeSetId();
        result.get(index).doChange(this.scoreDirector);
        AssertionsForInterfaceTypes.assertThat((long)this.context.getCurrentChangeSetId()).isEqualTo(currentChangeSetId + 1L);
    }

    private static void assertChange(List<ProblemFactChange<TaskAssigningSolution>> result, int index, AddTaskProblemFactChange expected) {
        AssertionsForInterfaceTypes.assertThat(result.get(index)).isInstanceOf(AddTaskProblemFactChange.class);
        AddTaskProblemFactChange change = (AddTaskProblemFactChange)result.get(index);
        SolutionChangesBuilderTest.assertTaskEquals(expected.getTaskAssignment(), change.getTaskAssignment());
    }

    private static void assertChange(List<ProblemFactChange<TaskAssigningSolution>> result, int index, AssignTaskProblemFactChange expected) {
        AssertionsForInterfaceTypes.assertThat(result.get(index)).isInstanceOf(AssignTaskProblemFactChange.class);
        AssignTaskProblemFactChange change = (AssignTaskProblemFactChange)result.get(index);
        SolutionChangesBuilderTest.assertTaskEquals(expected.getTaskAssignment(), change.getTaskAssignment());
    }

    private static void assertChange(List<ProblemFactChange<TaskAssigningSolution>> result, int index, ReleaseTaskProblemFactChange expected) {
        AssertionsForInterfaceTypes.assertThat(result.get(index)).isInstanceOf(ReleaseTaskProblemFactChange.class);
        ReleaseTaskProblemFactChange change = (ReleaseTaskProblemFactChange)result.get(index);
        SolutionChangesBuilderTest.assertTaskEquals(expected.getTaskAssignment(), change.getTaskAssignment());
    }

    private static void assertChange(List<ProblemFactChange<TaskAssigningSolution>> result, int index, RemoveTaskProblemFactChange expected) {
        AssertionsForInterfaceTypes.assertThat(result.get(index)).isInstanceOf(RemoveTaskProblemFactChange.class);
        RemoveTaskProblemFactChange change = (RemoveTaskProblemFactChange)result.get(index);
        SolutionChangesBuilderTest.assertTaskEquals(expected.getTaskAssignment(), change.getTaskAssignment());
    }

    private static void assertChange(List<ProblemFactChange<TaskAssigningSolution>> result, int index, AddUserProblemFactChange expected) {
        AssertionsForInterfaceTypes.assertThat(result.get(index)).isInstanceOf(AddUserProblemFactChange.class);
        AddUserProblemFactChange change = (AddUserProblemFactChange)result.get(index);
        SolutionChangesBuilderTest.assertUserEquals(change.getUser(), expected.getUser());
    }

    private static void assertChange(List<ProblemFactChange<TaskAssigningSolution>> result, int index, UserPropertyChangeProblemFactChange expected) {
        AssertionsForInterfaceTypes.assertThat(result.get(index)).isInstanceOf(UserPropertyChangeProblemFactChange.class);
        UserPropertyChangeProblemFactChange change = (UserPropertyChangeProblemFactChange)result.get(index);
        SolutionChangesBuilderTest.assertUserEquals(change.getUser(), expected.getUser());
        AssertionsForInterfaceTypes.assertThat((Map)change.getNewAttributes()).isEqualTo((Object)expected.getNewAttributes());
        AssertionsForInterfaceTypes.assertThat((Iterable)change.getNewGroups()).isEqualTo((Object)expected.getNewGroups());
    }

    private static void assertChange(List<ProblemFactChange<TaskAssigningSolution>> result, int index, DisableUserProblemFactChange expected) {
        AssertionsForInterfaceTypes.assertThat(result.get(index)).isInstanceOf(DisableUserProblemFactChange.class);
        DisableUserProblemFactChange change = (DisableUserProblemFactChange)result.get(index);
        SolutionChangesBuilderTest.assertUserEquals(change.getUser(), expected.getUser());
    }

    private static void assertChange(List<ProblemFactChange<TaskAssigningSolution>> result, int index, RemoveUserProblemFactChange expected) {
        AssertionsForInterfaceTypes.assertThat(result.get(index)).isInstanceOf(RemoveUserProblemFactChange.class);
        RemoveUserProblemFactChange change = (RemoveUserProblemFactChange)result.get(index);
        SolutionChangesBuilderTest.assertUserEquals(change.getUser(), expected.getUser());
    }

    private static void assertTaskEquals(TaskAssignment t1, TaskAssignment t2) {
        AssertionsForInterfaceTypes.assertThat((String)t1.getId()).isEqualTo(t2.getId());
    }

    private static void assertUserEquals(User u1, User u2) {
        AssertionsForInterfaceTypes.assertThat((String)u1.getId()).isEqualTo(u2.getId());
    }

    private void assertTaskPublishStatus(String taskId, boolean published) {
        AssertionsForInterfaceTypes.assertThat((boolean)this.context.isTaskPublished(taskId)).isEqualTo(published);
    }
}

