/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.kogito.taskassigning.index.service.client.graphql.UserTaskInstance;
import org.kie.kogito.taskassigning.service.RunnableBaseTest;
import org.kie.kogito.taskassigning.service.SolutionDataLoader;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TaskServiceConnector;
import org.kie.kogito.taskassigning.user.service.User;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

class SolutionDataLoaderTest
extends RunnableBaseTest<SolutionDataLoader> {
    private static final String TASK_ID = "TASK_ID";
    private static final Duration DURATION = Duration.of(10L, ChronoUnit.MILLIS);
    private static final int RETRIES = 5;
    private static final int PAGE_SIZE = 10;
    @Mock
    private TaskServiceConnector taskServiceConnector;
    @Mock
    private UserServiceConnector userServiceConnector;
    @Captor
    private ArgumentCaptor<SolutionDataLoader.Result> resultCaptor;
    @Mock
    private Consumer<SolutionDataLoader.Result> resultConsumer;
    private CountDownLatch resultApplied;

    SolutionDataLoaderTest() {
    }

    @Override
    protected SolutionDataLoader createRunnableBase() {
        return (SolutionDataLoader)Mockito.spy((Object)((Object)new SolutionDataLoaderMock(this.taskServiceConnector, this.userServiceConnector)));
    }

    @Test
    @Timeout(value=5L)
    void startWithSuccessfulExecution() throws Exception {
        CompletableFuture<Void> future = this.startRunnableBase();
        List<List> taskServiceResults = Arrays.asList(new ArrayList(), null, Collections.singletonList(SolutionDataLoaderTest.createUserTaskInstance()));
        List<List> userServiceResults = Arrays.asList(null, Collections.singletonList(SolutionDataLoaderTest.createExternalUser()));
        ((TaskServiceConnector)Mockito.doAnswer((Answer)this.createExecutions(taskServiceResults)).when((Object)this.taskServiceConnector)).findAllTasks(ArgumentMatchers.anyList(), ArgumentMatchers.eq((int)10));
        ((UserServiceConnector)Mockito.doAnswer((Answer)this.createExecutions(userServiceResults)).when((Object)this.userServiceConnector)).findAllUsers();
        this.resultApplied = new CountDownLatch(1);
        ((SolutionDataLoader)this.runnableBase).start(this.resultConsumer, true, true, DURATION, 5, 10);
        this.resultApplied.await();
        ((SolutionDataLoader)this.runnableBase).destroy();
        future.get();
        Assertions.assertThat((boolean)((SolutionDataLoader)this.runnableBase).isDestroyed()).isTrue();
        ((Consumer)Mockito.verify(this.resultConsumer)).accept((SolutionDataLoader.Result)this.resultCaptor.capture());
        Assertions.assertThat((boolean)((SolutionDataLoader.Result)this.resultCaptor.getValue()).hasErrors()).isFalse();
        SolutionDataLoader.Result result = (SolutionDataLoader.Result)this.resultCaptor.getValue();
        ((ObjectAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)result.getTasks()).isNotNull()).hasSize(1)).element(0)).isNotNull();
        Assertions.assertThat((String)((TaskData)result.getTasks().get(0)).getId()).isEqualTo(TASK_ID);
        Assertions.assertThat((List)result.getUsers()).isSameAs((Object)userServiceResults.get(1));
    }

    @Test
    @Timeout(value=5L)
    void startWithUnsuccessfulExecution() throws Exception {
        CompletableFuture<Void> future = this.startRunnableBase();
        List<List> taskServiceResults = Arrays.asList(new ArrayList(), null, new ArrayList(), new ArrayList(), new ArrayList(), null);
        List<List> userServiceResults = Arrays.asList(null, null, null, null);
        ((TaskServiceConnector)Mockito.doAnswer((Answer)this.createExecutions(taskServiceResults)).when((Object)this.taskServiceConnector)).findAllTasks(ArgumentMatchers.anyList(), ArgumentMatchers.eq((int)10));
        ((UserServiceConnector)Mockito.doAnswer((Answer)this.createExecutions(userServiceResults)).when((Object)this.userServiceConnector)).findAllUsers();
        this.resultApplied = new CountDownLatch(1);
        ((SolutionDataLoader)this.runnableBase).start(this.resultConsumer, true, true, DURATION, 5, 10);
        this.resultApplied.await();
        ((SolutionDataLoader)this.runnableBase).destroy();
        future.get();
        Assertions.assertThat((boolean)((SolutionDataLoader)this.runnableBase).isDestroyed()).isTrue();
        ((Consumer)Mockito.verify(this.resultConsumer)).accept((SolutionDataLoader.Result)this.resultCaptor.capture());
        Assertions.assertThat((boolean)((SolutionDataLoader.Result)this.resultCaptor.getValue()).hasErrors()).isTrue();
    }

    private static UserTaskInstance createUserTaskInstance() {
        UserTaskInstance userTaskInstance = new UserTaskInstance();
        userTaskInstance.setId(TASK_ID);
        return userTaskInstance;
    }

    private static User createExternalUser() {
        return (User)Mockito.mock(User.class);
    }

    private <T> Answer createExecutions(final List<T> results) {
        return new Answer(){
            private int invocations = 0;

            public Object answer(InvocationOnMock invocation) {
                Object result;
                if ((result = results.get(this.invocations++)) == null) {
                    throw new RuntimeException("Emulate an error, the loader must retry.");
                }
                return result;
            }
        };
    }

    private class SolutionDataLoaderMock
    extends SolutionDataLoader {
        public SolutionDataLoaderMock(TaskServiceConnector taskServiceConnector, UserServiceConnector userServiceConnector) {
            super(taskServiceConnector, userServiceConnector);
        }

        protected void applyResult(SolutionDataLoader.Result result) {
            super.applyResult(result);
            SolutionDataLoaderTest.this.resultApplied.countDown();
        }
    }
}

