/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.service.RunnableBaseTest;
import org.kie.kogito.taskassigning.service.SolverExecutor;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;

class SolverExecutorTest
extends RunnableBaseTest<SolverExecutor> {
    private Solver<TaskAssigningSolution> solver;
    @Mock
    private TaskAssigningSolution solution;
    @Mock
    private SolverFactory<TaskAssigningSolution> solverFactory;
    @Mock
    private SolverEventListener<TaskAssigningSolution> eventListener;
    @Captor
    private ArgumentCaptor<SolverEventListener<TaskAssigningSolution>> eventListenerCaptor;
    @Mock
    private BestSolutionChangedEvent<TaskAssigningSolution> event;
    private CountDownLatch startFinished = new CountDownLatch(1);

    SolverExecutorTest() {
    }

    @Override
    protected SolverExecutor createRunnableBase() {
        this.solver = (Solver)Mockito.spy((Object)new SolverMock());
        return (SolverExecutor)Mockito.spy((Object)new SolverExecutor(this.solverFactory, this.eventListener));
    }

    @Test
    @Timeout(value=5L)
    void start() throws Exception {
        CompletableFuture<Void> future = this.startRunnableBase();
        ((SolverFactory)Mockito.doReturn(this.solver).when(this.solverFactory)).buildSolver();
        ((SolverExecutor)this.runnableBase).start(this.solution);
        this.startFinished.await();
        Assertions.assertThat((boolean)((SolverExecutor)this.runnableBase).isStarted()).isTrue();
        ((Solver)Mockito.verify(this.solver)).addEventListener((SolverEventListener)this.eventListenerCaptor.capture());
        ((SolverEventListener)this.eventListenerCaptor.getValue()).bestSolutionChanged(this.event);
        ((SolverEventListener)Mockito.verify(this.eventListener)).bestSolutionChanged(this.event);
        ((SolverExecutor)this.runnableBase).destroy();
        future.get();
        Assertions.assertThat((boolean)((SolverExecutor)this.runnableBase).isDestroyed()).isTrue();
    }

    @Test
    void startWithFailure() {
        ((SolverFactory)Mockito.doReturn(this.solver).when(this.solverFactory)).buildSolver();
        ((SolverExecutor)this.runnableBase).start(this.solution);
        Assertions.assertThatThrownBy(() -> ((SolverExecutor)this.runnableBase).start(this.solution)).hasMessage("start method can only be invoked when the status is STOPPED");
    }

    @Test
    void startWithBuildFailure() {
        RuntimeException error = new RuntimeException("An error was produced...!");
        ((SolverFactory)Mockito.doThrow((Throwable[])new Throwable[]{error}).when(this.solverFactory)).buildSolver();
        Assertions.assertThatThrownBy(() -> ((SolverExecutor)this.runnableBase).start(this.solution)).hasMessage(error.getMessage());
        Assertions.assertThat((boolean)((SolverExecutor)this.runnableBase).isStopped()).isTrue();
    }

    @Test
    @Timeout(value=5L)
    void stopWithSolverStarted() throws Exception {
        CompletableFuture<Void> future = this.startRunnableBase();
        ((SolverFactory)Mockito.doReturn(this.solver).when(this.solverFactory)).buildSolver();
        ((SolverExecutor)this.runnableBase).start(this.solution);
        this.startFinished.await();
        Assertions.assertThat((boolean)((SolverExecutor)this.runnableBase).isStarted()).isTrue();
        ((Solver)Mockito.verify(this.solver)).addEventListener((SolverEventListener)this.eventListenerCaptor.capture());
        ((SolverEventListener)this.eventListenerCaptor.getValue()).bestSolutionChanged(this.event);
        ((SolverEventListener)Mockito.verify(this.eventListener)).bestSolutionChanged(this.event);
        ((SolverExecutor)this.runnableBase).stop();
        ((SolverExecutor)this.runnableBase).destroy();
        future.get();
        Assertions.assertThat((boolean)((SolverExecutor)this.runnableBase).isDestroyed()).isTrue();
        ((Solver)Mockito.verify(this.solver)).terminateEarly();
    }

    @Test
    void stopWithSolverNotStarted() {
        ((SolverExecutor)this.runnableBase).stop();
        ((SolverExecutor)this.runnableBase).destroy();
        Assertions.assertThat((boolean)((SolverExecutor)this.runnableBase).isDestroyed()).isTrue();
        ((Solver)Mockito.verify(this.solver, (VerificationMode)Mockito.never())).terminateEarly();
    }

    @Test
    @Timeout(value=5L)
    void addProblemFactChanges() throws Exception {
        CompletableFuture<Void> future = this.startRunnableBase();
        ((SolverFactory)Mockito.doReturn(this.solver).when(this.solverFactory)).buildSolver();
        ((SolverExecutor)this.runnableBase).start(this.solution);
        this.startFinished.await();
        List changes = Collections.emptyList();
        ((SolverExecutor)this.runnableBase).addProblemFactChanges(changes);
        ((Solver)Mockito.verify(this.solver)).addProblemFactChanges(changes);
        ((SolverExecutor)this.runnableBase).destroy();
        future.get();
        Assertions.assertThat((boolean)((SolverExecutor)this.runnableBase).isDestroyed()).isTrue();
    }

    @Test
    void addProblemFactChangesWithFailure() {
        List changes = Collections.emptyList();
        Assertions.assertThatThrownBy(() -> ((SolverExecutor)this.runnableBase).addProblemFactChanges(changes)).hasMessage("SolverExecutor has not been started. Be sure it's started and not stopped or destroyed prior to executing this method");
    }

    @AfterEach
    void cleanUp() {
        this.disposeSolver();
    }

    private void disposeSolver() {
        ((SolverMock)this.solver).dispose();
    }

    private class SolverMock
    implements Solver<TaskAssigningSolution> {
        private final Semaphore finishSolverWork = new Semaphore(0);
        private CompletableFuture<Void> action;

        private SolverMock() {
        }

        public void dispose() {
            this.finishSolverWork.release();
        }

        public TaskAssigningSolution solve(TaskAssigningSolution problem) {
            SolverExecutorTest.this.startFinished.countDown();
            this.action = CompletableFuture.runAsync(() -> {
                try {
                    this.finishSolverWork.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SolverExecutorTest.this.LOGGER.debug(e.getMessage());
                }
            });
            try {
                this.action.get();
            }
            catch (ExecutionException e) {
                SolverExecutorTest.this.LOGGER.debug(e.getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SolverExecutorTest.this.LOGGER.debug(e.getMessage());
            }
            return null;
        }

        public boolean terminateEarly() {
            this.finishSolverWork.release();
            return true;
        }

        public boolean isSolving() {
            return false;
        }

        public boolean isTerminateEarly() {
            return false;
        }

        public boolean addProblemFactChange(ProblemFactChange<TaskAssigningSolution> problemFactChange) {
            return false;
        }

        public boolean addProblemFactChanges(List<ProblemFactChange<TaskAssigningSolution>> problemFactChanges) {
            return false;
        }

        public boolean isEveryProblemFactChangeProcessed() {
            return false;
        }

        public void addEventListener(SolverEventListener<TaskAssigningSolution> eventListener) {
        }

        public void removeEventListener(SolverEventListener<TaskAssigningSolution> eventListener) {
        }
    }
}

