/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceContext;
import org.kie.kogito.taskassigning.service.TestUtil;

class TaskAssigningServiceContextTest {
    private static final String TASK_ID = "TASK_ID";
    private static final ZonedDateTime TASK_LAST_UPDATE = TestUtil.parseZonedDateTime("2021-03-11T10:00:00.001Z");
    private TaskAssigningServiceContext context;

    TaskAssigningServiceContextTest() {
    }

    @BeforeEach
    void setUp() {
        this.context = new TaskAssigningServiceContext();
    }

    @Test
    void currentChangeSetId() {
        this.context.setCurrentChangeSetId(2L);
        Assertions.assertThat((long)this.context.getCurrentChangeSetId()).isEqualTo(2L);
    }

    @Test
    void nextChangeSetId() {
        for (int i = 1; i < 10; ++i) {
            Assertions.assertThat((long)this.context.nextChangeSetId()).isEqualTo((long)i);
        }
    }

    @Test
    void isProcessedChangeSet() {
        this.context.setProcessedChangeSet(5L);
        for (int i = 0; i <= 5; ++i) {
            Assertions.assertThat((boolean)this.context.isProcessedChangeSet((long)i)).isTrue();
        }
    }

    @Test
    void isCurrentChangeSetProcessed() {
        this.context.setCurrentChangeSetId(5L);
        Assertions.assertThat((boolean)this.context.isCurrentChangeSetProcessed()).isFalse();
        this.context.setProcessedChangeSet(5L);
        Assertions.assertThat((boolean)this.context.isCurrentChangeSetProcessed()).isTrue();
    }

    @Test
    void setTaskPublished() {
        this.setTaskPublished(TASK_ID, true);
        this.setTaskPublished(TASK_ID, false);
    }

    private void setTaskPublished(String taskId, boolean published) {
        this.context.setTaskPublished(taskId, published);
        Assertions.assertThat((boolean)this.context.isTaskPublished(taskId)).isEqualTo(published);
    }

    @Test
    void setLastTaskEventTime() {
        this.context.setTaskLastEventTime(TASK_ID, TASK_LAST_UPDATE);
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_ID)).isEqualTo((Object)TASK_LAST_UPDATE);
    }

    @Test
    void isNewTaskEventTimeWhenNotSet() {
        Assertions.assertThat((boolean)this.context.isNewTaskEventTime(TASK_ID, TASK_LAST_UPDATE)).isTrue();
    }

    @Test
    void isNewTaskEventTimeWhenLessThanSet() {
        this.context.setTaskLastEventTime(TASK_ID, TASK_LAST_UPDATE);
        Assertions.assertThat((boolean)this.context.isNewTaskEventTime(TASK_ID, TASK_LAST_UPDATE.minus(1L, ChronoUnit.MILLIS))).isFalse();
    }

    @Test
    void isNewTaskEventTimeWhenEqualThanSet() {
        this.context.setTaskLastEventTime(TASK_ID, TASK_LAST_UPDATE);
        Assertions.assertThat((boolean)this.context.isNewTaskEventTime(TASK_ID, TASK_LAST_UPDATE)).isFalse();
    }

    @Test
    void isNewTaskEventTimeWhenGreaterThanSet() {
        this.context.setTaskLastEventTime(TASK_ID, TASK_LAST_UPDATE);
        Assertions.assertThat((boolean)this.context.isNewTaskEventTime(TASK_ID, TASK_LAST_UPDATE.plus(1L, ChronoUnit.MILLIS))).isTrue();
    }
}

