/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceHelper;
import org.kie.kogito.taskassigning.service.UserServiceConnectorRegistry;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TaskAssigningServiceHelperTest {
    private static final String CONNECTOR_NAME = "CONNECTOR_NAME";
    @Mock
    private UserServiceConnectorRegistry connectorRegistry;
    @Mock
    private TaskAssigningConfig config;
    @Mock
    private UserServiceConnector connector;
    private TaskAssigningServiceHelper serviceHelper;

    TaskAssigningServiceHelperTest() {
    }

    @BeforeEach
    void setUp() {
        this.serviceHelper = new TaskAssigningServiceHelper();
        this.serviceHelper.userServiceConnectorRegistry = this.connectorRegistry;
        this.serviceHelper.config = this.config;
        ((TaskAssigningConfig)Mockito.doReturn((Object)CONNECTOR_NAME).when((Object)this.config)).getUserServiceConnector();
    }

    @Test
    void validateAndGetUserServiceConnectorSuccessful() {
        ((UserServiceConnectorRegistry)Mockito.doReturn((Object)this.connector).when((Object)this.connectorRegistry)).get(CONNECTOR_NAME);
        Assertions.assertThat((Object)this.serviceHelper.validateAndGetUserServiceConnector()).isSameAs((Object)this.connector);
    }

    @Test
    void validateAndGetUserServiceConnectorUnsuccessful() {
        Assertions.assertThatThrownBy(() -> this.serviceHelper.validateAndGetUserServiceConnector()).hasMessageStartingWith("No user service connector was found");
    }
}

