/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import io.quarkus.runtime.ShutdownEvent;
import java.net.URL;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.ClientServices;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AddTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AddUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AssignTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.RemoveTaskProblemFactChange;
import org.kie.kogito.taskassigning.service.PlanningExecutionResult;
import org.kie.kogito.taskassigning.service.PlanningExecutionResultItem;
import org.kie.kogito.taskassigning.service.PlanningExecutor;
import org.kie.kogito.taskassigning.service.PlanningItem;
import org.kie.kogito.taskassigning.service.SolutionDataLoader;
import org.kie.kogito.taskassigning.service.SolverExecutor;
import org.kie.kogito.taskassigning.service.TaskAssigningService;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceContext;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceHelper;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TaskServiceConnector;
import org.kie.kogito.taskassigning.service.TaskState;
import org.kie.kogito.taskassigning.service.TestUtil;
import org.kie.kogito.taskassigning.service.UserServiceAdapter;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.service.event.BufferedTaskAssigningServiceEventConsumer;
import org.kie.kogito.taskassigning.service.event.DataEvent;
import org.kie.kogito.taskassigning.service.event.TaskAssigningServiceEventConsumer;
import org.kie.kogito.taskassigning.service.event.TaskDataEvent;
import org.kie.kogito.taskassigning.service.event.UserDataEvent;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;

@ExtendWith(value={MockitoExtension.class})
class TaskAssigningServiceTest {
    private static final String DATA_INDEX_SERVER_URL = "http://localhost:8180/graphql";
    private static final String USER_1_ID = "USER_1_ID";
    private static final String USER_2_ID = "USER_2_ID";
    private static final String USER_3_ID = "USER_3_ID";
    private static final String TASK_1_ID = "TASK_1_ID";
    private static final ZonedDateTime TASK_1_LAST_UPDATE = TestUtil.parseZonedDateTime("2021-03-11T10:00:00.001Z");
    private static final String TASK_2_ID = "TASK_2_ID";
    private static final ZonedDateTime TASK_2_LAST_UPDATE = TestUtil.parseZonedDateTime("2021-03-11T11:00:00.001Z");
    private static final String TASK_3_ID = "TASK_3_ID";
    private static final ZonedDateTime TASK_3_LAST_UPDATE = TestUtil.parseZonedDateTime("2021-03-11T12:00:00.001Z");
    private static final String TASK_4_ID = "TASK_4_ID";
    private static final ZonedDateTime TASK_4_LAST_UPDATE = TestUtil.parseZonedDateTime("2021-03-11T13:00:00.001Z");
    private static final ZonedDateTime USER_DATA_EVENT_1_TIME = TestUtil.parseZonedDateTime("2021-03-11T15:00:00.001Z");
    private static final ZonedDateTime USER_DATA_EVENT_2_TIME = TestUtil.parseZonedDateTime("2021-03-11T15:00:00.002Z");
    private static final Duration DATA_LOADER_RETRY_INTERVAL = Duration.ofMillis(5000L);
    private static final int DATA_LOADER_RETRIES = 5;
    private static final int DATA_LOADER_PAGE_SIZE = 10;
    private static final int PUBLISH_WINDOW_SIZE = 5;
    @Mock
    private SolverFactory<TaskAssigningSolution> solverFactory;
    @Mock
    private TaskAssigningConfig config;
    @Mock
    private ManagedExecutor managedExecutor;
    @Mock
    private TaskServiceConnector taskServiceConnector;
    @Mock
    private UserServiceConnector userServiceConnector;
    @Mock
    private UserServiceAdapter userServiceAdapter;
    @Mock
    private BufferedTaskAssigningServiceEventConsumer serviceEventConsumer;
    @Mock
    private ClientServices clientServices;
    @Mock
    private SolverExecutor solverExecutor;
    @Mock
    private PlanningExecutor planningExecutor;
    @Mock
    private SolutionDataLoader solutionDataLoader;
    @Mock
    private TaskAssigningServiceHelper serviceHelper;
    private TaskAssigningServiceContext context;
    @Captor
    private ArgumentCaptor<SolverEventListener<TaskAssigningSolution>> solverListenerCaptor;
    @Captor
    private ArgumentCaptor<Consumer<SolutionDataLoader.Result>> solutionDataLoaderConsumerCaptor;
    @Captor
    private ArgumentCaptor<Consumer<List<DataEvent<?>>>> dataEventsConsumerCaptor;
    @Captor
    private ArgumentCaptor<List<PlanningItem>> planningCaptor;
    @Captor
    private ArgumentCaptor<TaskAssigningSolution> solutionCaptor;
    @Captor
    private ArgumentCaptor<List<ProblemFactChange<TaskAssigningSolution>>> problemFactChangesCaptor;
    @Mock
    SolverEventListener<TaskAssigningSolution> solverEventListener;
    private TaskAssigningService taskAssigningService;
    private CountDownLatch eventsProcessed;

    TaskAssigningServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.context = (TaskAssigningServiceContext)Mockito.spy((Object)new TaskAssigningServiceContext());
        this.taskAssigningService = (TaskAssigningService)Mockito.spy((Object)((Object)new TaskAssigningServiceMock()));
        this.taskAssigningService.solverFactory = this.solverFactory;
        this.taskAssigningService.config = this.config;
        this.taskAssigningService.managedExecutor = this.managedExecutor;
        this.taskAssigningService.taskServiceConnector = this.taskServiceConnector;
        this.taskAssigningService.serviceEventConsumer = this.serviceEventConsumer;
        this.taskAssigningService.clientServices = this.clientServices;
        this.taskAssigningService.serviceHelper = this.serviceHelper;
    }

    @Test
    void start() throws Exception {
        this.prepareStart();
    }

    @Test
    void startWithSolverValidationFailure() throws Exception {
        ((TaskAssigningConfig)Mockito.doReturn((Object)new URL(DATA_INDEX_SERVER_URL)).when((Object)this.config)).getDataIndexServerUrl();
        ((TaskAssigningServiceHelper)Mockito.doReturn((Object)this.userServiceConnector).when((Object)this.serviceHelper)).validateAndGetUserServiceConnector();
        String errorMessage = "Solver factory error";
        ((SolverFactory)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(errorMessage)}).when(this.solverFactory)).buildSolver();
        Assertions.assertThatThrownBy(() -> this.taskAssigningService.start()).hasMessage(errorMessage);
    }

    @Test
    void startWithConfigValidationFailure() {
        ((TaskAssigningConfig)Mockito.doReturn(null).when((Object)this.config)).getDataIndexServerUrl();
        Assertions.assertThatThrownBy(() -> this.taskAssigningService.start()).hasMessage("A config value must be set for the property: kogito.task-assigning.data-index.server-url");
    }

    @Test
    void startWithUserServiceValidationFailure() throws Exception {
        ((TaskAssigningConfig)Mockito.doReturn((Object)new URL(DATA_INDEX_SERVER_URL)).when((Object)this.config)).getDataIndexServerUrl();
        String errorMessage = "User service validate and get error";
        ((TaskAssigningServiceHelper)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(errorMessage)}).when((Object)this.serviceHelper)).validateAndGetUserServiceConnector();
        Assertions.assertThatThrownBy(() -> this.taskAssigningService.start()).hasMessage(errorMessage);
    }

    @Test
    void startWithDataLoadErrors() throws Exception {
        this.prepareStart();
        SolutionDataLoader.Result result = new SolutionDataLoader.Result(Collections.singletonList(new Exception("Data loading error")));
        ((Consumer)this.solutionDataLoaderConsumerCaptor.getValue()).accept(result);
        ((SolutionDataLoader)Mockito.verify((Object)this.solutionDataLoader, (VerificationMode)Mockito.times((int)2))).start((Consumer)this.solutionDataLoaderConsumerCaptor.capture(), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true), (Duration)ArgumentMatchers.eq((Object)DATA_LOADER_RETRY_INTERVAL), ArgumentMatchers.eq((int)5), ArgumentMatchers.eq((int)10));
    }

    @Test
    void startWithSolutionDataLoadAndNonEmptySolution() throws Exception {
        SolutionDataLoader.Result result = new SolutionDataLoader.Result(Arrays.asList(TestUtil.mockTaskData(TASK_1_ID, TaskState.READY.value(), TASK_1_LAST_UPDATE), TestUtil.mockTaskData(TASK_2_ID, TaskState.RESERVED.value(), TASK_2_LAST_UPDATE)), Collections.singletonList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID)));
        this.prepareStart();
        ((Consumer)this.solutionDataLoaderConsumerCaptor.getValue()).accept(result);
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor)).start((TaskAssigningSolution)ArgumentMatchers.any());
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer, (VerificationMode)Mockito.never())).resume();
        Assertions.assertThat((boolean)this.context.isTaskPublished(TASK_1_ID)).isFalse();
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_1_ID)).isEqualTo((Object)TASK_1_LAST_UPDATE);
        Assertions.assertThat((boolean)this.context.isTaskPublished(TASK_2_ID)).isTrue();
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_2_ID)).isEqualTo((Object)TASK_2_LAST_UPDATE);
    }

    @Test
    void startWithSolutionDataLoadAndEmptySolution() throws Exception {
        SolutionDataLoader.Result result = new SolutionDataLoader.Result(Collections.emptyList(), Collections.emptyList());
        this.prepareStart();
        ((Consumer)this.solutionDataLoaderConsumerCaptor.getValue()).accept(result);
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor, (VerificationMode)Mockito.never())).start((TaskAssigningSolution)ArgumentMatchers.any());
        ((TaskAssigningServiceContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).setTaskPublished(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((TaskAssigningServiceContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).setTaskPublished(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer)).resume();
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor, (VerificationMode)Mockito.never())).start((TaskAssigningSolution)ArgumentMatchers.any());
    }

    @Test
    @Timeout(value=5L)
    void startSolutionFromEventsAndEmptySolution() throws Exception {
        this.eventsProcessed = new CountDownLatch(1);
        this.prepareStart();
        SolutionDataLoader.Result initialEmptyData = new SolutionDataLoader.Result(Collections.emptyList(), Collections.emptyList());
        ((Consumer)this.solutionDataLoaderConsumerCaptor.getValue()).accept(initialEmptyData);
        List<DataEvent> eventList = Arrays.asList(TaskAssigningServiceTest.mockTaskDataEvent(TASK_1_ID, TaskState.READY.value(), TASK_1_LAST_UPDATE), TaskAssigningServiceTest.mockTaskDataEvent(TASK_2_ID, TaskState.ABORTED.value(), TASK_2_LAST_UPDATE));
        ((Consumer)this.dataEventsConsumerCaptor.getValue()).accept(eventList);
        this.eventsProcessed.await();
        List<DataEvent> queuedEventList = Arrays.asList(TaskAssigningServiceTest.mockTaskDataEvent(TASK_1_ID, TaskState.COMPLETED.value(), TASK_1_LAST_UPDATE.plusSeconds(1L)), TaskAssigningServiceTest.mockTaskDataEvent(TASK_3_ID, TaskState.SKIPPED.value(), TASK_3_LAST_UPDATE));
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.doReturn((Object)queuedEventList.size()).when((Object)this.serviceEventConsumer)).queuedEvents();
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.doReturn(queuedEventList).when((Object)this.serviceEventConsumer)).pollEvents();
        SolutionDataLoader.Result userData = new SolutionDataLoader.Result(Collections.emptyList(), Collections.singletonList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID)));
        ((Consumer)this.solutionDataLoaderConsumerCaptor.getValue()).accept(userData);
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor, (VerificationMode)Mockito.never())).start((TaskAssigningSolution)ArgumentMatchers.any());
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer, (VerificationMode)Mockito.times((int)2))).resume();
        ((TaskAssigningServiceContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).setTaskPublished((String)ArgumentMatchers.eq((Object)TASK_1_ID), ArgumentMatchers.anyBoolean());
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_1_ID)).isEqualTo((Object)TASK_1_LAST_UPDATE.plusSeconds(1L));
        ((TaskAssigningServiceContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).setTaskPublished((String)ArgumentMatchers.eq((Object)TASK_2_ID), ArgumentMatchers.anyBoolean());
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_2_ID)).isEqualTo((Object)TASK_2_LAST_UPDATE);
        ((TaskAssigningServiceContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).setTaskPublished((String)ArgumentMatchers.eq((Object)TASK_3_ID), ArgumentMatchers.anyBoolean());
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_3_ID)).isEqualTo((Object)TASK_3_LAST_UPDATE);
    }

    @Test
    @Timeout(value=5L)
    void startSolutionFromEventsAndNonEmptySolution() throws Exception {
        this.eventsProcessed = new CountDownLatch(1);
        this.prepareStart();
        SolutionDataLoader.Result initialEmptyData = new SolutionDataLoader.Result(Collections.emptyList(), Collections.emptyList());
        ((Consumer)this.solutionDataLoaderConsumerCaptor.getValue()).accept(initialEmptyData);
        List<DataEvent> eventList = Arrays.asList(TaskAssigningServiceTest.mockTaskDataEvent(TASK_1_ID, TaskState.READY.value(), TASK_1_LAST_UPDATE), TaskAssigningServiceTest.mockTaskDataEvent(TASK_2_ID, TaskState.RESERVED.value(), TASK_2_LAST_UPDATE));
        ((Consumer)this.dataEventsConsumerCaptor.getValue()).accept(eventList);
        this.eventsProcessed.await();
        List<DataEvent> queuedEventList = Arrays.asList(TaskAssigningServiceTest.mockTaskDataEvent(TASK_3_ID, TaskState.READY.value(), TASK_3_LAST_UPDATE), TaskAssigningServiceTest.mockTaskDataEvent(TASK_4_ID, TaskState.COMPLETED.value(), TASK_4_LAST_UPDATE));
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.doReturn((Object)queuedEventList.size()).when((Object)this.serviceEventConsumer)).queuedEvents();
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.doReturn(queuedEventList).when((Object)this.serviceEventConsumer)).pollEvents();
        SolutionDataLoader.Result userData = new SolutionDataLoader.Result(Collections.emptyList(), Collections.singletonList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID)));
        ((Consumer)this.solutionDataLoaderConsumerCaptor.getValue()).accept(userData);
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor)).start((TaskAssigningSolution)ArgumentMatchers.any());
        Assertions.assertThat((boolean)this.context.isTaskPublished(TASK_1_ID)).isFalse();
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_1_ID)).isEqualTo((Object)TASK_1_LAST_UPDATE);
        Assertions.assertThat((boolean)this.context.isTaskPublished(TASK_2_ID)).isTrue();
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_2_ID)).isEqualTo((Object)TASK_2_LAST_UPDATE);
        Assertions.assertThat((boolean)this.context.isTaskPublished(TASK_3_ID)).isFalse();
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_3_ID)).isEqualTo((Object)TASK_3_LAST_UPDATE);
        ((TaskAssigningServiceContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).setTaskPublished((String)ArgumentMatchers.eq((Object)TASK_4_ID), ArgumentMatchers.anyBoolean());
        Assertions.assertThat((ZonedDateTime)this.context.getTaskLastEventTime(TASK_4_ID)).isEqualTo((Object)TASK_4_LAST_UPDATE);
    }

    @Test
    void onTaskEventsWithExistingSolutionAndThereAreChanges() throws Exception {
        SolutionDataLoader.Result result = new SolutionDataLoader.Result(Collections.singletonList(TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_1_ID, TASK_1_LAST_UPDATE)), Collections.singletonList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID)));
        this.prepareStartAndSetInitialSolution(result);
        List<DataEvent> eventList = Arrays.asList(TaskAssigningServiceTest.mockTaskDataEvent(TASK_2_ID, TaskState.READY.value(), TASK_2_LAST_UPDATE), TaskAssigningServiceTest.mockTaskDataEvent(TASK_3_ID, TaskState.READY.value(), TASK_3_LAST_UPDATE));
        this.eventsProcessed = new CountDownLatch(1);
        ((Consumer)this.dataEventsConsumerCaptor.getValue()).accept(eventList);
        this.eventsProcessed.await();
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor)).addProblemFactChanges((List)this.problemFactChangesCaptor.capture());
        ((ListAssert)Assertions.assertThat((List)((List)this.problemFactChangesCaptor.getValue())).isNotNull()).hasSize(3);
        TaskAssigningServiceTest.assertHasAddTaskChangeForTask((List)this.problemFactChangesCaptor.getValue(), TASK_2_ID);
        TaskAssigningServiceTest.assertHasAddTaskChangeForTask((List)this.problemFactChangesCaptor.getValue(), TASK_3_ID);
    }

    @Test
    void onTaskEventsWithExistingSolutionAndThereAreNoChanges() throws Exception {
        SolutionDataLoader.Result result = new SolutionDataLoader.Result(Collections.singletonList(TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_1_ID, TASK_1_LAST_UPDATE)), Collections.singletonList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID)));
        this.prepareStartAndSetInitialSolution(result);
        List<DataEvent> eventList = Arrays.asList(TaskAssigningServiceTest.mockTaskDataEvent(TASK_2_ID, TaskState.ABORTED.value(), TASK_2_LAST_UPDATE), TaskAssigningServiceTest.mockTaskDataEvent(TASK_3_ID, TaskState.ABORTED.value(), TASK_3_LAST_UPDATE));
        this.eventsProcessed = new CountDownLatch(1);
        ((Consumer)this.dataEventsConsumerCaptor.getValue()).accept(eventList);
        this.eventsProcessed.await();
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor, (VerificationMode)Mockito.never())).addProblemFactChanges((List)ArgumentMatchers.any());
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer, (VerificationMode)Mockito.times((int)2))).resume();
    }

    @Test
    void onSolutionChangeWithPlanningItems() throws Exception {
        this.prepareStart();
        TaskAssigningSolution solution = this.buildSolution();
        this.context.setTaskPublished(TASK_1_ID, false);
        this.context.setTaskPublished(TASK_2_ID, true);
        this.context.setTaskPublished(TASK_3_ID, false);
        this.context.setTaskPublished(TASK_4_ID, true);
        this.taskAssigningService.onBestSolutionChange(TaskAssigningServiceTest.mockEvent(solution, true, true));
        ((PlanningExecutor)Mockito.verify((Object)this.planningExecutor)).start((List)this.planningCaptor.capture(), (Consumer)ArgumentMatchers.any());
        List planningItems = (List)this.planningCaptor.getValue();
        ((ListAssert)Assertions.assertThat((List)planningItems).isNotNull()).hasSize(2);
    }

    @Test
    void onSolutionChangeWithNoPlanningItems() throws Exception {
        this.prepareStart();
        TaskAssigningSolution solution = this.buildSolution();
        this.context.setTaskPublished(TASK_1_ID, true);
        this.context.setTaskPublished(TASK_2_ID, true);
        this.context.setTaskPublished(TASK_3_ID, true);
        this.context.setTaskPublished(TASK_4_ID, true);
        this.taskAssigningService.onBestSolutionChange(TaskAssigningServiceTest.mockEvent(solution, true, true));
        ((PlanningExecutor)Mockito.verify((Object)this.planningExecutor, (VerificationMode)Mockito.never())).start((List)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer)).resume();
    }

    @Test
    void onSolutionChangeWhenApplyingPlanningExecutionResult() throws Exception {
        this.prepareStart();
        TaskAssigningSolution initialSolution = this.buildSolution();
        this.context.setTaskPublished(TASK_1_ID, false);
        this.context.setTaskPublished(TASK_2_ID, true);
        this.context.setTaskPublished(TASK_3_ID, true);
        this.context.setTaskPublished(TASK_4_ID, true);
        this.taskAssigningService.onBestSolutionChange(TaskAssigningServiceTest.mockEvent(initialSolution, true, true));
        ((PlanningExecutor)Mockito.verify((Object)this.planningExecutor)).start((List)this.planningCaptor.capture(), (Consumer)ArgumentMatchers.any());
        ((ListAssert)Assertions.assertThat((List)((List)this.planningCaptor.getValue())).isNotNull()).hasSize(1);
        PlanningItem planningItem = new PlanningItem(Task.newBuilder().id(TASK_1_ID).build(), USER_1_ID);
        PlanningExecutionResult executionResult = new PlanningExecutionResult(Collections.singletonList(new PlanningExecutionResultItem(planningItem)));
        this.taskAssigningService.onPlanningExecuted(executionResult);
        List<DataEvent> eventList = Arrays.asList(TaskAssigningServiceTest.mockTaskDataEvent(TASK_1_ID, TaskState.COMPLETED.value(), TASK_1_LAST_UPDATE.plusSeconds(1L)), TaskAssigningServiceTest.mockTaskDataEvent(TASK_2_ID, TaskState.ABORTED.value(), TASK_2_LAST_UPDATE.plusSeconds(1L)));
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.doReturn(eventList).when((Object)this.serviceEventConsumer)).pollEvents();
        TaskAssigningSolution newSolution = this.buildSolution();
        this.context.setCurrentChangeSetId(this.context.nextChangeSetId());
        this.taskAssigningService.onBestSolutionChange(TaskAssigningServiceTest.mockEvent(newSolution, true, true));
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor, (VerificationMode)Mockito.times((int)2))).addProblemFactChanges((List)this.problemFactChangesCaptor.capture());
        List changes = (List)this.problemFactChangesCaptor.getAllValues().get(1);
        TaskAssigningServiceTest.assertHasRemoveTaskChangeForTask(changes, TASK_1_ID);
        TaskAssigningServiceTest.assertHasRemoveTaskChangeForTask(changes, TASK_2_ID);
    }

    @Test
    void onPlanningExecutedWithPinningChanges() throws Exception {
        this.prepareStart();
        TaskAssigningSolution solution = new TaskAssigningSolution("1", Arrays.asList(TestUtil.mockUser(USER_1_ID, Collections.emptyList()), TestUtil.mockUser(USER_2_ID, Collections.emptyList())), Collections.emptyList());
        this.taskAssigningService.onBestSolutionChange(TaskAssigningServiceTest.mockEvent(solution, true, true));
        this.context.setTaskPublished(TASK_1_ID, false);
        this.context.setTaskPublished(TASK_2_ID, false);
        PlanningItem planningItem1 = new PlanningItem(Task.newBuilder().id(TASK_1_ID).build(), USER_1_ID);
        PlanningItem planningItem2 = new PlanningItem(Task.newBuilder().id(TASK_2_ID).build(), USER_2_ID);
        PlanningExecutionResult executionResult = new PlanningExecutionResult(Arrays.asList(new PlanningExecutionResultItem(planningItem1), new PlanningExecutionResultItem(planningItem2, (Exception)new RuntimeException("planningItem2 failed"))));
        this.taskAssigningService.onPlanningExecuted(executionResult);
        Assertions.assertThat((boolean)this.context.isTaskPublished(TASK_1_ID)).isTrue();
        Assertions.assertThat((boolean)this.context.isTaskPublished(TASK_2_ID)).isFalse();
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor)).addProblemFactChanges((List)this.problemFactChangesCaptor.capture());
        List changes = (List)this.problemFactChangesCaptor.getValue();
        ((ListAssert)Assertions.assertThat((List)changes).isNotNull()).hasSize(2);
        TaskAssigningServiceTest.assertHasAssignTaskChangeForTask(changes, TASK_1_ID, USER_1_ID);
    }

    @Test
    void onPlanningExecutedWithNoPinningChangesAndNoQueuedEvents() throws Exception {
        this.preparePlanningExecutionWithNoPinningChanges(0);
        Assertions.assertThat((boolean)this.context.isTaskPublished(TASK_1_ID)).isFalse();
        Assertions.assertThat((boolean)this.context.isTaskPublished(TASK_2_ID)).isFalse();
        ((PlanningExecutor)Mockito.verify((Object)this.planningExecutor)).start((List)this.planningCaptor.capture(), (Consumer)ArgumentMatchers.any());
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer, (VerificationMode)Mockito.times((int)1))).resume();
        List planningItems = (List)this.planningCaptor.getValue();
        ((ListAssert)Assertions.assertThat((List)planningItems).isNotNull()).hasSize(2);
        Assertions.assertThat((String)((PlanningItem)planningItems.get(0)).getTask().getId()).isEqualTo(TASK_1_ID);
        Assertions.assertThat((String)((PlanningItem)planningItems.get(1)).getTask().getId()).isEqualTo(TASK_2_ID);
    }

    @Test
    void onPlanningExecutedWithNoPinningChangesAndQueuedEvents() throws Exception {
        this.preparePlanningExecutionWithNoPinningChanges(1);
        ((PlanningExecutor)Mockito.verify((Object)this.planningExecutor, (VerificationMode)Mockito.never())).start((List)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer, (VerificationMode)Mockito.times((int)2))).resume();
    }

    @Test
    void onUserEventAndThereAreChanges() throws Exception {
        SolutionDataLoader.Result result = new SolutionDataLoader.Result(Collections.singletonList(TestUtil.mockTaskData(TASK_1_ID, TaskState.READY.value(), TASK_1_LAST_UPDATE)), Collections.singletonList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID)));
        this.prepareStartAndSetInitialSolution(result);
        List<DataEvent> eventList = Arrays.asList(TaskAssigningServiceTest.mockUserDataEvent(Collections.singletonList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID)), USER_DATA_EVENT_1_TIME), TaskAssigningServiceTest.mockUserDataEvent(Arrays.asList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID), TaskAssigningServiceTest.mockExternalUser(USER_2_ID), TaskAssigningServiceTest.mockExternalUser(USER_3_ID)), USER_DATA_EVENT_2_TIME));
        this.eventsProcessed = new CountDownLatch(1);
        ((Consumer)this.dataEventsConsumerCaptor.getValue()).accept(eventList);
        this.eventsProcessed.await();
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor)).addProblemFactChanges((List)this.problemFactChangesCaptor.capture());
        ((ListAssert)Assertions.assertThat((List)((List)this.problemFactChangesCaptor.getValue())).isNotNull()).hasSize(3);
        TaskAssigningServiceTest.assertHasAddUserChangeForUser((List)this.problemFactChangesCaptor.getValue(), USER_2_ID);
        TaskAssigningServiceTest.assertHasAddUserChangeForUser((List)this.problemFactChangesCaptor.getValue(), USER_3_ID);
    }

    @Test
    void onUserEventsAndThereAreNoChanges() throws Exception {
        SolutionDataLoader.Result result = new SolutionDataLoader.Result(Collections.singletonList(TestUtil.mockTaskData(TASK_1_ID, TaskState.RESERVED.value(), USER_1_ID, TASK_1_LAST_UPDATE)), Collections.singletonList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID)));
        this.prepareStartAndSetInitialSolution(result);
        List<UserDataEvent> eventList = Collections.singletonList(TaskAssigningServiceTest.mockUserDataEvent(Collections.singletonList(TaskAssigningServiceTest.mockExternalUser(USER_1_ID)), USER_DATA_EVENT_1_TIME));
        this.eventsProcessed = new CountDownLatch(1);
        ((Consumer)this.dataEventsConsumerCaptor.getValue()).accept(eventList);
        this.eventsProcessed.await();
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor, (VerificationMode)Mockito.never())).addProblemFactChanges((List)ArgumentMatchers.any());
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer, (VerificationMode)Mockito.times((int)2))).resume();
    }

    private void preparePlanningExecutionWithNoPinningChanges(int queuedEvents) throws Exception {
        this.prepareStart();
        TaskAssigningSolution solution = new TaskAssigningSolution("1", Arrays.asList(TestUtil.mockUser(USER_1_ID, Collections.emptyList()), TestUtil.mockUser(USER_2_ID, Collections.emptyList())), Collections.emptyList());
        this.taskAssigningService.onBestSolutionChange(TaskAssigningServiceTest.mockEvent(solution, true, true));
        this.context.setTaskPublished(TASK_1_ID, false);
        this.context.setTaskPublished(TASK_2_ID, false);
        PlanningItem planningItem1 = new PlanningItem(Task.newBuilder().id(TASK_1_ID).build(), USER_1_ID);
        PlanningItem planningItem2 = new PlanningItem(Task.newBuilder().id(TASK_2_ID).build(), USER_2_ID);
        PlanningExecutionResult executionResult = new PlanningExecutionResult(Arrays.asList(new PlanningExecutionResultItem(planningItem1, (Exception)new RuntimeException("planningItem1 failed")), new PlanningExecutionResultItem(planningItem2, (Exception)new RuntimeException("planningItem2 failed"))));
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.doReturn((Object)queuedEvents).when((Object)this.serviceEventConsumer)).queuedEvents();
        this.taskAssigningService.onPlanningExecuted(executionResult);
    }

    @Test
    void onShutDownEvent() throws Exception {
        this.prepareStart();
        this.taskAssigningService.onShutDownEvent(new ShutdownEvent());
        this.verifyDestroy();
    }

    @Test
    void destroy() throws Exception {
        this.prepareStart();
        this.taskAssigningService.destroy();
        this.verifyDestroy();
    }

    @Test
    void createContext() {
        Assertions.assertThat((Object)this.taskAssigningService.createContext()).isNotNull();
    }

    @Test
    void createSolverExecutor() {
        SolverExecutor solverExecutor = this.taskAssigningService.createSolverExecutor(this.solverFactory, this.solverEventListener);
        Assertions.assertThat((Object)solverExecutor).isNotNull();
    }

    @Test
    void createPlanningExecutor() {
        PlanningExecutor planningExecutor = this.taskAssigningService.createPlanningExecutor(this.clientServices, this.config);
        Assertions.assertThat((Object)planningExecutor).isNotNull();
    }

    @Test
    void createSolutionDataLoader() {
        SolutionDataLoader solutionDataLoader = this.taskAssigningService.createSolutionDataLoader(this.taskServiceConnector, this.userServiceConnector);
        Assertions.assertThat((Object)solutionDataLoader).isNotNull();
    }

    @Test
    void createUserServiceAdapter() {
        UserServiceAdapter adapter = this.taskAssigningService.createUserServiceAdapter(this.config, (TaskAssigningServiceEventConsumer)this.serviceEventConsumer, this.managedExecutor, this.userServiceConnector);
        Assertions.assertThat((Object)adapter).isNotNull();
    }

    private void verifyDestroy() {
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor)).destroy();
        ((SolutionDataLoader)Mockito.verify((Object)this.solutionDataLoader)).destroy();
        ((PlanningExecutor)Mockito.verify((Object)this.planningExecutor)).destroy();
        ((UserServiceAdapter)Mockito.verify((Object)this.userServiceAdapter)).destroy();
    }

    private TaskAssigningSolution buildSolution() {
        List<TaskAssignment> user1Assignments = Arrays.asList(TestUtil.mockTaskAssignment(TASK_1_ID), TestUtil.mockTaskAssignment(TASK_2_ID));
        User user1 = TestUtil.mockUser(USER_1_ID, user1Assignments);
        List<TaskAssignment> user2Assignments = Arrays.asList(TestUtil.mockTaskAssignment(TASK_3_ID), TestUtil.mockTaskAssignment(TASK_4_ID));
        User user2 = TestUtil.mockUser(USER_2_ID, user2Assignments);
        ArrayList<TaskAssignment> assignments = new ArrayList<TaskAssignment>();
        assignments.addAll(user1Assignments);
        assignments.addAll(user2Assignments);
        return new TaskAssigningSolution("1", Arrays.asList(user1, user2), assignments);
    }

    private void prepareStart() throws Exception {
        ((TaskAssigningService)Mockito.doReturn((Object)this.context).when((Object)this.taskAssigningService)).createContext();
        ((TaskAssigningConfig)Mockito.doReturn((Object)new URL(DATA_INDEX_SERVER_URL)).when((Object)this.config)).getDataIndexServerUrl();
        ((TaskAssigningConfig)Mockito.doReturn((Object)DATA_LOADER_RETRY_INTERVAL).when((Object)this.config)).getDataLoaderRetryInterval();
        ((TaskAssigningConfig)Mockito.doReturn((Object)5).when((Object)this.config)).getDataLoaderRetries();
        ((TaskAssigningConfig)Mockito.doReturn((Object)10).when((Object)this.config)).getDataLoaderPageSize();
        ((TaskAssigningConfig)Mockito.lenient().doReturn((Object)5).when((Object)this.config)).getPublishWindowSize();
        ((TaskAssigningServiceHelper)Mockito.doReturn((Object)this.userServiceConnector).when((Object)this.serviceHelper)).validateAndGetUserServiceConnector();
        ((TaskAssigningService)Mockito.doReturn((Object)this.solverExecutor).when((Object)this.taskAssigningService)).createSolverExecutor((SolverFactory)ArgumentMatchers.eq(this.solverFactory), (SolverEventListener)this.solverListenerCaptor.capture());
        ((TaskAssigningService)Mockito.doReturn((Object)this.planningExecutor).when((Object)this.taskAssigningService)).createPlanningExecutor(this.clientServices, this.config);
        ((TaskAssigningService)Mockito.doReturn((Object)this.solutionDataLoader).when((Object)this.taskAssigningService)).createSolutionDataLoader(this.taskServiceConnector, this.userServiceConnector);
        ((TaskAssigningService)Mockito.doReturn((Object)this.userServiceAdapter).when((Object)this.taskAssigningService)).createUserServiceAdapter(this.config, (TaskAssigningServiceEventConsumer)this.serviceEventConsumer, this.managedExecutor, this.userServiceConnector);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.taskAssigningService.start());
        ((TaskAssigningService)Mockito.verify((Object)this.taskAssigningService)).createContext();
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer)).setConsumer((Consumer)this.dataEventsConsumerCaptor.capture());
        ((ManagedExecutor)Mockito.verify((Object)this.managedExecutor)).execute((Runnable)this.solverExecutor);
        ((ManagedExecutor)Mockito.verify((Object)this.managedExecutor)).execute((Runnable)this.planningExecutor);
        ((ManagedExecutor)Mockito.verify((Object)this.managedExecutor)).execute((Runnable)this.solutionDataLoader);
        ((SolutionDataLoader)Mockito.verify((Object)this.solutionDataLoader)).start((Consumer)this.solutionDataLoaderConsumerCaptor.capture(), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)true), (Duration)ArgumentMatchers.eq((Object)DATA_LOADER_RETRY_INTERVAL), ArgumentMatchers.eq((int)5), ArgumentMatchers.eq((int)10));
    }

    private void prepareStartAndSetInitialSolution(SolutionDataLoader.Result result) throws Exception {
        this.prepareStart();
        ((Consumer)this.solutionDataLoaderConsumerCaptor.getValue()).accept(result);
        ((SolverExecutor)Mockito.verify((Object)this.solverExecutor)).start((TaskAssigningSolution)this.solutionCaptor.capture());
        TaskAssigningSolution initialSolution = (TaskAssigningSolution)this.solutionCaptor.getValue();
        BestSolutionChangedEvent<TaskAssigningSolution> solutionChangedEvent = TaskAssigningServiceTest.mockEvent(initialSolution, true, true);
        ((SolverEventListener)this.solverListenerCaptor.getValue()).bestSolutionChanged(solutionChangedEvent);
        ((BufferedTaskAssigningServiceEventConsumer)Mockito.verify((Object)this.serviceEventConsumer)).resume();
    }

    private static org.kie.kogito.taskassigning.user.service.User mockExternalUser(String id) {
        org.kie.kogito.taskassigning.user.service.User user = (org.kie.kogito.taskassigning.user.service.User)Mockito.mock(org.kie.kogito.taskassigning.user.service.User.class);
        ((org.kie.kogito.taskassigning.user.service.User)Mockito.lenient().doReturn((Object)id).when((Object)user)).getId();
        ((org.kie.kogito.taskassigning.user.service.User)Mockito.lenient().doReturn(Collections.emptyMap()).when((Object)user)).getAttributes();
        ((org.kie.kogito.taskassigning.user.service.User)Mockito.lenient().doReturn(Collections.emptySet()).when((Object)user)).getGroups();
        return user;
    }

    private static TaskDataEvent mockTaskDataEvent(String taskId, String state, ZonedDateTime lastUpdate) {
        TaskData taskData = (TaskData)Mockito.mock(TaskData.class);
        ((TaskData)Mockito.doReturn((Object)taskId).when((Object)taskData)).getId();
        ((TaskData)Mockito.doReturn((Object)state).when((Object)taskData)).getState();
        ((TaskData)Mockito.doReturn((Object)lastUpdate).when((Object)taskData)).getLastUpdate();
        return new TaskDataEvent(taskData);
    }

    private static UserDataEvent mockUserDataEvent(List<org.kie.kogito.taskassigning.user.service.User> externalUsers, ZonedDateTime eventTime) {
        return new UserDataEvent(externalUsers, eventTime);
    }

    private static BestSolutionChangedEvent<TaskAssigningSolution> mockEvent(TaskAssigningSolution solution, boolean allChangesProcessed, boolean solutionInitialized) {
        BestSolutionChangedEvent event = (BestSolutionChangedEvent)Mockito.mock(BestSolutionChangedEvent.class);
        ((BestSolutionChangedEvent)Mockito.doReturn((Object)allChangesProcessed).when((Object)event)).isEveryProblemFactChangeProcessed();
        BendableLongScore score = BendableLongScore.zero((int)1, (int)1).withInitScore(solutionInitialized ? 1 : -1);
        TaskAssigningSolution spySolution = (TaskAssigningSolution)Mockito.spy((Object)solution);
        ((TaskAssigningSolution)Mockito.doReturn((Object)score).when((Object)spySolution)).getScore();
        ((BestSolutionChangedEvent)Mockito.doReturn((Object)spySolution).when((Object)event)).getNewBestSolution();
        return event;
    }

    private static void assertHasAddTaskChangeForTask(List<ProblemFactChange<TaskAssigningSolution>> problemFactChanges, String expectedTaskId) {
        List addChanges = TaskAssigningServiceTest.filterByType(problemFactChanges, AddTaskProblemFactChange.class).filter(addTaskChange -> expectedTaskId.equals(addTaskChange.getTaskAssignment().getId())).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(addChanges).withFailMessage("One AddTaskProblemFactChange for task: %s is expected, but there are %s.", new Object[]{expectedTaskId, addChanges.size()})).hasSize(1);
    }

    private static void assertHasRemoveTaskChangeForTask(List<ProblemFactChange<TaskAssigningSolution>> problemFactChanges, String expectedTaskId) {
        List removeChanges = TaskAssigningServiceTest.filterByType(problemFactChanges, RemoveTaskProblemFactChange.class).filter(removeTaskChange -> expectedTaskId.equals(removeTaskChange.getTaskAssignment().getId())).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(removeChanges).withFailMessage("One RemoveTaskProblemFactChange for task: %s is expected, but there are %s.", new Object[]{expectedTaskId, removeChanges.size()})).hasSize(1);
    }

    private static void assertHasAssignTaskChangeForTask(List<ProblemFactChange<TaskAssigningSolution>> problemFactChanges, String expectedTaskId, String expectedUserId) {
        List assignChanges = TaskAssigningServiceTest.filterByType(problemFactChanges, AssignTaskProblemFactChange.class).filter(assignChange -> expectedTaskId.equals(assignChange.getTaskAssignment().getId())).filter(assignChange -> expectedUserId.equals(assignChange.getUser().getId())).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(assignChanges).withFailMessage("One AssignTaskProblemFactChange for task: %s and user: %s is expected, but there are %s.", new Object[]{expectedTaskId, expectedUserId, assignChanges.size()})).hasSize(1);
    }

    private static void assertHasAddUserChangeForUser(List<ProblemFactChange<TaskAssigningSolution>> problemFactChanges, String expectedUserId) {
        List addChanges = TaskAssigningServiceTest.filterByType(problemFactChanges, AddUserProblemFactChange.class).filter(addUserChange -> expectedUserId.equals(addUserChange.getUser().getId())).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(addChanges).withFailMessage("One AddUserProblemFactChange for user: %s is expected, but there are %s.", new Object[]{expectedUserId, addChanges.size()})).hasSize(1);
    }

    private static <T extends ProblemFactChange<TaskAssigningSolution>> Stream<T> filterByType(List<? extends ProblemFactChange<TaskAssigningSolution>> changes, Class<T> clazz) {
        return changes.stream().filter(Objects::nonNull).filter(clazz::isInstance).map(change -> change);
    }

    private class TaskAssigningServiceMock
    extends TaskAssigningService {
        private TaskAssigningServiceMock() {
        }

        void processDataEvents(List<DataEvent<?>> events) {
            super.processDataEvents(events);
            TaskAssigningServiceTest.this.eventsProcessed.countDown();
        }
    }
}

