/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.ClientServices;
import org.kie.kogito.taskassigning.auth.AuthenticationCredentials;
import org.kie.kogito.taskassigning.index.service.client.DataIndexServiceClient;
import org.kie.kogito.taskassigning.index.service.client.DataIndexServiceClientConfig;
import org.kie.kogito.taskassigning.index.service.client.DataIndexServiceClientFactory;
import org.kie.kogito.taskassigning.index.service.client.graphql.UserTaskInstance;
import org.kie.kogito.taskassigning.service.TaskServiceConnector;
import org.kie.kogito.taskassigning.service.TaskState;
import org.kie.kogito.taskassigning.service.TestUtil;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TaskServiceConnectorTest {
    private static final String TASK1 = "TASK1";
    private static final String TASK2 = "TASK2";
    private static final String TASK3 = "TASK3";
    private static final String TASK4 = "TASK4";
    private static final String TASK5 = "TASK5";
    private static final String TASK6 = "TASK6";
    private static final String TASK7 = "TASK7";
    private static final String TASK8 = "TASK8";
    private static final String TASK9 = "TASK9";
    @Mock
    TaskAssigningConfig config;
    @Mock
    ClientServices clientServices;
    @Mock
    DataIndexServiceClientFactory dataIndexServiceClientFactory;
    @Mock
    DataIndexServiceClient dataIndexServiceClient;

    TaskServiceConnectorTest() {
    }

    @Test
    void findAllTasks() throws MalformedURLException {
        ((ClientServices)Mockito.doReturn((Object)this.dataIndexServiceClientFactory).when((Object)this.clientServices)).dataIndexClientFactory();
        ((DataIndexServiceClientFactory)Mockito.doReturn((Object)this.dataIndexServiceClient).when((Object)this.dataIndexServiceClientFactory)).newClient((DataIndexServiceClientConfig)ArgumentMatchers.any(), (AuthenticationCredentials)ArgumentMatchers.any());
        ((TaskAssigningConfig)Mockito.doReturn((Object)false).when((Object)this.config)).isKeycloakSet();
        ((TaskAssigningConfig)Mockito.doReturn((Object)false).when((Object)this.config)).isBasicAuthSet();
        ((TaskAssigningConfig)Mockito.doReturn((Object)new URL("http://localhost:8180/graphql")).when((Object)this.config)).getDataIndexServerUrl();
        List<String> state = Collections.singletonList(TaskState.READY.value());
        int pageSize = 3;
        List<UserTaskInstance> result0 = Arrays.asList(TestUtil.mockUserTaskInstance(TASK1, TestUtil.parseZonedDateTime("2021-02-08T10:00:00.001Z"), TaskState.READY.value()), TestUtil.mockUserTaskInstance(TASK2, TestUtil.parseZonedDateTime("2021-02-08T11:00:00.001Z"), TaskState.READY.value()), TestUtil.mockUserTaskInstance(TASK3, TestUtil.parseZonedDateTime("2021-02-08T12:00:00.001Z"), TaskState.RESERVED.value()));
        ((DataIndexServiceClient)Mockito.lenient().doReturn(result0).when((Object)this.dataIndexServiceClient)).findTasks(null, null, "STARTED", true, 0, pageSize);
        ZonedDateTime nextTime = TestUtil.parseZonedDateTime("2021-02-08T12:00:00.000Z");
        List<UserTaskInstance> result1 = Arrays.asList(TestUtil.mockUserTaskInstance(TASK4, TestUtil.parseZonedDateTime("2021-02-08T13:00:00.001Z"), TaskState.READY.value()), TestUtil.mockUserTaskInstance(TASK5, TestUtil.parseZonedDateTime("2021-02-08T14:00:00.001Z"), TaskState.READY.value()), TestUtil.mockUserTaskInstance(TASK6, TestUtil.parseZonedDateTime("2021-02-08T14:00:00.001Z"), TaskState.READY.value()));
        ((DataIndexServiceClient)Mockito.lenient().doReturn(result1).when((Object)this.dataIndexServiceClient)).findTasks(null, nextTime, "STARTED", true, 1, pageSize);
        nextTime = TestUtil.parseZonedDateTime("2021-02-08T14:00:00.000Z");
        List<UserTaskInstance> result2 = Arrays.asList(TestUtil.mockUserTaskInstance(TASK7, TestUtil.parseZonedDateTime("2021-02-08T15:00:00.001Z"), TaskState.READY.value()), TestUtil.mockUserTaskInstance(TASK8, TestUtil.parseZonedDateTime("2021-02-08T16:00:00.001Z"), TaskState.READY.value()), TestUtil.mockUserTaskInstance(TASK9, TestUtil.parseZonedDateTime("2021-02-08T17:00:00.001Z"), TaskState.READY.value()));
        ((DataIndexServiceClient)Mockito.lenient().doReturn(result2).when((Object)this.dataIndexServiceClient)).findTasks(null, nextTime, "STARTED", true, 2, pageSize);
        nextTime = TestUtil.parseZonedDateTime("2021-02-08T17:00:00.000Z");
        ((DataIndexServiceClient)Mockito.lenient().doReturn(new ArrayList()).when((Object)this.dataIndexServiceClient)).findTasks(null, nextTime, "STARTED", true, 1, pageSize);
        TaskServiceConnector connector = new TaskServiceConnector(this.config, this.clientServices);
        List result = connector.findAllTasks(Collections.singletonList(TaskState.READY.value()), 3);
        AssertionsForInterfaceTypes.assertThat((int)result.size()).isEqualTo(8);
        List<String> expectedTasks = Arrays.asList(TASK1, TASK2, TASK4, TASK5, TASK6, TASK7, TASK8, TASK9);
        AssertionsForInterfaceTypes.assertThat(expectedTasks).isEqualTo(result.stream().map(UserTaskInstance::getId).collect(Collectors.toList()));
    }
}

