/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.kogito.taskassigning.core.model.ChainElement;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.index.service.client.graphql.UserTaskInstance;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.user.service.Group;
import org.mockito.Mockito;

public class TestUtil {
    private TestUtil() {
    }

    public static ZonedDateTime parseZonedDateTime(String value) {
        return ZonedDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static org.kie.kogito.taskassigning.user.service.User mockExternalUser(String id) {
        return TestUtil.mockExternalUser(id, new ArrayList<String>(), new HashMap<String, Object>());
    }

    public static org.kie.kogito.taskassigning.user.service.User mockExternalUser(String id, List<String> groups, Map<String, Object> attributes) {
        org.kie.kogito.taskassigning.user.service.User externalUser = (org.kie.kogito.taskassigning.user.service.User)Mockito.mock(org.kie.kogito.taskassigning.user.service.User.class);
        ((org.kie.kogito.taskassigning.user.service.User)Mockito.doReturn((Object)id).when((Object)externalUser)).getId();
        Set externalGroups = groups.stream().map(TestUtil::mockExternalGroup).collect(Collectors.toSet());
        ((org.kie.kogito.taskassigning.user.service.User)Mockito.doReturn(externalGroups).when((Object)externalUser)).getGroups();
        ((org.kie.kogito.taskassigning.user.service.User)Mockito.doReturn(attributes).when((Object)externalUser)).getAttributes();
        return externalUser;
    }

    public static Group mockExternalGroup(String id) {
        Group externalGroup = (Group)Mockito.mock(Group.class);
        ((Group)Mockito.doReturn((Object)id).when((Object)externalGroup)).getId();
        return externalGroup;
    }

    public static UserTaskInstance mockUserTaskInstance(String taskId, ZonedDateTime started, String state) {
        UserTaskInstance userTaskInstance = new UserTaskInstance();
        userTaskInstance.setId(taskId);
        userTaskInstance.setStarted(started);
        userTaskInstance.setState(state);
        return userTaskInstance;
    }

    public static UserTaskInstance mockUserTaskInstance(String taskId, String state) {
        UserTaskInstance userTaskInstance = new UserTaskInstance();
        userTaskInstance.setId(taskId);
        userTaskInstance.setState(state);
        return userTaskInstance;
    }

    public static UserTaskInstance mockUserTaskInstance(String taskId, String state, String actualOwner) {
        UserTaskInstance userTaskInstance = new UserTaskInstance();
        userTaskInstance.setId(taskId);
        userTaskInstance.setState(state);
        userTaskInstance.setActualOwner(actualOwner);
        return userTaskInstance;
    }

    public static User mockUser(String userId, List<TaskAssignment> taskAssignments) {
        User result;
        User previousElement = result = new User(userId);
        for (TaskAssignment taskAssignment : taskAssignments) {
            taskAssignment.setUser(result);
            taskAssignment.setPreviousElement((ChainElement)previousElement);
            previousElement.setNextElement(taskAssignment);
            previousElement = taskAssignment;
        }
        return result;
    }

    public static TaskAssignment mockTaskAssignment(String taskId) {
        return new TaskAssignment(Task.newBuilder().id(taskId).build());
    }

    public static TaskData mockTaskData(String taskId, String state, ZonedDateTime lastUpdate) {
        TaskData taskData = (TaskData)Mockito.mock(TaskData.class);
        ((TaskData)Mockito.doReturn((Object)taskId).when((Object)taskData)).getId();
        ((TaskData)Mockito.doReturn((Object)state).when((Object)taskData)).getState();
        ((TaskData)Mockito.doReturn((Object)lastUpdate).when((Object)taskData)).getLastUpdate();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getPotentialUsers();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getPotentialGroups();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getExcludedUsers();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getAdminUsers();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getAdminGroups();
        return taskData;
    }

    public static TaskData mockTaskData(String taskId, String state, String actualOwner, ZonedDateTime lastUpdate) {
        TaskData taskData = (TaskData)Mockito.mock(TaskData.class);
        ((TaskData)Mockito.doReturn((Object)taskId).when((Object)taskData)).getId();
        ((TaskData)Mockito.doReturn((Object)state).when((Object)taskData)).getState();
        ((TaskData)Mockito.doReturn((Object)actualOwner).when((Object)taskData)).getActualOwner();
        ((TaskData)Mockito.doReturn((Object)lastUpdate).when((Object)taskData)).getLastUpdate();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getPotentialUsers();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getPotentialGroups();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getExcludedUsers();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getAdminUsers();
        ((TaskData)Mockito.doReturn(Collections.emptySet()).when((Object)taskData)).getAdminGroups();
        return taskData;
    }
}

