/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.service.UserServiceAdapter;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.service.event.DataEvent;
import org.kie.kogito.taskassigning.service.event.TaskAssigningServiceEventConsumer;
import org.kie.kogito.taskassigning.service.event.UserDataEvent;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class UserServiceAdapterTest {
    private static final Duration SYNC_INTERVAL = Duration.parse("PT2H");
    private static final Duration SYNC_RETRY_INTERVAL = Duration.parse("PT1S");
    @Mock
    private TaskAssigningConfig config;
    @Mock
    private TaskAssigningServiceEventConsumer taskAssigningServiceEventConsumer;
    @Mock
    private ExecutorService executorService;
    @Mock
    private UserServiceConnector userServiceConnector;
    private UserServiceAdapter adapter;
    @Captor
    private ArgumentCaptor<Runnable> executionCaptor;
    @Captor
    private ArgumentCaptor<Duration> nextStartTimeCaptor;
    @Captor
    private ArgumentCaptor<UserDataEvent> eventCaptor;

    UserServiceAdapterTest() {
    }

    @BeforeEach
    void setUp() {
        ((TaskAssigningConfig)Mockito.lenient().doReturn((Object)SYNC_INTERVAL).when((Object)this.config)).getUserServiceSyncInterval();
        ((TaskAssigningConfig)Mockito.lenient().doReturn((Object)SYNC_RETRY_INTERVAL).when((Object)this.config)).getUserServiceSyncRetryInterval();
        this.executorService = Executors.newFixedThreadPool(1);
        this.adapter = (UserServiceAdapter)Mockito.spy((Object)new UserServiceAdapter(this.config, this.taskAssigningServiceEventConsumer, this.executorService, this.userServiceConnector){

            void scheduleExecution(Duration nextStartTime, Runnable command) {
            }
        });
    }

    @Test
    void start() {
        this.adapter.start();
        ((UserServiceAdapter)Mockito.verify((Object)this.adapter)).scheduleExecution((Duration)this.nextStartTimeCaptor.capture(), (Runnable)this.executionCaptor.capture());
        Assertions.assertThat((Duration)((Duration)this.nextStartTimeCaptor.getValue())).isEqualTo((Object)SYNC_INTERVAL);
        ((UserServiceConnector)Mockito.verify((Object)this.userServiceConnector, (VerificationMode)Mockito.never())).findAllUsers();
        ((TaskAssigningServiceEventConsumer)Mockito.verify((Object)this.taskAssigningServiceEventConsumer, (VerificationMode)Mockito.never())).accept((DataEvent)ArgumentMatchers.any());
    }

    @Test
    void startWithSyncDisabledZero() {
        this.startWithSyncDisabled(Duration.ZERO);
    }

    private void startWithSyncDisabled(Duration userServiceSyncInterval) {
        ((TaskAssigningConfig)Mockito.doReturn((Object)userServiceSyncInterval).when((Object)this.config)).getUserServiceSyncInterval();
        this.adapter.start();
        ((UserServiceAdapter)Mockito.verify((Object)this.adapter, (VerificationMode)Mockito.never())).scheduleExecution((Duration)ArgumentMatchers.any(), (Runnable)ArgumentMatchers.any());
    }

    @Test
    void executionSuccessful() {
        ArrayList users = new ArrayList();
        ((UserServiceConnector)Mockito.doReturn(users).when((Object)this.userServiceConnector)).findAllUsers();
        this.adapter.start();
        ((UserServiceAdapter)Mockito.verify((Object)this.adapter)).scheduleExecution((Duration)ArgumentMatchers.any(), (Runnable)this.executionCaptor.capture());
        ((Runnable)this.executionCaptor.getValue()).run();
        ((UserServiceAdapter)Mockito.verify((Object)this.adapter, (VerificationMode)Mockito.times((int)2))).scheduleExecution((Duration)this.nextStartTimeCaptor.capture(), (Runnable)ArgumentMatchers.any());
        Assertions.assertThat((Duration)((Duration)this.nextStartTimeCaptor.getAllValues().get(0))).isEqualTo((Object)SYNC_INTERVAL);
        Assertions.assertThat((Duration)((Duration)this.nextStartTimeCaptor.getAllValues().get(1))).isEqualTo((Object)SYNC_INTERVAL);
        ((TaskAssigningServiceEventConsumer)Mockito.verify((Object)this.taskAssigningServiceEventConsumer)).accept((DataEvent)this.eventCaptor.capture());
        Assertions.assertThat((Object)((UserDataEvent)this.eventCaptor.getValue())).isNotNull();
        Assertions.assertThat((List)((List)((UserDataEvent)this.eventCaptor.getValue()).getData())).isSameAs(users);
    }

    @Test
    void executionFailureWithRemainingRetries() {
        ((TaskAssigningConfig)Mockito.doReturn((Object)5).when((Object)this.config)).getUserServiceSyncRetries();
        this.executeWithFailure();
        Assertions.assertThat((Duration)((Duration)this.nextStartTimeCaptor.getAllValues().get(1))).isEqualTo((Object)SYNC_RETRY_INTERVAL);
    }

    @Test
    void executionFailureWithNoRemainingRetriesSyncOnNextIntervalStrategy() {
        ((TaskAssigningConfig)Mockito.doReturn((Object)0).when((Object)this.config)).getUserServiceSyncRetries();
        ((TaskAssigningConfig)Mockito.doReturn((Object)TaskAssigningConfig.UserServiceSyncOnRetriesExceededStrategy.SYNC_ON_NEXT_INTERVAL).when((Object)this.config)).getUserServiceSyncOnRetriesExceededStrategy();
        this.executeWithFailure();
        Assertions.assertThat((Duration)((Duration)this.nextStartTimeCaptor.getAllValues().get(1))).isEqualTo((Object)SYNC_INTERVAL);
    }

    @Test
    void executionFailureWithNoRemainingRetriesSyncImmediatelyStrategy() {
        ((TaskAssigningConfig)Mockito.doReturn((Object)0).when((Object)this.config)).getUserServiceSyncRetries();
        ((TaskAssigningConfig)Mockito.doReturn((Object)TaskAssigningConfig.UserServiceSyncOnRetriesExceededStrategy.SYNC_IMMEDIATELY).when((Object)this.config)).getUserServiceSyncOnRetriesExceededStrategy();
        this.executeWithFailure();
        Assertions.assertThat((Duration)((Duration)this.nextStartTimeCaptor.getAllValues().get(1))).isEqualTo((Object)SYNC_RETRY_INTERVAL);
    }

    @Test
    @Timeout(value=2L)
    void scheduleExecution() throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicBoolean wasExecuted = new AtomicBoolean();
        ExecutorService realExecutorService = Executors.newSingleThreadExecutor();
        UserServiceAdapter realAdapter = new UserServiceAdapter(this.config, this.taskAssigningServiceEventConsumer, realExecutorService, this.userServiceConnector);
        realAdapter.scheduleExecution(Duration.parse("PT1S"), () -> {
            wasExecuted.set(true);
            countDownLatch.countDown();
        });
        countDownLatch.await();
        Assertions.assertThat((AtomicBoolean)wasExecuted).isTrue();
        realExecutorService.shutdown();
    }

    private void executeWithFailure() {
        ((UserServiceConnector)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("User service failed")}).when((Object)this.userServiceConnector)).findAllUsers();
        this.adapter.start();
        ((UserServiceAdapter)Mockito.verify((Object)this.adapter)).scheduleExecution((Duration)ArgumentMatchers.any(), (Runnable)this.executionCaptor.capture());
        ((Runnable)this.executionCaptor.getValue()).run();
        ((TaskAssigningServiceEventConsumer)Mockito.verify((Object)this.taskAssigningServiceEventConsumer, (VerificationMode)Mockito.never())).accept((DataEvent)this.eventCaptor.capture());
        ((UserServiceAdapter)Mockito.verify((Object)this.adapter, (VerificationMode)Mockito.times((int)2))).scheduleExecution((Duration)this.nextStartTimeCaptor.capture(), (Runnable)ArgumentMatchers.any());
    }
}

