/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.service.UserServiceConnectorRegistry;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class UserServiceConnectorRegistryTest {
    private static final String CONNECTOR1 = "CONNECTOR1";
    private static final String CONNECTOR2 = "CONNECTOR2";
    private static final String CONNECTOR3 = "CONNECTOR3";
    @Mock
    private Instance<UserServiceConnector> connectorsInstance;

    UserServiceConnectorRegistryTest() {
    }

    @Test
    void duplicatedConnectorError() {
        List<UserServiceConnector> connectorList = Arrays.asList(UserServiceConnectorRegistryTest.mockConnector(CONNECTOR1), UserServiceConnectorRegistryTest.mockConnector(CONNECTOR2), UserServiceConnectorRegistryTest.mockConnector(CONNECTOR1));
        ((Instance)Mockito.doReturn(connectorList.stream()).when(this.connectorsInstance)).stream();
        Assertions.assertThatThrownBy(() -> new UserServiceConnectorRegistry(this.connectorsInstance)).hasMessageStartingWith("Two different connectors for the same name: CONNECTOR1");
    }

    @Test
    void get() {
        List<UserServiceConnector> connectorList = Arrays.asList(UserServiceConnectorRegistryTest.mockConnector(CONNECTOR1), UserServiceConnectorRegistryTest.mockConnector(CONNECTOR2), UserServiceConnectorRegistryTest.mockConnector(CONNECTOR3));
        ((Instance)Mockito.doReturn(connectorList.stream()).when(this.connectorsInstance)).stream();
        UserServiceConnectorRegistry registry = new UserServiceConnectorRegistry(this.connectorsInstance);
        Assertions.assertThat((Object)registry.get(CONNECTOR1)).isSameAs((Object)connectorList.get(0));
        Assertions.assertThat((Object)registry.get(CONNECTOR2)).isSameAs((Object)connectorList.get(1));
        Assertions.assertThat((Object)registry.get(CONNECTOR3)).isSameAs((Object)connectorList.get(2));
    }

    private static UserServiceConnector mockConnector(String name) {
        UserServiceConnector result = (UserServiceConnector)Mockito.mock(UserServiceConnector.class);
        ((UserServiceConnector)Mockito.doReturn((Object)name).when((Object)result)).getName();
        return result;
    }
}

