/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.config;

import java.net.URL;
import java.time.Duration;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;

class TaskAssigningConfigTest {
    private static final String DATA_INDEX_SERVER_URL = "http://localhost:8180/graphql";
    private static final String AUTH_SERVER_URL = "http://localhost:8280/auth/realms/kogito";
    private static final String REALM = "kogito";
    private static final String CLIENT_ID = "CLIENT_ID";
    private static final String CREDENTIALS_SECRET = "CREDENTIALS_SECRET";
    private static final String CLIENT_USER = "CLIENT_USER";
    private static final String CLIENT_PASSWORD = "CLIENT_PASSWORD";
    private static final Duration DATA_LOADER_RETRY_INTERVAL = Duration.ofMillis(1000L);
    private static final int DATA_LOADER_RETRIES = 5;
    private static final int DATA_LOADER_PAGE_SIZE = 10;
    private static final int PUBLISH_WINDOW_SIZE = 3;
    private static final String USER_SERVICE_CONNECTOR = "USER_SERVICE_CONNECTOR";
    private static final Duration USER_SERVICE_SYNC_INTERVAL = Duration.ofMillis(2000L);
    private static final int USER_SERVICE_SYNC_RETRIES = 6;
    private static final Duration USER_SERVICE_SYNC_RETRY_INTERVAL = Duration.ofMillis(3000L);
    private TaskAssigningConfig config;

    TaskAssigningConfigTest() {
    }

    @BeforeEach
    void setUp() {
        this.config = new TaskAssigningConfig();
    }

    @Test
    void isOidcTenantEnabled() {
        this.config.oidcTenantEnabled = true;
        Assertions.assertThat((boolean)this.config.isOidcTenantEnabled()).isTrue();
    }

    @Test
    void isKeycloakSetTrue() {
        this.config.oidcTenantEnabled = true;
        Assertions.assertThat((boolean)this.config.isKeycloakSet()).isTrue();
    }

    @Test
    void isKeycloakSetFalse() {
        this.config.oidcTenantEnabled = false;
        Assertions.assertThat((boolean)this.config.isKeycloakSet()).isFalse();
    }

    @Test
    void isBasicAuthSetTrue() {
        this.config.oidcTenantEnabled = false;
        this.config.clientAuthUser = Optional.of("kogito.task-assigning.user");
        Assertions.assertThat((boolean)this.config.isBasicAuthSet()).isTrue();
    }

    @Test
    void isBasicAuthSetFalseWhenKeycloakSet() {
        this.config.oidcTenantEnabled = true;
        this.config.clientAuthUser = Optional.of("kogito.task-assigning.user");
        Assertions.assertThat((boolean)this.config.isBasicAuthSet()).isFalse();
    }

    @Test
    void isBasicAuthSetFalse() {
        this.config.oidcTenantEnabled = false;
        this.config.clientAuthUser = Optional.empty();
        Assertions.assertThat((boolean)this.config.isBasicAuthSet()).isFalse();
    }

    @Test
    void getOidcAuthServerUrl() throws Exception {
        URL url = new URL(AUTH_SERVER_URL);
        this.config.oidcAuthServerUrl = Optional.of(url);
        Assertions.assertThat((Optional)this.config.getOidcAuthServerUrl()).contains((Object)url);
    }

    @Test
    void getOidcAuthServerCanonicUrl() throws Exception {
        URL canonicUrl = new URL("http://localhost:8280/auth");
        this.config.oidcAuthServerUrl = Optional.of(new URL(AUTH_SERVER_URL));
        Assertions.assertThat((URL)this.config.getOidcAuthServerCanonicUrl()).isEqualTo((Object)canonicUrl);
    }

    @Test
    void getOidcAuthServerCanonicUrlFailureValueNotSet() {
        this.config.oidcAuthServerUrl = Optional.empty();
        Assertions.assertThatThrownBy(() -> this.config.getOidcAuthServerCanonicUrl()).hasMessage("A configuration value must be set for the property: quarkus.oidc.auth-server-url");
    }

    @Test
    void getOidcAuthServerCanonicUrlFailureMalformedKeycloakAuth() throws Exception {
        String malfFormedKeycloakAuthUrl = "http://localhost:8280/auth/notExpected/kogito";
        this.config.oidcAuthServerUrl = Optional.of(new URL(malfFormedKeycloakAuthUrl));
        Assertions.assertThatThrownBy(() -> this.config.getOidcAuthServerCanonicUrl()).hasMessageContaining("%s doesn't look to be a valid Keycloak authentication domain", new Object[]{malfFormedKeycloakAuthUrl});
    }

    @Test
    void getOidcAuthServerRealm() throws Exception {
        this.config.oidcAuthServerUrl = Optional.of(new URL(AUTH_SERVER_URL));
        Assertions.assertThat((String)this.config.getOidcAuthServerRealm()).isEqualTo(REALM);
    }

    @Test
    void getOidcAuthServerRealFailureValueNotSet() {
        this.config.oidcAuthServerUrl = Optional.empty();
        Assertions.assertThatThrownBy(() -> this.config.getOidcAuthServerRealm()).hasMessage("A configuration value must be set for the property: quarkus.oidc.auth-server-url");
    }

    @Test
    void getOidcAuthServerRealmMalformedKeycloakAuth() throws Exception {
        String malfFormedKeycloakAuthUrl = "http://localhost:8280/auth/notExpected/kogito";
        this.config.oidcAuthServerUrl = Optional.of(new URL(malfFormedKeycloakAuthUrl));
        Assertions.assertThatThrownBy(() -> this.config.getOidcAuthServerRealm()).hasMessageContaining("%s doesn't look to be a valid Keycloak authentication domain", new Object[]{malfFormedKeycloakAuthUrl});
    }

    @Test
    void getOidcClientId() {
        this.config.oidcClientId = Optional.of(CLIENT_ID);
        Assertions.assertThat((Optional)this.config.getOidcClientId()).contains((Object)CLIENT_ID);
    }

    @Test
    void getOidcCredentialsSecret() {
        this.config.oidcCredentialsSecret = Optional.of(CREDENTIALS_SECRET);
        Assertions.assertThat((Optional)this.config.getOidcCredentialsSecret()).contains((Object)CREDENTIALS_SECRET);
    }

    @Test
    void getOidcClientAuthUser() {
        this.config.clientAuthUser = Optional.of(CLIENT_USER);
        Assertions.assertThat((Optional)this.config.getClientAuthUser()).contains((Object)CLIENT_USER);
    }

    @Test
    void getOidcClientAuthPassword() {
        this.config.clientAuthPassword = Optional.of(CLIENT_PASSWORD);
        Assertions.assertThat((Optional)this.config.getClientAuthPassword()).contains((Object)CLIENT_PASSWORD);
    }

    @Test
    void getDataIndexServerUrl() throws Exception {
        URL url;
        this.config.dataIndexServerUrl = url = new URL(DATA_INDEX_SERVER_URL);
        Assertions.assertThat((URL)this.config.getDataIndexServerUrl()).isEqualTo((Object)url);
    }

    @Test
    void getDataLoaderRetryInterval() {
        this.config.dataLoaderRetryInterval = DATA_LOADER_RETRY_INTERVAL;
        Assertions.assertThat((Duration)this.config.getDataLoaderRetryInterval()).isEqualTo((Object)DATA_LOADER_RETRY_INTERVAL);
    }

    @Test
    void getDataLoaderRetries() {
        this.config.dataLoaderRetries = 5;
        Assertions.assertThat((int)this.config.getDataLoaderRetries()).isEqualTo(5);
    }

    @Test
    void getDataLoaderPageSize() {
        this.config.dataLoaderPageSize = 10;
        Assertions.assertThat((int)this.config.getDataLoaderPageSize()).isEqualTo(10);
    }

    @Test
    void getPublishWindowSize() {
        this.config.publishWindowSize = 3;
        Assertions.assertThat((int)this.config.getPublishWindowSize()).isEqualTo(3);
    }

    @Test
    void getUserServiceConnector() {
        this.config.userServiceConnector = USER_SERVICE_CONNECTOR;
        Assertions.assertThat((String)this.config.getUserServiceConnector()).isEqualTo(USER_SERVICE_CONNECTOR);
    }

    @Test
    void getUserServiceSyncInterval() {
        this.config.userServiceSyncInterval = USER_SERVICE_SYNC_INTERVAL;
        Assertions.assertThat((Duration)this.config.getUserServiceSyncInterval()).isEqualTo((Object)USER_SERVICE_SYNC_INTERVAL);
    }

    @Test
    void getUserServiceSyncRetryInterval() {
        this.config.userServiceSyncRetryInterval = USER_SERVICE_SYNC_RETRY_INTERVAL;
        Assertions.assertThat((Duration)this.config.getUserServiceSyncRetryInterval()).isEqualTo((Object)USER_SERVICE_SYNC_RETRY_INTERVAL);
    }

    @Test
    void getUserServiceSyncRetries() {
        this.config.userServiceSyncRetries = 6;
        Assertions.assertThat((int)this.config.getUserServiceSyncRetries()).isEqualTo(6);
    }
}

