/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.ClientServices;
import org.kie.kogito.taskassigning.auth.AuthenticationCredentials;
import org.kie.kogito.taskassigning.auth.BasicAuthenticationCredentials;
import org.kie.kogito.taskassigning.auth.KeycloakAuthenticationCredentials;
import org.kie.kogito.taskassigning.auth.NoAuthenticationCredentials;
import org.kie.kogito.taskassigning.index.service.client.DataIndexServiceClient;
import org.kie.kogito.taskassigning.index.service.client.DataIndexServiceClientConfig;
import org.kie.kogito.taskassigning.index.service.client.DataIndexServiceClientFactory;
import org.kie.kogito.taskassigning.process.service.client.ProcessServiceClient;
import org.kie.kogito.taskassigning.process.service.client.ProcessServiceClientConfig;
import org.kie.kogito.taskassigning.process.service.client.ProcessServiceClientFactory;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfigUtil;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TaskAssigningConfigUtilTest {
    private static final String DATA_INDEX_SERVER_URL = "http://localhost:8180/graphql";
    private static final String AUTH_SERVER_URL = "http://localhost:8280/auth/realms/kogito";
    private static final String CANONIC_AUTH_SERVER_URL = "http://localhost:8280/auth";
    private static final String PROCESS_SERVICE_URL = "http://service1.cloud.com:8280";
    private static final String REALM = "kogito";
    private static final String CLIENT_ID = "CLIENT_ID";
    private static final String CREDENTIALS_SECRET = "CREDENTIALS_SECRET";
    private static final String CLIENT_USER = "CLIENT_USER";
    private static final String CLIENT_PASSWORD = "CLIENT_PASSWORD";
    private static final Duration SYNC_INTERVAL = Duration.of(1L, ChronoUnit.MILLIS);
    private static final int SYNC_RETRIES = 1;
    private static final Duration SYNC_RETRY_INTERVAL = Duration.of(1L, ChronoUnit.MILLIS);
    @Mock
    ClientServices clientServices;
    @Mock
    DataIndexServiceClientFactory dataIndexServiceClientFactory;
    @Mock
    DataIndexServiceClient dataIndexServiceClient;
    @Mock
    ProcessServiceClientFactory processServiceClientFactory;
    @Mock
    ProcessServiceClient processServiceClient;
    @Captor
    ArgumentCaptor<DataIndexServiceClientConfig> dataIndexServiceConfigCaptor;
    @Captor
    ArgumentCaptor<ProcessServiceClientConfig> processServiceConfigCaptor;
    @Captor
    ArgumentCaptor<AuthenticationCredentials> credentialsCaptor;

    TaskAssigningConfigUtilTest() {
    }

    @BeforeEach
    void setUp() {
        ((ClientServices)Mockito.lenient().doReturn((Object)this.dataIndexServiceClientFactory).when((Object)this.clientServices)).dataIndexClientFactory();
        ((ClientServices)Mockito.lenient().doReturn((Object)this.processServiceClientFactory).when((Object)this.clientServices)).processServiceClientFactory();
        ((DataIndexServiceClientFactory)Mockito.lenient().doReturn((Object)this.dataIndexServiceClient).when((Object)this.dataIndexServiceClientFactory)).newClient((DataIndexServiceClientConfig)ArgumentMatchers.any(), (AuthenticationCredentials)ArgumentMatchers.any());
        ((ProcessServiceClientFactory)Mockito.lenient().doReturn((Object)this.processServiceClient).when((Object)this.processServiceClientFactory)).newClient((ProcessServiceClientConfig)ArgumentMatchers.any(), (AuthenticationCredentials)ArgumentMatchers.any());
    }

    @Test
    void createDataIndexServiceClientKeycloakAuth() throws MalformedURLException {
        this.createDataIndexServiceClient(this.buildKeycloakConfig());
        this.assertKeycloakAuth();
    }

    @Test
    void createDataIndexServiceClientBasicAuth() throws MalformedURLException {
        this.createDataIndexServiceClient(this.buildBasicAuthConfig());
        this.assertBasicAuth();
    }

    @Test
    void createDataIndexServiceClientNoAuth() throws MalformedURLException {
        this.createDataIndexServiceClient(this.buildNoAuthConfig());
        this.assertNoAuth();
    }

    @Test
    void createProcessServiceClientKeycloakAuth() throws MalformedURLException {
        this.createProcessServiceClient(this.buildKeycloakConfig());
        this.assertKeycloakAuth();
    }

    @Test
    void createProcessServiceClientBasicAuth() throws MalformedURLException {
        this.createProcessServiceClient(this.buildBasicAuthConfig());
        this.assertBasicAuth();
    }

    @Test
    void createProcessServiceClientNoAuth() throws MalformedURLException {
        this.createProcessServiceClient(this.buildBasicAuthConfig());
        this.assertBasicAuth();
    }

    private void createDataIndexServiceClient(TaskAssigningConfig config) throws MalformedURLException {
        DataIndexServiceClient result = TaskAssigningConfigUtil.createDataIndexServiceClient((ClientServices)this.clientServices, (TaskAssigningConfig)config);
        Assertions.assertThat((Object)result).isSameAs((Object)this.dataIndexServiceClient);
        ((DataIndexServiceClientFactory)Mockito.verify((Object)this.dataIndexServiceClientFactory)).newClient((DataIndexServiceClientConfig)this.dataIndexServiceConfigCaptor.capture(), (AuthenticationCredentials)this.credentialsCaptor.capture());
        Assertions.assertThat((URL)((DataIndexServiceClientConfig)this.dataIndexServiceConfigCaptor.getValue()).getServiceUrl()).isEqualTo((Object)new URL(DATA_INDEX_SERVER_URL));
    }

    private void createProcessServiceClient(TaskAssigningConfig config) throws MalformedURLException {
        URL processServiceUrl = new URL(PROCESS_SERVICE_URL);
        ProcessServiceClient result = TaskAssigningConfigUtil.createProcessServiceClient((ClientServices)this.clientServices, (TaskAssigningConfig)config, (URL)processServiceUrl);
        Assertions.assertThat((Object)result).isSameAs((Object)this.processServiceClient);
        ((ProcessServiceClientFactory)Mockito.verify((Object)this.processServiceClientFactory)).newClient((ProcessServiceClientConfig)this.processServiceConfigCaptor.capture(), (AuthenticationCredentials)this.credentialsCaptor.capture());
        Assertions.assertThat((URL)((ProcessServiceClientConfig)this.processServiceConfigCaptor.getValue()).getServiceUrl()).isEqualTo((Object)processServiceUrl);
    }

    private void assertKeycloakAuth() {
        Assertions.assertThat((Object)((AuthenticationCredentials)this.credentialsCaptor.getValue())).isExactlyInstanceOf(KeycloakAuthenticationCredentials.class);
        KeycloakAuthenticationCredentials keycloakCredentials = (KeycloakAuthenticationCredentials)this.credentialsCaptor.getValue();
        Assertions.assertThat((String)keycloakCredentials.getServerUrl()).isEqualTo(CANONIC_AUTH_SERVER_URL);
        Assertions.assertThat((String)keycloakCredentials.getClientId()).isEqualTo(CLIENT_ID);
        Assertions.assertThat((String)keycloakCredentials.getClientSecret()).isEqualTo(CREDENTIALS_SECRET);
        Assertions.assertThat((String)keycloakCredentials.getRealm()).isEqualTo(REALM);
        Assertions.assertThat((String)keycloakCredentials.getUsername()).isEqualTo(CLIENT_USER);
        Assertions.assertThat((String)keycloakCredentials.getPassword()).isEqualTo(CLIENT_PASSWORD);
    }

    private void assertBasicAuth() {
        Assertions.assertThat((Object)((AuthenticationCredentials)this.credentialsCaptor.getValue())).isExactlyInstanceOf(BasicAuthenticationCredentials.class);
        BasicAuthenticationCredentials basicCredentials = (BasicAuthenticationCredentials)this.credentialsCaptor.getValue();
        Assertions.assertThat((String)basicCredentials.getUser()).isEqualTo(CLIENT_USER);
        Assertions.assertThat((String)basicCredentials.getPassword()).isEqualTo(CLIENT_PASSWORD);
    }

    private void assertNoAuth() {
        Assertions.assertThat((Object)((AuthenticationCredentials)this.credentialsCaptor.getValue())).isExactlyInstanceOf(NoAuthenticationCredentials.class);
        Assertions.assertThat((Object)((AuthenticationCredentials)this.credentialsCaptor.getValue())).isSameAs((Object)NoAuthenticationCredentials.INSTANCE);
    }

    private TaskAssigningConfig buildConfig() throws MalformedURLException {
        TaskAssigningConfig config = new TaskAssigningConfig();
        config.dataIndexServerUrl = new URL(DATA_INDEX_SERVER_URL);
        config.userServiceSyncInterval = SYNC_INTERVAL;
        config.userServiceSyncRetries = 1;
        config.userServiceSyncRetryInterval = SYNC_RETRY_INTERVAL;
        return config;
    }

    private TaskAssigningConfig buildKeycloakConfig() throws MalformedURLException {
        TaskAssigningConfig config = this.buildConfig();
        config.oidcTenantEnabled = true;
        config.oidcAuthServerUrl = Optional.of(new URL(AUTH_SERVER_URL));
        config.oidcClientId = Optional.of(CLIENT_ID);
        config.oidcCredentialsSecret = Optional.of(CREDENTIALS_SECRET);
        config.clientAuthUser = Optional.of(CLIENT_USER);
        config.clientAuthPassword = Optional.of(CLIENT_PASSWORD);
        return config;
    }

    private TaskAssigningConfig buildBasicAuthConfig() throws MalformedURLException {
        TaskAssigningConfig config = this.buildConfig();
        config.oidcTenantEnabled = false;
        config.clientAuthUser = Optional.of(CLIENT_USER);
        config.clientAuthPassword = Optional.of(CLIENT_PASSWORD);
        return config;
    }

    private TaskAssigningConfig buildNoAuthConfig() throws MalformedURLException {
        TaskAssigningConfig config = this.buildConfig();
        config.oidcTenantEnabled = false;
        config.clientAuthUser = Optional.empty();
        config.clientAuthPassword = Optional.empty();
        return config;
    }
}

