/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfigValidator;

class TaskAssigningConfigValidatorTest {
    private static final String DATA_INDEX_SERVER_URL = "http://localhost:8180/graphql";
    private static final String AUTH_SERVER_URL = "http://localhost:8280/auth/realms/kogito";
    private static final String CLIENT_ID = "CLIENT_ID";
    private static final String CREDENTIALS_SECRET = "CREDENTIALS_SECRET";
    private static final String CLIENT_USER = "CLIENT_USER";
    private static final String CLIENT_PASSWORD = "CLIENT_PASSWORD";
    private static final Duration SYNC_INTERVAL = Duration.of(1L, ChronoUnit.MILLIS);
    private static final int SYNC_RETRIES = 1;
    private static final Duration SYNC_RETRY_INTERVAL = Duration.of(1L, ChronoUnit.MILLIS);

    TaskAssigningConfigValidatorTest() {
    }

    @Test
    void validateDataIndexUrlNotSet() {
        TaskAssigningConfig config = new TaskAssigningConfig();
        Assertions.assertThatThrownBy(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate()).hasMessageContaining("kogito.task-assigning.data-index.server-url");
    }

    @Test
    void validateKeycloakSet() throws MalformedURLException {
        TaskAssigningConfig config = this.createValidKeycloakSet();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate());
    }

    @Test
    void validateKeycloakAuthServerIsNotSet() throws MalformedURLException {
        TaskAssigningConfig config = this.createValidKeycloakSet();
        config.oidcAuthServerUrl = Optional.empty();
        Assertions.assertThatThrownBy(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate()).hasMessageContaining("quarkus.oidc.auth-server-url");
    }

    @Test
    void validateKeycloakClientIdIsNotSet() throws MalformedURLException {
        TaskAssigningConfig config = this.createValidKeycloakSet();
        config.oidcClientId = Optional.empty();
        Assertions.assertThatThrownBy(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate()).hasMessageContaining("quarkus.oidc.client-id");
    }

    @Test
    void validateKeycloakCredentialsSecretIsNotSet() throws MalformedURLException {
        TaskAssigningConfig config = this.createValidKeycloakSet();
        config.oidcCredentialsSecret = Optional.empty();
        Assertions.assertThatThrownBy(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate()).hasMessageContaining("quarkus.oidc.credentials.secret");
    }

    @Test
    void validateKeycloakAuthUserIsNotSet() throws MalformedURLException {
        TaskAssigningConfig config = this.createValidKeycloakSet();
        config.clientAuthUser = Optional.empty();
        Assertions.assertThatThrownBy(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate()).hasMessageContaining("kogito.task-assigning.user");
    }

    @Test
    void validateKeycloakAuthPasswordIsNotSet() throws MalformedURLException {
        TaskAssigningConfig config = this.createValidKeycloakSet();
        config.clientAuthPassword = Optional.empty();
        Assertions.assertThatThrownBy(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate()).hasMessageContaining("kogito.task-assigning.password");
    }

    @Test
    void validateBasicAuthSet() throws MalformedURLException {
        TaskAssigningConfig config = new TaskAssigningConfig();
        config.oidcTenantEnabled = false;
        config.dataIndexServerUrl = new URL(DATA_INDEX_SERVER_URL);
        config.clientAuthUser = Optional.of(CLIENT_USER);
        config.clientAuthPassword = Optional.of(CLIENT_PASSWORD);
        config.userServiceSyncInterval = SYNC_INTERVAL;
        config.userServiceSyncRetryInterval = SYNC_RETRY_INTERVAL;
        config.userServiceSyncRetries = 1;
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate());
    }

    @Test
    void validateUserServiceSyncInterval() throws MalformedURLException {
        TaskAssigningConfig config = this.createValidConfigForSyncConfigTest();
        config.userServiceSyncInterval = Duration.of(-1L, ChronoUnit.MILLIS);
        Assertions.assertThatThrownBy(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate()).hasMessageContaining("kogito.task-assigning.user-service-sync.interval");
    }

    @Test
    void validateUserServiceSyncRetries() throws MalformedURLException {
        TaskAssigningConfig config = this.createValidConfigForSyncConfigTest();
        config.userServiceSyncInterval = SYNC_INTERVAL;
        config.userServiceSyncRetries = -1;
        Assertions.assertThatThrownBy(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate()).hasMessageContaining("kogito.task-assigning.user-service-sync.retries");
    }

    @Test
    void validateUserServiceSyncRetryInterval() throws MalformedURLException {
        TaskAssigningConfig config = this.createValidConfigForSyncConfigTest();
        config.userServiceSyncInterval = SYNC_INTERVAL;
        config.userServiceSyncRetries = 1;
        config.userServiceSyncRetryInterval = Duration.of(-1L, ChronoUnit.MILLIS);
        Assertions.assertThatThrownBy(() -> TaskAssigningConfigValidator.of((TaskAssigningConfig)config).validate()).hasMessageContaining("kogito.task-assigning.user-service-sync.retry-interval");
    }

    private TaskAssigningConfig createValidKeycloakSet() throws MalformedURLException {
        TaskAssigningConfig config = new TaskAssigningConfig();
        config.oidcTenantEnabled = true;
        config.dataIndexServerUrl = new URL(DATA_INDEX_SERVER_URL);
        config.oidcAuthServerUrl = Optional.of(new URL(AUTH_SERVER_URL));
        config.oidcClientId = Optional.of(CLIENT_ID);
        config.oidcCredentialsSecret = Optional.of(CREDENTIALS_SECRET);
        config.clientAuthUser = Optional.of(CLIENT_USER);
        config.clientAuthPassword = Optional.of(CLIENT_PASSWORD);
        config.userServiceSyncInterval = SYNC_INTERVAL;
        config.userServiceSyncRetryInterval = SYNC_RETRY_INTERVAL;
        config.userServiceSyncRetries = 1;
        return config;
    }

    private TaskAssigningConfig createValidConfigForSyncConfigTest() throws MalformedURLException {
        TaskAssigningConfig config = new TaskAssigningConfig();
        config.dataIndexServerUrl = new URL(DATA_INDEX_SERVER_URL);
        config.clientAuthUser = Optional.empty();
        return config;
    }
}

