/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.event;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.service.event.BufferedTaskAssigningServiceEventConsumer;
import org.kie.kogito.taskassigning.service.event.DataEvent;
import org.kie.kogito.taskassigning.service.event.TaskDataEvent;
import org.kie.kogito.taskassigning.service.event.UserDataEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class BufferedTaskAssigningServiceEventConsumerTest {
    private BufferedTaskAssigningServiceEventConsumer taskAssigningServiceEventConsumer;
    @Mock
    private Consumer<List<DataEvent<?>>> consumer;
    @Captor
    private ArgumentCaptor<List<DataEvent<?>>> eventsCaptor;
    @Mock
    private TaskDataEvent event1;
    @Mock
    private UserDataEvent event2;

    BufferedTaskAssigningServiceEventConsumerTest() {
    }

    @BeforeEach
    void setUp() {
        this.taskAssigningServiceEventConsumer = new BufferedTaskAssigningServiceEventConsumer();
        this.taskAssigningServiceEventConsumer.setConsumer(this.consumer);
    }

    @Test
    void pause() {
        this.taskAssigningServiceEventConsumer.pause();
        this.taskAssigningServiceEventConsumer.accept((DataEvent)this.event1);
        this.taskAssigningServiceEventConsumer.accept((DataEvent)this.event2);
        ((Consumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.never())).accept(ArgumentMatchers.anyList());
    }

    @Test
    void resume() {
        this.taskAssigningServiceEventConsumer.pause();
        this.taskAssigningServiceEventConsumer.accept((DataEvent)this.event1);
        this.taskAssigningServiceEventConsumer.accept((DataEvent)this.event2);
        ((Consumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.never())).accept(ArgumentMatchers.anyList());
        this.taskAssigningServiceEventConsumer.resume();
        ((Consumer)Mockito.verify(this.consumer)).accept((List)this.eventsCaptor.capture());
        Assertions.assertThat((List)((List)this.eventsCaptor.getValue())).isNotNull();
        Assertions.assertThat((List)((List)this.eventsCaptor.getValue())).containsExactlyElementsOf(Arrays.asList(this.event1, this.event2));
    }

    @Test
    void pollEvents() {
        this.taskAssigningServiceEventConsumer.pause();
        this.taskAssigningServiceEventConsumer.accept((DataEvent)this.event1);
        this.taskAssigningServiceEventConsumer.accept((DataEvent)this.event2);
        ((Consumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.never())).accept(ArgumentMatchers.anyList());
        List events = this.taskAssigningServiceEventConsumer.pollEvents();
        ((ListAssert)Assertions.assertThat((List)events).hasSize(2)).containsExactlyElementsOf(Arrays.asList(this.event1, this.event2));
        this.taskAssigningServiceEventConsumer.resume();
        ((Consumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.never())).accept(ArgumentMatchers.anyList());
    }

    @Test
    void queuedEvents() {
        this.taskAssigningServiceEventConsumer.pause();
        this.taskAssigningServiceEventConsumer.accept((DataEvent)this.event1);
        this.taskAssigningServiceEventConsumer.accept((DataEvent)this.event2);
        Assertions.assertThat((int)this.taskAssigningServiceEventConsumer.queuedEvents()).isEqualTo(2);
    }
}

