/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.messaging;

import java.time.ZonedDateTime;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.taskassigning.service.TestUtil;
import org.kie.kogito.taskassigning.service.event.DataEvent;
import org.kie.kogito.taskassigning.service.event.TaskAssigningServiceEventConsumer;
import org.kie.kogito.taskassigning.service.event.TaskDataEvent;
import org.kie.kogito.taskassigning.service.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.taskassigning.service.messaging.UserTaskEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ReactiveMessagingEventConsumerTest {
    private static final String TASK_ID = "TASK_ID";
    private static final ZonedDateTime LAST_MODIFICATION_DATE = TestUtil.parseZonedDateTime("2021-03-11T15:00:00.001Z");
    @Captor
    private ArgumentCaptor<TaskDataEvent> taskDataEventCaptor;

    ReactiveMessagingEventConsumerTest() {
    }

    @Test
    @Timeout(value=10L)
    void onUserTaskEvent() throws Exception {
        TaskAssigningServiceEventConsumer taskAssigningServiceEventConsumer = (TaskAssigningServiceEventConsumer)Mockito.mock(TaskAssigningServiceEventConsumer.class);
        ReactiveMessagingEventConsumer consumer = (ReactiveMessagingEventConsumer)Mockito.spy((Object)new ReactiveMessagingEventConsumer(taskAssigningServiceEventConsumer));
        UserTaskEvent event = new UserTaskEvent();
        event.setTaskId(TASK_ID);
        event.setLastUpdate(LAST_MODIFICATION_DATE);
        Message message = Message.of((Object)event);
        CompletionStage stage = consumer.onUserTaskEvent(message);
        stage.toCompletableFuture().get();
        ((TaskAssigningServiceEventConsumer)Mockito.verify((Object)taskAssigningServiceEventConsumer)).accept((DataEvent)this.taskDataEventCaptor.capture());
        Assertions.assertThat((String)((TaskDataEvent)this.taskDataEventCaptor.getValue()).getTaskId()).isEqualTo(TASK_ID);
        Assertions.assertThat((ZonedDateTime)((TaskDataEvent)this.taskDataEventCaptor.getValue()).getEventTime()).isEqualTo((Object)LAST_MODIFICATION_DATE);
    }
}

