/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.messaging;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.service.TestUtil;
import org.kie.kogito.taskassigning.service.messaging.UserTaskEvent;
import org.kie.kogito.taskassigning.service.messaging.UserTaskEventDeserializer;

class UserTaskEventDeserializerTest {
    private static final String TOPIC = "TOPIC";
    private static final String TASK_INSTANCE_ID = "TASK_INSTANCE_ID";
    private static final String TASK_NAME = "TASK_NAME";
    private static final String TASK_DESCRIPTION = "TASK_DESCRIPTION";
    private static final String TASK_PRIORITY = "0";
    private static final String REFERENCE_NAME = "REFERENCE_NAME";
    private static final String START_DATE = "2020-12-10T15:50:15.917+01:00";
    private static final String COMPLETED_DATE = "2020-12-11T15:50:15.917+01:00";
    private static final String LAST_UPDATE = "2020-12-11T15:50:15.917+01:00";
    private static final String EVENT_TIME = "2020-12-11T15:50:15.917635+01:00";
    private static final String STATE = "STATE";
    private static final String ACTUAL_OWNER = "ACTUAL_OWNER";
    private static final List<String> POTENTIAL_USERS = Arrays.asList("POTENTIAL_USER_1", "POTENTIAL_USER_2");
    private static final List<String> POTENTIAL_GROUPS = Arrays.asList("POTENTIAL_GROUP_1", "POTENTIAL_GROUP_2");
    private static final List<String> EXCLUDED_USERS = Arrays.asList("EXCLUDED_USER_1", "EXCLUDED_USER_2");
    private static final List<String> ADMIN_USERS = Arrays.asList("ADMIN_USER_1", "ADMIN_USER_2");
    private static final List<String> ADMIN_GROUPS = Arrays.asList("ADMIN_GROUP_1", "ADMIN_GROUP_2");
    private static final String INPUT_1 = "INPUT_1";
    private static final String INPUT_2 = "INPUT_2";
    private static final String INPUT_VALUE_1 = "INPUT_VALUE_1";
    private static final String INPUT_VALUE_2 = "INPUT_VALUE_2";
    private static final String PROCESS_INSTANCE_ID = "PROCESS_INSTANCE_ID";
    private static final String ROOT_PROCESS_INSTANCE_ID = "ROOT_PROCESS_INSTANCE_ID";
    private static final String PROCESS_ID = "PROCESS_ID";
    private static final String ROOT_PROCESS_ID = "ROOT_PROCESS_ID";
    private static final String ENDPOINT = "http://myapplication.cloud.com:8280/PROCESS_ID/PROCESS_INSTANCE_ID/TASK_NAME/TASK_INSTANCE_ID";
    private UserTaskEventDeserializer deserializer;

    UserTaskEventDeserializerTest() {
    }

    @BeforeEach
    void setUp() {
        this.deserializer = new UserTaskEventDeserializer();
    }

    @Test
    void deserialize() throws Exception {
        Path path = Paths.get(Thread.currentThread().getContextClassLoader().getResource("org/kie/kogito/taskassigning/messaging/UserTaskCloudEvent.json").toURI());
        byte[] eventBytes = Files.readAllBytes(path);
        UserTaskEvent event = this.deserializer.deserialize(TOPIC, eventBytes);
        Assertions.assertThat((Object)event).isNotNull();
        Assertions.assertThat((String)event.getTaskId()).isEqualTo(TASK_INSTANCE_ID);
        Assertions.assertThat((String)event.getName()).isEqualTo(TASK_NAME);
        Assertions.assertThat((String)event.getDescription()).isEqualTo(TASK_DESCRIPTION);
        Assertions.assertThat((String)event.getPriority()).isEqualTo(TASK_PRIORITY);
        Assertions.assertThat((String)event.getReferenceName()).isEqualTo(REFERENCE_NAME);
        Assertions.assertThat((ZonedDateTime)event.getEventTime()).isEqualTo((Object)TestUtil.parseZonedDateTime(EVENT_TIME));
        Assertions.assertThat((ZonedDateTime)event.getStarted()).isEqualTo((Object)TestUtil.parseZonedDateTime(START_DATE));
        Assertions.assertThat((ZonedDateTime)event.getCompleted()).isEqualTo((Object)TestUtil.parseZonedDateTime("2020-12-11T15:50:15.917+01:00"));
        Assertions.assertThat((ZonedDateTime)event.getLastUpdate()).isEqualTo("2020-12-11T15:50:15.917+01:00");
        Assertions.assertThat((String)event.getState()).isEqualTo(STATE);
        Assertions.assertThat((String)event.getActualOwner()).isEqualTo(ACTUAL_OWNER);
        Assertions.assertThat((List)event.getPotentialUsers()).isEqualTo(POTENTIAL_USERS);
        Assertions.assertThat((List)event.getPotentialGroups()).isEqualTo(POTENTIAL_GROUPS);
        Assertions.assertThat((List)event.getExcludedUsers()).isEqualTo(EXCLUDED_USERS);
        Assertions.assertThat((List)event.getAdminUsers()).isEqualTo(ADMIN_USERS);
        Assertions.assertThat((List)event.getAdminGroups()).isEqualTo(ADMIN_GROUPS);
        Assertions.assertThat((int)event.getInputs().size()).isEqualTo(2);
        UserTaskEventDeserializerTest.assertHasValue(event.getInputs(), INPUT_1, INPUT_VALUE_1);
        UserTaskEventDeserializerTest.assertHasValue(event.getInputs(), INPUT_2, INPUT_VALUE_2);
        Assertions.assertThat((String)event.getProcessId()).isEqualTo(PROCESS_ID);
        Assertions.assertThat((String)event.getProcessInstanceId()).isEqualTo(PROCESS_INSTANCE_ID);
        Assertions.assertThat((String)event.getRootProcessId()).isEqualTo(ROOT_PROCESS_ID);
        Assertions.assertThat((String)event.getRootProcessInstanceId()).isEqualTo(ROOT_PROCESS_INSTANCE_ID);
        Assertions.assertThat((String)event.getEndpoint()).isEqualTo(ENDPOINT);
    }

    @Test
    void deserializeNull() {
        Assertions.assertThat((Object)this.deserializer.deserialize(TOPIC, null)).isNull();
    }

    @Test
    void deserializeError() {
        Assertions.assertThatThrownBy(() -> this.deserializer.deserialize(TOPIC, "wrong json".getBytes())).hasMessageStartingWith("An error was produced during UserTaskEventMessage deserialization");
    }

    private static void assertHasValue(JsonNode node, String name, String value) {
        JsonNode valueNode = node.get(name);
        Assertions.assertThat((Iterable)valueNode).isNotNull();
        Assertions.assertThat((String)valueNode.asText()).isEqualTo(value);
    }
}

