/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.util;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceContext;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TestUtil;
import org.kie.kogito.taskassigning.service.event.DataEvent;
import org.kie.kogito.taskassigning.service.event.TaskDataEvent;
import org.kie.kogito.taskassigning.service.event.UserDataEvent;
import org.kie.kogito.taskassigning.service.util.EventUtil;
import org.mockito.Mockito;

class EventUtilTest {
    private static final String TASK_1 = "TASK_1";
    private static final String TASK_2 = "TASK_2";
    private static final String TASK_3 = "TASK_3";
    private static final String TASK_4 = "TASK_4";
    private static final TaskDataEvent TASK_1_EVENT_1 = EventUtilTest.mockTaskDataEvent("TASK_1", TestUtil.parseZonedDateTime("2021-03-10T08:00:00.001Z"));
    private static final TaskDataEvent TASK_1_EVENT_2 = EventUtilTest.mockTaskDataEvent("TASK_1", TestUtil.parseZonedDateTime("2021-03-10T08:00:00.002Z"));
    private static final TaskDataEvent TASK_1_EVENT_3 = EventUtilTest.mockTaskDataEvent("TASK_1", TestUtil.parseZonedDateTime("2021-03-10T08:00:00.003Z"));
    private static final TaskDataEvent TASK_2_EVENT_1 = EventUtilTest.mockTaskDataEvent("TASK_2", TestUtil.parseZonedDateTime("2021-03-11T08:00:00.001Z"));
    private static final TaskDataEvent TASK_2_EVENT_2 = EventUtilTest.mockTaskDataEvent("TASK_2", TestUtil.parseZonedDateTime("2021-03-11T08:00:00.002Z"));
    private static final TaskDataEvent TASK_2_EVENT_3 = EventUtilTest.mockTaskDataEvent("TASK_2", TestUtil.parseZonedDateTime("2021-03-11T08:00:00.003Z"));
    private static final TaskDataEvent TASK_3_EVENT_1 = EventUtilTest.mockTaskDataEvent("TASK_3", TestUtil.parseZonedDateTime("2021-03-12T08:00:00.001Z"));
    private static final TaskDataEvent TASK_3_EVENT_2 = EventUtilTest.mockTaskDataEvent("TASK_3", TestUtil.parseZonedDateTime("2021-03-12T08:00:00.002Z"));
    private static final TaskDataEvent TASK_3_EVENT_3 = EventUtilTest.mockTaskDataEvent("TASK_3", TestUtil.parseZonedDateTime("2021-03-12T08:00:00.003Z"));
    private static final TaskDataEvent TASK_4_EVENT_1 = EventUtilTest.mockTaskDataEvent("TASK_4", TestUtil.parseZonedDateTime("2021-03-12T08:00:00.001Z"));
    private static final TaskDataEvent TASK_4_EVENT_2 = EventUtilTest.mockTaskDataEvent("TASK_4", TestUtil.parseZonedDateTime("2021-03-12T08:00:00.002Z"));
    private static final TaskDataEvent TASK_4_EVENT_3 = EventUtilTest.mockTaskDataEvent("TASK_4", TestUtil.parseZonedDateTime("2021-03-12T08:00:00.003Z"));
    private static final UserDataEvent USER_DATA_EVENT_1 = EventUtilTest.mockUserDataEvent(TestUtil.parseZonedDateTime("2021-03-31T08:00:00.001Z"));
    private static final UserDataEvent USER_DATA_EVENT_2 = EventUtilTest.mockUserDataEvent(TestUtil.parseZonedDateTime("2021-03-31T08:00:00.002Z"));
    private static final UserDataEvent USER_DATA_EVENT_3 = EventUtilTest.mockUserDataEvent(TestUtil.parseZonedDateTime("2021-03-31T08:00:00.003Z"));

    EventUtilTest() {
    }

    @Test
    void filterNewestTaskEventsInContext() {
        TaskAssigningServiceContext context = new TaskAssigningServiceContext();
        context.setTaskLastEventTime(TASK_2, TASK_2_EVENT_1.getEventTime());
        context.setTaskLastEventTime(TASK_3, TASK_3_EVENT_2.getEventTime());
        context.setTaskLastEventTime(TASK_4, TASK_4_EVENT_3.getEventTime());
        List<DataEvent<?>> eventList = EventUtilTest.buildDataEvents();
        List result = EventUtil.filterNewestTaskEventsInContext((TaskAssigningServiceContext)context, eventList);
        ((ListAssert)Assertions.assertThat((List)result).hasSize(3)).contains((Object[])new TaskDataEvent[]{TASK_1_EVENT_3, TASK_2_EVENT_3, TASK_3_EVENT_3});
        Assertions.assertThat((ZonedDateTime)context.getTaskLastEventTime(TASK_1)).isEqualTo((Object)TASK_1_EVENT_3.getEventTime());
        Assertions.assertThat((ZonedDateTime)context.getTaskLastEventTime(TASK_2)).isEqualTo((Object)TASK_2_EVENT_3.getEventTime());
        Assertions.assertThat((ZonedDateTime)context.getTaskLastEventTime(TASK_3)).isEqualTo((Object)TASK_3_EVENT_3.getEventTime());
        Assertions.assertThat((ZonedDateTime)context.getTaskLastEventTime(TASK_4)).isEqualTo((Object)TASK_4_EVENT_3.getEventTime());
    }

    @Test
    void filterNewestTaskEvents() {
        List<DataEvent<?>> eventList = EventUtilTest.buildDataEvents();
        List result = EventUtil.filterNewestTaskEvents(eventList);
        ((ListAssert)Assertions.assertThat((List)result).hasSize(4)).contains((Object[])new TaskDataEvent[]{TASK_1_EVENT_3, TASK_2_EVENT_3, TASK_3_EVENT_3, TASK_4_EVENT_3});
    }

    @Test
    void filterNewestUserEvent() {
        List<DataEvent<?>> eventList = EventUtilTest.buildDataEvents();
        UserDataEvent result = EventUtil.filterNewestUserEvent(eventList);
        Assertions.assertThat((Object)result).isSameAs((Object)USER_DATA_EVENT_3);
    }

    private static List<DataEvent<?>> buildDataEvents() {
        return Arrays.asList(TASK_4_EVENT_1, TASK_1_EVENT_1, TASK_2_EVENT_3, TASK_4_EVENT_2, TASK_1_EVENT_3, TASK_2_EVENT_1, USER_DATA_EVENT_1, TASK_3_EVENT_2, TASK_4_EVENT_3, TASK_2_EVENT_2, USER_DATA_EVENT_3, TASK_3_EVENT_1, TASK_1_EVENT_2, USER_DATA_EVENT_2, TASK_3_EVENT_3);
    }

    private static TaskDataEvent mockTaskDataEvent(String taskId, ZonedDateTime lastUpdate) {
        TaskData taskData = (TaskData)Mockito.mock(TaskData.class);
        ((TaskData)Mockito.doReturn((Object)taskId).when((Object)taskData)).getId();
        ((TaskData)Mockito.doReturn((Object)lastUpdate).when((Object)taskData)).getLastUpdate();
        return new TaskDataEvent(taskData);
    }

    private static UserDataEvent mockUserDataEvent(ZonedDateTime eventTime) {
        return new UserDataEvent(Collections.emptyList(), eventTime);
    }
}

