/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.index.service.client.graphql.UserTaskInstance;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TestUtil;
import org.kie.kogito.taskassigning.service.event.TaskDataEvent;
import org.kie.kogito.taskassigning.service.messaging.UserTaskEvent;
import org.kie.kogito.taskassigning.service.util.TaskUtil;
import org.mockito.Mockito;

class TaskUtilTest {
    private static final String TASK_ID = "TASK_ID";
    private static final String TASK_NAME = "TASK_NAME";
    private static final String TASK_DESCRIPTION = "TASK_DESCRIPTION";
    private static final String TASK_PRIORITY = "0";
    private static final String REFERENCE_NAME = "REFERENCE_NAME";
    private static final String ENDPOINT = "ENDPOINT";
    private static final ZonedDateTime START_DATE = TestUtil.parseZonedDateTime("2021-02-10T10:00:00.000+01:00");
    private static final ZonedDateTime LAST_UPDATE = TestUtil.parseZonedDateTime("2021-02-10T11:00:00.000+01:00");
    private static final ZonedDateTime COMPLETED_DATE = TestUtil.parseZonedDateTime("2021-02-10T12:00:00.000+01:00");
    private static final String STATE = "STATE";
    private static final String ACTUAL_OWNER = "ACTUAL_OWNER";
    private static final List<String> POTENTIAL_USERS = Arrays.asList("POTENTIAL_USER_1", "POTENTIAL_USER_2");
    private static final List<String> POTENTIAL_GROUPS = Arrays.asList("POTENTIAL_GROUP_1", "POTENTIAL_GROUP_2");
    private static final List<String> EXCLUDED_USERS = Arrays.asList("EXCLUDED_USER_1", "EXCLUDED_USER_2");
    private static final List<String> ADMIN_USERS = Arrays.asList("ADMIN_USER_1", "ADMIN_USER_2");
    private static final List<String> ADMIN_GROUPS = Arrays.asList("ADMIN_GROUP_1", "ADMIN_GROUP_2");
    private static final String PROCESS_INSTANCE_ID = "PROCESS_INSTANCE_ID";
    private static final String ROOT_PROCESS_INSTANCE_ID = "ROOT_PROCESS_INSTANCE_ID";
    private static final String PROCESS_ID = "PROCESS_ID";
    private static final String ROOT_PROCESS_ID = "ROOT_PROCESS_ID";

    TaskUtilTest() {
    }

    @Test
    void fromUserTaskInstances() {
        UserTaskInstance userTaskInstance = new UserTaskInstance();
        userTaskInstance.setId(TASK_ID);
        userTaskInstance.setDescription(TASK_DESCRIPTION);
        userTaskInstance.setName(TASK_NAME);
        userTaskInstance.setPriority(TASK_PRIORITY);
        userTaskInstance.setProcessInstanceId(PROCESS_INSTANCE_ID);
        userTaskInstance.setProcessId(PROCESS_ID);
        userTaskInstance.setRootProcessInstanceId(ROOT_PROCESS_INSTANCE_ID);
        userTaskInstance.setRootProcessId(ROOT_PROCESS_ID);
        userTaskInstance.setState(STATE);
        userTaskInstance.setActualOwner(ACTUAL_OWNER);
        userTaskInstance.setAdminGroups(ADMIN_GROUPS);
        userTaskInstance.setAdminUsers(ADMIN_USERS);
        userTaskInstance.setCompleted(COMPLETED_DATE);
        userTaskInstance.setStarted(START_DATE);
        userTaskInstance.setExcludedUsers(EXCLUDED_USERS);
        userTaskInstance.setPotentialGroups(POTENTIAL_GROUPS);
        userTaskInstance.setPotentialUsers(POTENTIAL_USERS);
        userTaskInstance.setReferenceName(REFERENCE_NAME);
        userTaskInstance.setLastUpdate(LAST_UPDATE);
        userTaskInstance.setEndpoint(ENDPOINT);
        List result = TaskUtil.fromUserTaskInstances(Collections.singletonList(userTaskInstance));
        Assertions.assertThat((List)result).hasSize(1);
        TaskData taskData = (TaskData)result.get(0);
        this.assertExpectedTaskData(taskData);
    }

    @Test
    void fromTaskDataEvents() {
        TaskData taskData1 = (TaskData)Mockito.mock(TaskData.class);
        TaskData taskData2 = (TaskData)Mockito.mock(TaskData.class);
        List result = TaskUtil.fromTaskDataEvents(Arrays.asList(new TaskDataEvent(taskData1), new TaskDataEvent(taskData2)));
        Assertions.assertThat((List)result).containsExactly((Object[])new TaskData[]{taskData1, taskData2});
    }

    @Test
    void fromUserTaskEvent() {
        UserTaskEvent userTaskEvent = new UserTaskEvent();
        userTaskEvent.setTaskId(TASK_ID);
        userTaskEvent.setDescription(TASK_DESCRIPTION);
        userTaskEvent.setName(TASK_NAME);
        userTaskEvent.setPriority(TASK_PRIORITY);
        userTaskEvent.setProcessInstanceId(PROCESS_INSTANCE_ID);
        userTaskEvent.setProcessId(PROCESS_ID);
        userTaskEvent.setRootProcessInstanceId(ROOT_PROCESS_INSTANCE_ID);
        userTaskEvent.setRootProcessId(ROOT_PROCESS_ID);
        userTaskEvent.setState(STATE);
        userTaskEvent.setActualOwner(ACTUAL_OWNER);
        userTaskEvent.setAdminGroups(ADMIN_GROUPS);
        userTaskEvent.setAdminUsers(ADMIN_USERS);
        userTaskEvent.setCompleted(COMPLETED_DATE);
        userTaskEvent.setStarted(START_DATE);
        userTaskEvent.setExcludedUsers(EXCLUDED_USERS);
        userTaskEvent.setPotentialGroups(POTENTIAL_GROUPS);
        userTaskEvent.setPotentialUsers(POTENTIAL_USERS);
        userTaskEvent.setReferenceName(REFERENCE_NAME);
        userTaskEvent.setLastUpdate(LAST_UPDATE);
        userTaskEvent.setEndpoint(ENDPOINT);
        TaskData result = TaskUtil.fromUserTaskEvent((UserTaskEvent)userTaskEvent);
        Assertions.assertThat((Object)result).isNotNull();
        this.assertExpectedTaskData(result);
    }

    @Test
    void fromTaskData() {
        Task task = TaskUtil.fromTaskData((TaskData)new TaskData(){

            public String getId() {
                return TaskUtilTest.TASK_ID;
            }

            public String getName() {
                return TaskUtilTest.TASK_NAME;
            }

            public String getState() {
                return TaskUtilTest.STATE;
            }

            public String getDescription() {
                return TaskUtilTest.TASK_DESCRIPTION;
            }

            public String getReferenceName() {
                return TaskUtilTest.REFERENCE_NAME;
            }

            public String getPriority() {
                return TaskUtilTest.TASK_PRIORITY;
            }

            public String getProcessInstanceId() {
                return TaskUtilTest.PROCESS_INSTANCE_ID;
            }

            public String getProcessId() {
                return TaskUtilTest.PROCESS_ID;
            }

            public String getRootProcessInstanceId() {
                return TaskUtilTest.ROOT_PROCESS_INSTANCE_ID;
            }

            public String getRootProcessId() {
                return TaskUtilTest.ROOT_PROCESS_ID;
            }

            public String getActualOwner() {
                return TaskUtilTest.ACTUAL_OWNER;
            }

            public Set<String> getPotentialUsers() {
                return new HashSet<String>(POTENTIAL_USERS);
            }

            public Set<String> getPotentialGroups() {
                return new HashSet<String>(POTENTIAL_GROUPS);
            }

            public Set<String> getAdminUsers() {
                return new HashSet<String>(ADMIN_USERS);
            }

            public Set<String> getAdminGroups() {
                return new HashSet<String>(ADMIN_GROUPS);
            }

            public Set<String> getExcludedUsers() {
                return new HashSet<String>(EXCLUDED_USERS);
            }

            public ZonedDateTime getStarted() {
                return START_DATE;
            }

            public ZonedDateTime getCompleted() {
                return COMPLETED_DATE;
            }

            public ZonedDateTime getLastUpdate() {
                return LAST_UPDATE;
            }

            public JsonNode getInputs() {
                return null;
            }

            public String getEndpoint() {
                return TaskUtilTest.ENDPOINT;
            }
        });
        Assertions.assertThat((String)task.getId()).isEqualTo(TASK_ID);
        Assertions.assertThat((String)task.getDescription()).isEqualTo(TASK_DESCRIPTION);
        Assertions.assertThat((String)task.getName()).isEqualTo(TASK_NAME);
        Assertions.assertThat((String)task.getPriority()).isEqualTo(TASK_PRIORITY);
        Assertions.assertThat((String)task.getProcessInstanceId()).isEqualTo(PROCESS_INSTANCE_ID);
        Assertions.assertThat((String)task.getProcessId()).isEqualTo(PROCESS_ID);
        Assertions.assertThat((String)task.getRootProcessId()).isEqualTo(ROOT_PROCESS_ID);
        Assertions.assertThat((String)task.getRootProcessInstanceId()).isEqualTo(ROOT_PROCESS_INSTANCE_ID);
        Assertions.assertThat((String)task.getState()).isEqualTo(STATE);
        Assertions.assertThat((Iterable)task.getAdminGroups()).containsExactlyInAnyOrder((Object[])ADMIN_GROUPS.toArray(new String[0]));
        Assertions.assertThat((Iterable)task.getAdminUsers()).containsExactlyInAnyOrder((Object[])ADMIN_USERS.toArray(new String[0]));
        Assertions.assertThat((ZonedDateTime)task.getCompleted()).isEqualTo((Object)COMPLETED_DATE);
        Assertions.assertThat((ZonedDateTime)task.getStarted()).isEqualTo((Object)START_DATE);
        Assertions.assertThat((Iterable)task.getExcludedUsers()).containsExactlyInAnyOrder((Object[])EXCLUDED_USERS.toArray(new String[0]));
        Assertions.assertThat((Iterable)task.getPotentialGroups()).containsExactlyInAnyOrder((Object[])POTENTIAL_GROUPS.toArray(new String[0]));
        Assertions.assertThat((Iterable)task.getPotentialUsers()).containsExactlyInAnyOrder((Object[])POTENTIAL_USERS.toArray(new String[0]));
        Assertions.assertThat((String)task.getReferenceName()).isEqualTo(REFERENCE_NAME);
        Assertions.assertThat((ZonedDateTime)task.getLastUpdate()).isEqualTo((Object)LAST_UPDATE);
        Assertions.assertThat((String)task.getEndpoint()).isEqualTo(ENDPOINT);
    }

    private void assertExpectedTaskData(TaskData taskData) {
        Assertions.assertThat((String)taskData.getId()).isEqualTo(TASK_ID);
        Assertions.assertThat((String)taskData.getDescription()).isEqualTo(TASK_DESCRIPTION);
        Assertions.assertThat((String)taskData.getName()).isEqualTo(TASK_NAME);
        Assertions.assertThat((String)taskData.getPriority()).isEqualTo(TASK_PRIORITY);
        Assertions.assertThat((String)taskData.getProcessInstanceId()).isEqualTo(PROCESS_INSTANCE_ID);
        Assertions.assertThat((String)taskData.getProcessId()).isEqualTo(PROCESS_ID);
        Assertions.assertThat((String)taskData.getRootProcessId()).isEqualTo(ROOT_PROCESS_ID);
        Assertions.assertThat((String)taskData.getRootProcessInstanceId()).isEqualTo(ROOT_PROCESS_INSTANCE_ID);
        Assertions.assertThat((String)taskData.getState()).isEqualTo(STATE);
        Assertions.assertThat((Iterable)taskData.getAdminGroups()).containsExactlyInAnyOrder((Object[])ADMIN_GROUPS.toArray(new String[0]));
        Assertions.assertThat((Iterable)taskData.getAdminUsers()).containsExactlyInAnyOrder((Object[])ADMIN_USERS.toArray(new String[0]));
        Assertions.assertThat((ZonedDateTime)taskData.getCompleted()).isEqualTo((Object)COMPLETED_DATE);
        Assertions.assertThat((ZonedDateTime)taskData.getStarted()).isEqualTo((Object)START_DATE);
        Assertions.assertThat((Iterable)taskData.getExcludedUsers()).containsExactlyInAnyOrder((Object[])EXCLUDED_USERS.toArray(new String[0]));
        Assertions.assertThat((Iterable)taskData.getPotentialGroups()).containsExactlyInAnyOrder((Object[])POTENTIAL_GROUPS.toArray(new String[0]));
        Assertions.assertThat((Iterable)taskData.getPotentialUsers()).containsExactlyInAnyOrder((Object[])POTENTIAL_USERS.toArray(new String[0]));
        Assertions.assertThat((String)taskData.getReferenceName()).isEqualTo(REFERENCE_NAME);
        Assertions.assertThat((ZonedDateTime)taskData.getLastUpdate()).isEqualTo((Object)LAST_UPDATE);
        Assertions.assertThat((String)taskData.getEndpoint()).isEqualTo(ENDPOINT);
    }
}

