/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.core.model.IdentifiableElement;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.service.TestUtil;
import org.kie.kogito.taskassigning.service.util.UserUtil;

class UserUtilTest {
    private static final String USER_ID_1 = "USER_ID_1";
    private static final String USER_ID_2 = "USER_ID_2";
    private static final String USER_ID_3 = "USER_ID_3";
    private static final String GROUP_ID_1 = "GROUP_ID_1";
    private static final String GROUP_ID_2 = "GROUP_ID_2";
    private static final String ATTRIBUTE_1_NAME = "ATTRIBUTE_1_NAME";
    private static final String ATTRIBUTE_1_VALUE = "ATTRIBUTE_1_VALUE";
    private static final String ATTRIBUTE_2_NAME = "ATTRIBUTE_2_NAME";
    private static final String ATTRIBUTE_2_VALUE = "ATTRIBUTE_2_VALUE";

    UserUtilTest() {
    }

    @Test
    void fromExternalUser() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(ATTRIBUTE_1_NAME, ATTRIBUTE_1_VALUE);
        attributes.put(ATTRIBUTE_2_NAME, ATTRIBUTE_2_VALUE);
        org.kie.kogito.taskassigning.user.service.User externalUser = TestUtil.mockExternalUser(USER_ID_1, Arrays.asList(GROUP_ID_1, GROUP_ID_2), attributes);
        User user = UserUtil.fromExternalUser((org.kie.kogito.taskassigning.user.service.User)externalUser);
        Assertions.assertThat((String)user.getId()).isEqualTo(USER_ID_1);
        Assertions.assertThat((Iterable)user.getGroups().stream().map(IdentifiableElement::getId).collect(Collectors.toSet())).containsExactlyInAnyOrder((Object[])new String[]{GROUP_ID_1, GROUP_ID_2});
        Assertions.assertThat((Map)user.getAttributes()).containsExactlyEntriesOf(attributes);
    }

    @Test
    void filterDuplicates() {
        List<org.kie.kogito.taskassigning.user.service.User> users = Arrays.asList(TestUtil.mockExternalUser(USER_ID_1), TestUtil.mockExternalUser(USER_ID_2), TestUtil.mockExternalUser(USER_ID_1), TestUtil.mockExternalUser(USER_ID_3), TestUtil.mockExternalUser(USER_ID_2), TestUtil.mockExternalUser(USER_ID_1), null);
        List filteredUsers = UserUtil.filterDuplicates(users).collect(Collectors.toList());
        Assertions.assertThat(filteredUsers.stream().map(org.kie.kogito.taskassigning.user.service.User::getId).collect(Collectors.toList())).containsExactlyInAnyOrderElementsOf(Arrays.asList(USER_ID_1, USER_ID_2, USER_ID_3));
    }
}

