/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.kie.kogito.taskassigning.ClientServices;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.process.service.client.ProcessServiceClient;
import org.kie.kogito.taskassigning.service.PlanningExecutionResult;
import org.kie.kogito.taskassigning.service.PlanningExecutionResultItem;
import org.kie.kogito.taskassigning.service.PlanningItem;
import org.kie.kogito.taskassigning.service.RunnableBase;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanningExecutor
extends RunnableBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanningExecutor.class);
    private static final String CLAIM_PHASE = "claim";
    private TaskAssigningConfig config;
    private ClientServices clientServices;
    private List<PlanningItem> planningItems;
    private Consumer<PlanningExecutionResult> resultConsumer;
    private Map<String, ProcessServiceClient> serviceClientMap = new HashMap<String, ProcessServiceClient>();

    public PlanningExecutor(ClientServices clientServices, TaskAssigningConfig config) {
        this.clientServices = clientServices;
        this.config = config;
    }

    public void start(List<PlanningItem> planningItems, Consumer<PlanningExecutionResult> resultConsumer) {
        this.startCheck();
        this.planningItems = planningItems;
        this.resultConsumer = resultConsumer;
        this.startPermit.release();
    }

    @Override
    public void run() {
        while (this.isAlive()) {
            try {
                this.startPermit.acquire();
                if (!this.isAlive() || !this.status.compareAndSet(RunnableBase.Status.STARTING, RunnableBase.Status.STARTED)) continue;
                LOGGER.debug("Starting planning execution with {} items", (Object)this.planningItems.size());
                PlanningExecutionResult result = this.executePlanning(this.planningItems);
                LOGGER.debug("Planning execution finalized");
                if (!this.isAlive() || !this.status.compareAndSet(RunnableBase.Status.STARTED, RunnableBase.Status.STOPPED)) continue;
                LOGGER.debug("Notify planning execution result consumer");
                this.applyResult(result);
            }
            catch (InterruptedException e) {
                super.destroy();
                Thread.currentThread().interrupt();
            }
        }
        this.closeServiceClients();
    }

    private PlanningExecutionResult executePlanning(List<PlanningItem> planningItems) {
        ArrayList<PlanningExecutionResultItem> resultItems = new ArrayList<PlanningExecutionResultItem>();
        Iterator<PlanningItem> planningItemsIt = planningItems.iterator();
        while (planningItemsIt.hasNext() && this.isAlive()) {
            PlanningItem planningItem = planningItemsIt.next();
            try {
                URL serviceURL = PlanningExecutor.buildServiceURL(planningItem.getTask());
                ProcessServiceClient serviceClient = this.serviceClientMap.computeIfAbsent(serviceURL.toString(), url -> this.createProcessServiceClient(this.clientServices, this.config, serviceURL));
                serviceClient.transitionTask(planningItem.getTask().getProcessId(), planningItem.getTask().getProcessInstanceId(), planningItem.getTask().getName(), planningItem.getTask().getId(), CLAIM_PHASE, planningItem.getTargetUser(), new ArrayList(planningItem.getTask().getPotentialGroups()));
                resultItems.add(new PlanningExecutionResultItem(planningItem));
            }
            catch (Exception e) {
                LOGGER.debug("Error during the assignment of taskId: {}, processInstanceId: {}, processId: {}, to user: {}", new Object[]{planningItem.getTask().getId(), planningItem.getTask().getProcessInstanceId(), planningItem.getTask().getProcessId(), planningItem.getTargetUser()});
                resultItems.add(new PlanningExecutionResultItem(planningItem, e));
            }
        }
        return new PlanningExecutionResult(resultItems);
    }

    ProcessServiceClient createProcessServiceClient(ClientServices clientServices, TaskAssigningConfig config, URL serviceUrl) {
        return TaskAssigningConfigUtil.createProcessServiceClient(clientServices, config, serviceUrl);
    }

    void applyResult(PlanningExecutionResult result) {
        this.resultConsumer.accept(result);
    }

    private void closeServiceClients() {
        this.serviceClientMap.values().forEach(serviceClient -> {
            try {
                serviceClient.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error while closing process service client: {}", (Object)e.getMessage());
            }
        });
    }

    private static URL buildServiceURL(Task task) throws MalformedURLException {
        int serviceUrlIndex = task.getEndpoint().indexOf(task.getProcessId() + "/" + task.getProcessInstanceId());
        return new URL(task.getEndpoint().substring(0, serviceUrlIndex - 1));
    }
}

