/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.taskassigning.core.model.ChainElement;
import org.kie.kogito.taskassigning.core.model.IdentifiableElement;
import org.kie.kogito.taskassigning.core.model.ModelConstants;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TaskState;
import org.kie.kogito.taskassigning.service.processing.AttributesProcessorRegistry;
import org.kie.kogito.taskassigning.service.util.IndexedElement;
import org.kie.kogito.taskassigning.service.util.TaskUtil;
import org.kie.kogito.taskassigning.service.util.UserUtil;

public class SolutionBuilder {
    private List<TaskData> taskDataList;
    private List<org.kie.kogito.taskassigning.user.service.User> externalUsers;
    private AttributesProcessorRegistry processorRegistry;

    private SolutionBuilder() {
    }

    public static SolutionBuilder newBuilder() {
        return new SolutionBuilder();
    }

    public SolutionBuilder withTasks(List<TaskData> taskDataList) {
        this.taskDataList = taskDataList;
        return this;
    }

    public SolutionBuilder withUsers(List<org.kie.kogito.taskassigning.user.service.User> externalUsers) {
        this.externalUsers = externalUsers;
        return this;
    }

    public SolutionBuilder withProcessors(AttributesProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
        return this;
    }

    public TaskAssigningSolution build() {
        ArrayList<TaskAssignment> taskAssignments = new ArrayList<TaskAssignment>();
        HashMap<String, List> assignmentsByUserId = new HashMap<String, List>();
        Map usersById = UserUtil.filterDuplicates(this.externalUsers).filter(externalUser -> !ModelConstants.IS_PLANNING_USER.test(externalUser.getId())).map(externalUser -> UserUtil.fromExternalUser(externalUser, this.processorRegistry)).collect(Collectors.toMap(IdentifiableElement::getId, Function.identity()));
        usersById.put(ModelConstants.PLANNING_USER.getId(), ModelConstants.PLANNING_USER);
        this.taskDataList.forEach(taskData -> {
            Task task = TaskUtil.fromTaskData(taskData);
            this.processorRegistry.applyAttributesProcessor(task, (Map<String, Object>)task.getAttributes());
            TaskAssignment taskAssignment = new TaskAssignment(task);
            String state = task.getState();
            taskAssignments.add(taskAssignment);
            if (TaskState.RESERVED.value().equals(state)) {
                SolutionBuilder.addTaskAssignmentToUser(assignmentsByUserId, taskAssignment, taskData.getActualOwner(), -1, true);
            }
        });
        assignmentsByUserId.forEach((key, assignedTasks) -> {
            User user = (User)usersById.get(key);
            if (user == null) {
                user = new User(key);
                usersById.put((String)key, user);
            }
            List<TaskAssignment> userTasks = assignedTasks.stream().map(IndexedElement::getElement).collect(Collectors.toList());
            SolutionBuilder.addAssignmentsToUser(user, userTasks);
        });
        taskAssignments.add(ModelConstants.DUMMY_TASK_ASSIGNMENT);
        taskAssignments.add(ModelConstants.DUMMY_TASK_ASSIGNMENT_PLANNER_1738);
        ArrayList users = new ArrayList(usersById.values());
        return new TaskAssigningSolution("-1", users, taskAssignments);
    }

    private static void addAssignmentsToUser(User user, List<TaskAssignment> taskAssignments) {
        User previousElement = user;
        int previousEndTimeInMinutes = 0;
        Iterator<TaskAssignment> iterator = taskAssignments.iterator();
        while (iterator.hasNext()) {
            TaskAssignment taskAssignment;
            TaskAssignment nextElement = taskAssignment = iterator.next();
            previousElement.setNextElement(nextElement);
            nextElement.setStartTimeInMinutes(Integer.valueOf(previousEndTimeInMinutes));
            nextElement.setEndTimeInMinutes(Integer.valueOf(nextElement.getStartTimeInMinutes() + nextElement.getDurationInMinutes()));
            nextElement.setPreviousElement((ChainElement)previousElement);
            nextElement.setUser(user);
            previousEndTimeInMinutes = nextElement.getEndTimeInMinutes();
            previousElement = nextElement;
        }
    }

    private static void addTaskAssignmentToUser(Map<String, List<IndexedElement<TaskAssignment>>> assignmentsByUserId, TaskAssignment taskAssignment, String actualOwner, int index, boolean pinned) {
        taskAssignment.setPinned(pinned);
        List userAssignments = assignmentsByUserId.computeIfAbsent(actualOwner, key -> new ArrayList());
        IndexedElement.addInOrder(userAssignments, new IndexedElement<TaskAssignment>(taskAssignment, index, taskAssignment.isPinned()));
    }
}

