/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.Startup;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.kie.kogito.taskassigning.ClientServices;
import org.kie.kogito.taskassigning.config.OidcClientLookup;
import org.kie.kogito.taskassigning.core.model.IdentifiableElement;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.core.model.solver.TaskHelper;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AssignTaskProblemFactChange;
import org.kie.kogito.taskassigning.service.PlanningBuilder;
import org.kie.kogito.taskassigning.service.PlanningExecutionResult;
import org.kie.kogito.taskassigning.service.PlanningExecutionResultItem;
import org.kie.kogito.taskassigning.service.PlanningExecutor;
import org.kie.kogito.taskassigning.service.PlanningItem;
import org.kie.kogito.taskassigning.service.ServiceMessage;
import org.kie.kogito.taskassigning.service.ServiceStatus;
import org.kie.kogito.taskassigning.service.SolutionBuilder;
import org.kie.kogito.taskassigning.service.SolutionChangesBuilder;
import org.kie.kogito.taskassigning.service.SolutionDataLoader;
import org.kie.kogito.taskassigning.service.SolverExecutor;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceContext;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TaskState;
import org.kie.kogito.taskassigning.service.UserServiceAdapter;
import org.kie.kogito.taskassigning.service.UserServiceConnectorDelegate;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfigValidator;
import org.kie.kogito.taskassigning.service.event.BufferedTaskAssigningServiceEventConsumer;
import org.kie.kogito.taskassigning.service.event.DataEvent;
import org.kie.kogito.taskassigning.service.event.SolutionUpdatedOnBackgroundDataEvent;
import org.kie.kogito.taskassigning.service.event.TaskDataEvent;
import org.kie.kogito.taskassigning.service.event.UserDataEvent;
import org.kie.kogito.taskassigning.service.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.taskassigning.service.processing.AttributesProcessorRegistry;
import org.kie.kogito.taskassigning.service.util.EventUtil;
import org.kie.kogito.taskassigning.service.util.TaskUtil;
import org.kie.kogito.taskassigning.service.util.TraceUtil;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Startup
public class TaskAssigningService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAssigningService.class);
    private static final Predicate<TaskDataEvent> IS_ACTIVE_TASK_EVENT = taskDataEvent -> !TaskState.isTerminal(((TaskData)taskDataEvent.getData()).getState());
    private static final String SERVICE_INOPERATIVE_MESSAGE = "Service has become inoperative or is executing the shutdown procedure, service status: {}";
    @Inject
    SolverFactory<TaskAssigningSolution> solverFactory;
    @Inject
    TaskAssigningConfig config;
    @Inject
    ManagedExecutor managedExecutor;
    @Inject
    BufferedTaskAssigningServiceEventConsumer serviceEventConsumer;
    @Inject
    ReactiveMessagingEventConsumer serviceMessageConsumer;
    @Inject
    ClientServices clientServices;
    @Inject
    UserServiceConnector userServiceConnector;
    @Inject
    UserServiceConnectorDelegate userServiceConnectorDelegate;
    @Inject
    UserServiceAdapter userServiceAdapter;
    @Inject
    SolutionDataLoader solutionDataLoader;
    @Inject
    AttributesProcessorRegistry processorRegistry;
    @Inject
    Vertx vertx;
    @Inject
    Event<TimerBasedEvent> timerBasedEvent;
    @Inject
    OidcClientLookup oidcClientLookup;
    private SolverExecutor solverExecutor;
    private PlanningExecutor planningExecutor;
    private TaskAssigningServiceContext context;
    private final AtomicReference<TaskAssigningSolution> currentSolution = new AtomicReference<Object>(null);
    private final AtomicReference<TaskAssigningSolution> lastBestSolution = new AtomicReference<Object>(null);
    private final AtomicBoolean applyingPlanningExecutionResult = new AtomicBoolean();
    private final AtomicBoolean startingFromEvents = new AtomicBoolean();
    private List<TaskDataEvent> startingEvents;
    private final AtomicLong waitForImprovedSolutionTimer = new AtomicLong(-1L);
    private final AtomicLong improveSolutionOnBackgroundTimer = new AtomicLong(-1L);

    @PostConstruct
    void start() {
        this.startUpValidation();
        this.context = this.createContext();
        this.serviceEventConsumer.setConsumer(this::onDataEvents);
        this.solverExecutor = this.createSolverExecutor(this.solverFactory, (SolverEventListener<TaskAssigningSolution>)((SolverEventListener)this::onBestSolutionChange));
        this.managedExecutor.execute((Runnable)this.solverExecutor);
        this.planningExecutor = this.createPlanningExecutor(this.clientServices, this.config);
        this.managedExecutor.execute((Runnable)this.planningExecutor);
        this.loadSolutionData(true, true, this.config.getDataLoaderPageSize());
    }

    synchronized void onSolutionDataLoad(SolutionDataLoader.Result result) {
        try {
            TaskAssigningSolution solution;
            LOGGER.debug("Solution data loading has finished, startingFromEvents: {}, includeTasks: {}, includeUsers: {}, tasks: {}, users: {}", new Object[]{this.startingFromEvents, !this.startingFromEvents.get(), true, result.getTasks().size(), result.getUsers().size()});
            this.context.setStatus(ServiceStatus.READY);
            if (this.startingFromEvents.get()) {
                if (this.hasQueuedEvents()) {
                    List<TaskDataEvent> newEvents = EventUtil.filterNewestTaskEventsInContext(this.context, this.pollEvents());
                    this.startingEvents = this.combineAndFilerNewestActiveTaskEvents(this.startingEvents, newEvents);
                }
                solution = SolutionBuilder.newBuilder().withTasks(TaskUtil.fromTaskDataEvents(this.startingEvents)).withUsers(result.getUsers()).withProcessors(this.processorRegistry).build();
                this.startingFromEvents.set(false);
                this.startingEvents = null;
            } else {
                solution = SolutionBuilder.newBuilder().withTasks(result.getTasks()).withUsers(result.getUsers()).withProcessors(this.processorRegistry).build();
            }
            List taskAssignments = TaskHelper.filterNonDummyAssignments((List)solution.getTaskAssignmentList());
            if (!taskAssignments.isEmpty()) {
                taskAssignments.forEach(taskAssignment -> {
                    this.context.setTaskPublished(taskAssignment.getId(), taskAssignment.isPinned());
                    this.context.setTaskLastEventTime(taskAssignment.getId(), taskAssignment.getTask().getLastUpdate());
                });
                this.solverExecutor.start(solution);
                this.userServiceAdapter.start();
            } else {
                this.resumeEvents();
            }
        }
        catch (Exception e) {
            this.failFast(e);
        }
    }

    private void onSolutionDataLoadFailure(Throwable throwable) {
        this.failFast(throwable);
    }

    private List<TaskDataEvent> combineAndFilerNewestActiveTaskEvents(List<TaskDataEvent> previousStartingEvents, List<TaskDataEvent> newEvents) {
        ArrayList<TaskDataEvent> combinedEvents = new ArrayList<TaskDataEvent>(previousStartingEvents);
        combinedEvents.addAll(newEvents);
        return EventUtil.filterNewestTaskEvents(combinedEvents).stream().filter(IS_ACTIVE_TASK_EVENT).collect(Collectors.toList());
    }

    private synchronized void onDataEvents(List<DataEvent<?>> events) {
        this.pauseEvents();
        this.managedExecutor.runAsync(() -> this.processDataEvents(events));
    }

    synchronized void processDataEvents(List<DataEvent<?>> events) {
        if (this.isNotOperative()) {
            LOGGER.warn(SERVICE_INOPERATIVE_MESSAGE, (Object)this.context.getStatus());
            return;
        }
        try {
            List<TaskDataEvent> newTaskDataEvents = EventUtil.filterNewestTaskEventsInContext(this.context, events);
            if (this.currentSolution.get() == null) {
                List activeTaskEvents = newTaskDataEvents.stream().filter(IS_ACTIVE_TASK_EVENT).collect(Collectors.toList());
                if (!activeTaskEvents.isEmpty()) {
                    this.startingEvents = activeTaskEvents;
                    this.startingFromEvents.set(true);
                    this.loadSolutionData(false, true, this.config.getDataLoaderPageSize());
                } else {
                    this.resumeEvents();
                }
            } else {
                UserDataEvent userDataEvent = EventUtil.filterNewestUserEvent(events);
                List<ProblemFactChange<TaskAssigningSolution>> changes = SolutionChangesBuilder.create().forSolution(this.currentSolution.get()).withContext(this.context).withUserServiceConnector(this.userServiceConnectorDelegate).withProcessors(this.processorRegistry).fromTasksData(TaskUtil.fromTaskDataEvents(newTaskDataEvents)).fromUserDataEvent(userDataEvent).build();
                if (!changes.isEmpty()) {
                    LOGGER.debug("processDataEvents - there are changes: {} to apply", (Object)changes.size());
                    this.cancelScheduledImproveSolutionOnBackgroundTimer();
                    this.solverExecutor.addProblemFactChanges(changes);
                } else {
                    SolutionUpdatedOnBackgroundDataEvent solutionImprovedOnBackgroundEvent = EventUtil.filterNewestSolutionUpdatedOnBackgroundEvent(events);
                    TaskAssigningSolution currentLastBestSolution = this.lastBestSolution.get();
                    if (solutionImprovedOnBackgroundEvent != null && this.hasToApplyImprovedOnBackgroundSolution(solutionImprovedOnBackgroundEvent, currentLastBestSolution)) {
                        LOGGER.debug("processDataEvents - apply the improved on background solution: {}", (Object)currentLastBestSolution);
                        this.executeSolutionChange(currentLastBestSolution);
                    } else {
                        this.executePlanOrResumeEvents(this.currentSolution.get());
                    }
                }
            }
        }
        catch (Exception e) {
            this.failFast(e);
        }
    }

    private boolean hasToApplyImprovedOnBackgroundSolution(SolutionUpdatedOnBackgroundDataEvent dataEvent, TaskAssigningSolution currentLastBestSolution) {
        if (this.isScheduledImproveSolutionOnBackgroundTimerEqualsTo((Long)dataEvent.getData())) {
            boolean wasImproved;
            boolean bl = wasImproved = currentLastBestSolution.getScore().compareTo(this.currentSolution.get().getScore()) > 0;
            if (wasImproved) {
                LOGGER.debug("ON_BACKGROUND SCORE IMPROVEMENT: lastBestSolution calculated on background has a better score than the currentSolution, currentSolution.score: {}, lastBestSolution.score: {}", (Object)this.currentSolution.get().getScore(), (Object)currentLastBestSolution.getScore());
            } else {
                LOGGER.debug("ON_BACKGROUND SAME SCORE: lastBestSolution calculated on background is the same as the currentSolution or has the same score");
            }
            return wasImproved;
        }
        return false;
    }

    void onBestSolutionChange(BestSolutionChangedEvent<TaskAssigningSolution> event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onBestSolutionChange: isEveryProblemFactChangeProcessed: {}, currentChangeSetId: {}, isCurrentChangeSetProcessed: {}, newBestSolution: {}", new Object[]{event.isEveryProblemFactChangeProcessed(), this.context.getCurrentChangeSetId(), this.context.isCurrentChangeSetProcessed(), event.getNewBestSolution()});
        }
        TaskAssigningSolution newBestSolution = (TaskAssigningSolution)event.getNewBestSolution();
        if (event.isEveryProblemFactChangeProcessed() && newBestSolution.getScore().isSolutionInitialized()) {
            this.lastBestSolution.set(newBestSolution);
            if (!this.applyingPlanningExecutionResult.get() && this.hasWaitForImprovedSolutionDuration()) {
                this.scheduleOnBestSolutionChange(newBestSolution, this.config.getWaitForImprovedSolutionDuration());
            } else {
                this.onBestSolutionChange(newBestSolution);
            }
        }
    }

    private void onBestSolutionChange(TaskAssigningSolution newBestSolution) {
        if (!this.context.isCurrentChangeSetProcessed()) {
            this.context.setProcessedChangeSet(this.context.getCurrentChangeSetId());
            this.managedExecutor.runAsync(() -> this.executeSolutionChange(newBestSolution));
        }
    }

    private void scheduleOnBestSolutionChange(TaskAssigningSolution chBestSolution, Duration duration) {
        if (!this.isWaitForImprovedSolutionTimerScheduled() && !this.context.isCurrentChangeSetProcessed()) {
            LOGGER.debug("Schedule execute solution change with waiting duration: {}", (Object)duration);
            this.scheduleWaitForImprovedSolutionTimer(duration, chBestSolution);
        }
    }

    private void executeSolutionChange(TaskAssigningSolution chBestSolution, Supplier<TaskAssigningSolution> solutionSupplier) {
        TaskAssigningSolution currentLastBestSolution = solutionSupplier.get();
        LOGGER.debug("Executing delayed solution change for currentChangeSetId: {}, the first CH generated solution after the changes is chBestSolution: {}, lastBestSolution: {}", new Object[]{this.context.getCurrentChangeSetId(), chBestSolution, currentLastBestSolution});
        if (chBestSolution == currentLastBestSolution) {
            LOGGER.debug("SAME SOLUTION: lastBestSolution is the same as the chBestSolution");
        } else if (chBestSolution.getScore().compareTo(currentLastBestSolution.getScore()) < 0) {
            LOGGER.debug("SCORE IMPROVEMENT: lastBestSolution has a better score than the chBestSolution: currentChangeSetId: {}, chBestSolution.score: {}, lastBestSolution.score: {}", new Object[]{this.context.getCurrentChangeSetId(), chBestSolution.getScore(), currentLastBestSolution.getScore()});
        } else {
            LOGGER.debug("SAME SCORE: lastBestSolution is not the same as the chBestSolution BUT the score has not improved, currentChangeSetId: {}, chBestSolution.score: {}, lastBestSolution.score: {}", new Object[]{this.context.getCurrentChangeSetId(), chBestSolution.getScore(), currentLastBestSolution.getScore()});
        }
        this.context.setProcessedChangeSet(this.context.getCurrentChangeSetId());
        this.managedExecutor.runAsync(() -> this.executeSolutionChange(currentLastBestSolution));
    }

    synchronized void executeSolutionChange(TaskAssigningSolution solution) {
        if (this.isNotOperative()) {
            LOGGER.warn(SERVICE_INOPERATIVE_MESSAGE, (Object)this.context.getStatus());
            return;
        }
        try {
            LOGGER.debug("process the next generated solution, applyingPlanningExecutionResult: {}", (Object)this.applyingPlanningExecutionResult.get());
            if (LOGGER.isTraceEnabled()) {
                TraceUtil.traceSolution(LOGGER, solution);
            }
            this.clearWaitForImprovedSolutionTimer();
            this.currentSolution.set(solution);
            List<ProblemFactChange<TaskAssigningSolution>> pendingEventsChanges = null;
            if (this.applyingPlanningExecutionResult.get()) {
                this.applyingPlanningExecutionResult.set(false);
                List<DataEvent<?>> pendingEvents = this.pollEvents();
                List<TaskDataEvent> pendingTaskDataEvents = EventUtil.filterNewestTaskEventsInContext(this.context, pendingEvents);
                UserDataEvent pendingUserDataEvent = EventUtil.filterNewestUserEvent(pendingEvents);
                if (!pendingTaskDataEvents.isEmpty() || pendingUserDataEvent != null) {
                    pendingEventsChanges = SolutionChangesBuilder.create().forSolution(solution).withContext(this.context).withUserServiceConnector(this.userServiceConnectorDelegate).withProcessors(this.processorRegistry).fromTasksData(TaskUtil.fromTaskDataEvents(pendingTaskDataEvents)).fromUserDataEvent(pendingUserDataEvent).build();
                }
            }
            if (pendingEventsChanges != null && !pendingEventsChanges.isEmpty()) {
                LOGGER.debug("executeSolutionChange - we have pendingEventsChanges: {} to apply", (Object)pendingEventsChanges.size());
                this.cancelScheduledImproveSolutionOnBackgroundTimer();
                this.solverExecutor.addProblemFactChanges(pendingEventsChanges);
            } else {
                this.executePlanOrResumeEvents(solution);
            }
        }
        catch (Exception e) {
            this.failFast(e);
        }
    }

    void onSolutionImprovedEvent(@Observes SolutionImprovedEvent event) {
        LOGGER.debug("onSolutionImprovedEvent: timerId: {}", (Object)event.getTimerId());
        this.executeSolutionChange(event.getChBestSolution(), this.lastBestSolution::get);
    }

    void onSolutionImprovedOnBackgroundEvent(@Observes SolutionImprovedOnBackgroundEvent event) {
        LOGGER.debug("onSolutionImprovedOnBackgroundEvent: timerId: {}", (Object)event.getTimerId());
        this.serviceEventConsumer.accept(new SolutionUpdatedOnBackgroundDataEvent(event.getTimerId(), ZonedDateTime.now()));
    }

    private void executePlanOrResumeEvents(TaskAssigningSolution solution) {
        List<PlanningItem> planningItems = PlanningBuilder.create().forSolution(solution).withContext(this.context).withPublishWindowSize(this.config.getPublishWindowSize()).build();
        if (LOGGER.isTraceEnabled()) {
            TraceUtil.tracePlanning(LOGGER, planningItems);
        }
        if (!planningItems.isEmpty()) {
            this.cancelScheduledImproveSolutionOnBackgroundTimer();
            this.planningExecutor.start(planningItems, this::onPlanningExecuted);
        } else {
            if (this.hasImproveSolutionOnBackgroundDuration() && !this.isImproveSolutionOnBackgroundTimerScheduled()) {
                this.scheduleImproveSolutionOnBackgroundTimer(this.config.getImproveSolutionOnBackgroundDuration());
            }
            this.resumeEvents();
        }
    }

    synchronized void onPlanningExecuted(PlanningExecutionResult result) {
        if (this.isNotOperative()) {
            LOGGER.warn(SERVICE_INOPERATIVE_MESSAGE, (Object)this.context.getStatus());
            return;
        }
        try {
            LOGGER.debug("Planning was executed");
            this.applyingPlanningExecutionResult.set(false);
            TaskAssigningSolution solution = this.currentSolution.get();
            Map usersById = solution.getUserList().stream().collect(Collectors.toMap(IdentifiableElement::getId, Function.identity()));
            ArrayList<ProblemFactChange<TaskAssigningSolution>> pinningChanges = new ArrayList<ProblemFactChange<TaskAssigningSolution>>();
            for (PlanningExecutionResultItem resultItem : result.getItems()) {
                boolean published;
                Task task = resultItem.getItem().getTask();
                boolean bl = published = !resultItem.hasError();
                if (published) {
                    User user = (User)usersById.get(resultItem.getItem().getTargetUser());
                    pinningChanges.add((ProblemFactChange<TaskAssigningSolution>)new AssignTaskProblemFactChange(new TaskAssignment(task), user));
                }
                this.context.setTaskPublished(task.getId(), published);
            }
            if (!pinningChanges.isEmpty()) {
                LOGGER.debug("Pinning changes must be executed for the successful invocations: {}", (Object)pinningChanges.size());
                pinningChanges.add(0, scoreDirector -> this.context.setCurrentChangeSetId(this.context.nextChangeSetId()));
                this.applyingPlanningExecutionResult.set(true);
                this.cancelScheduledImproveSolutionOnBackgroundTimer();
                this.solverExecutor.addProblemFactChanges(pinningChanges);
            } else if (!this.hasQueuedEvents()) {
                List<PlanningItem> failingItems = result.getItems().stream().filter(PlanningExecutionResultItem::hasError).map(PlanningExecutionResultItem::getItem).collect(Collectors.toList());
                LOGGER.debug("No new events to process, but some items failed: {}, we must retry", (Object)failingItems.size());
                this.cancelScheduledImproveSolutionOnBackgroundTimer();
                this.planningExecutor.start(failingItems, this::onPlanningExecuted);
            } else {
                LOGGER.debug("Some items failed but there are events to process, try to adjust the solution accordingly.");
                this.resumeEvents();
            }
        }
        catch (Exception e) {
            this.failFast(e);
        }
    }

    void onShutDownEvent(@Observes ShutdownEvent ev) {
        this.destroy();
    }

    void destroy() {
        try {
            this.context.setStatus(ServiceStatus.SHUTDOWN);
            LOGGER.info("Service is going down and will be destroyed.");
            this.destroyExecutableObjects();
            LOGGER.info("Service destroy sequence was executed successfully.");
        }
        catch (Exception e) {
            LOGGER.error("An error was produced during service destroy, but it'll go down anyway.", (Throwable)e);
        }
    }

    private void destroyExecutableObjects() {
        this.userServiceAdapter.destroy();
        this.solverExecutor.destroy();
        this.planningExecutor.destroy();
        this.cancelScheduledWaitForImprovedSolutionTimer();
        this.cancelScheduledImproveSolutionOnBackgroundTimer();
    }

    private void loadSolutionData(boolean includeTasks, boolean includeUsers, int pageSize) {
        this.solutionDataLoader.loadSolutionData(includeTasks, includeUsers, pageSize).thenAccept(this::onSolutionDataLoad).exceptionally(throwable -> {
            this.onSolutionDataLoadFailure((Throwable)throwable);
            return null;
        });
    }

    void failFast(Throwable cause) {
        String msg = String.format("An unrecoverable error was produced: %s", cause.getMessage());
        LOGGER.error(msg, cause);
        this.context.setStatus(ServiceStatus.ERROR, ServiceMessage.error(msg));
        this.destroyExecutableObjects();
        this.serviceMessageConsumer.failFast();
    }

    private boolean isNotOperative() {
        return this.context.getStatus() == ServiceStatus.ERROR || this.context.getStatus() == ServiceStatus.SHUTDOWN;
    }

    private void startUpValidation() {
        this.validateConfig();
        this.validateOidcClient();
        this.validateUserService();
        this.validateSolver();
    }

    private void validateConfig() {
        TaskAssigningConfigValidator.of(this.config).validate();
    }

    private void validateUserService() {
        this.userServiceConnector.start();
    }

    private void validateSolver() {
        this.solverFactory.buildSolver();
    }

    private void validateOidcClient() {
        OidcClient oidcClient;
        Optional<String> oidcClientId = this.config.getOidcClient();
        if (oidcClientId.isPresent() && (oidcClient = this.oidcClientLookup.lookup(oidcClientId.get())) == null) {
            throw new IllegalArgumentException("No OidcClient was found for the configured property value kogito.task-assigning.oidc-client = " + oidcClientId.get());
        }
    }

    private void pauseEvents() {
        this.serviceEventConsumer.pause();
    }

    private void resumeEvents() {
        this.serviceEventConsumer.resume();
    }

    private List<DataEvent<?>> pollEvents() {
        return this.serviceEventConsumer.pollEvents();
    }

    private boolean hasQueuedEvents() {
        return this.serviceEventConsumer.queuedEvents() > 0;
    }

    public TaskAssigningServiceContext getContext() {
        return this.context;
    }

    TaskAssigningServiceContext createContext() {
        return new TaskAssigningServiceContext();
    }

    SolverExecutor createSolverExecutor(SolverFactory<TaskAssigningSolution> solverFactory, SolverEventListener<TaskAssigningSolution> eventListener) {
        return new SolverExecutor(solverFactory, eventListener);
    }

    PlanningExecutor createPlanningExecutor(ClientServices clientServices, TaskAssigningConfig config) {
        return new PlanningExecutor(clientServices, config);
    }

    private boolean isWaitForImprovedSolutionTimerScheduled() {
        return this.waitForImprovedSolutionTimer.get() >= 0L;
    }

    private void clearWaitForImprovedSolutionTimer() {
        this.waitForImprovedSolutionTimer.set(-1L);
    }

    private void cancelScheduledWaitForImprovedSolutionTimer() {
        long currentTimerId = this.waitForImprovedSolutionTimer.getAndSet(-1L);
        LOGGER.debug("cancelling waitForImprovedSolutionTimer: {}", (Object)currentTimerId);
        this.cancelIfSet(currentTimerId);
    }

    private void scheduleWaitForImprovedSolutionTimer(Duration duration, TaskAssigningSolution chBestSolution) {
        LOGGER.debug("scheduleWaitForImprovedSolutionTimer with duration: {}", (Object)duration);
        long createdTimerId = this.vertx.setTimer(duration.toMillis(), timerId -> this.timerBasedEvent.fire((Object)new SolutionImprovedEvent((long)timerId, chBestSolution)));
        this.waitForImprovedSolutionTimer.set(createdTimerId);
    }

    private boolean isImproveSolutionOnBackgroundTimerScheduled() {
        return this.improveSolutionOnBackgroundTimer.get() >= 0L;
    }

    private boolean isScheduledImproveSolutionOnBackgroundTimerEqualsTo(long timerId) {
        return this.improveSolutionOnBackgroundTimer.get() == timerId;
    }

    private void scheduleImproveSolutionOnBackgroundTimer(Duration duration) {
        LOGGER.debug("scheduleImproveSolutionOnBackgroundTimer with duration: {}", (Object)duration);
        long createdTimerId = this.vertx.setTimer(duration.toMillis(), timerId -> this.timerBasedEvent.fire((Object)new SolutionImprovedOnBackgroundEvent((long)timerId)));
        this.improveSolutionOnBackgroundTimer.set(createdTimerId);
    }

    private void cancelScheduledImproveSolutionOnBackgroundTimer() {
        long currentTimerId = this.improveSolutionOnBackgroundTimer.getAndSet(-1L);
        LOGGER.debug("cancelling improveSolutionOnBackgroundTimer: {}", (Object)currentTimerId);
        this.cancelIfSet(currentTimerId);
    }

    private void cancelIfSet(long timerId) {
        if (timerId >= 0L) {
            this.vertx.cancelTimer(timerId);
        }
    }

    private boolean hasWaitForImprovedSolutionDuration() {
        return !this.config.getWaitForImprovedSolutionDuration().isZero();
    }

    private boolean hasImproveSolutionOnBackgroundDuration() {
        return !this.config.getImproveSolutionOnBackgroundDuration().isZero();
    }

    static class SolutionImprovedOnBackgroundEvent
    extends TimerBasedEvent {
        public SolutionImprovedOnBackgroundEvent(long timerId) {
            super(timerId);
        }
    }

    static class SolutionImprovedEvent
    extends TimerBasedEvent {
        TaskAssigningSolution chBestSolution;

        public SolutionImprovedEvent(long timerId, TaskAssigningSolution chBestSolution) {
            super(timerId);
            this.chBestSolution = chBestSolution;
        }

        public TaskAssigningSolution getChBestSolution() {
            return this.chBestSolution;
        }
    }

    static class TimerBasedEvent {
        protected long timerId;

        public TimerBasedEvent(long timerId) {
            this.timerId = timerId;
        }

        public long getTimerId() {
            return this.timerId;
        }
    }
}

