/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.kie.kogito.taskassigning.service.TaskAssigningException;
import org.kie.kogito.taskassigning.service.TaskAssigningService;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.service.event.TaskAssigningServiceEventConsumer;
import org.kie.kogito.taskassigning.service.event.UserDataEvent;
import org.kie.kogito.taskassigning.user.service.User;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UserServiceAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceAdapter.class);
    private final TaskAssigningService service;
    private final TaskAssigningConfig config;
    private final TaskAssigningServiceEventConsumer taskAssigningServiceEventConsumer;
    private final ManagedExecutor managedExecutor;
    private final UserServiceConnector userServiceConnector;
    private final Event<StartExecution> startExecutionEvent;
    private final AtomicBoolean destroyed = new AtomicBoolean();

    @Inject
    public UserServiceAdapter(TaskAssigningService service, TaskAssigningConfig config, TaskAssigningServiceEventConsumer taskAssigningServiceEventConsumer, ManagedExecutor managedExecutor, UserServiceConnector userServiceConnector, Event<StartExecution> startExecutionEvent) {
        this.service = service;
        this.config = config;
        this.taskAssigningServiceEventConsumer = taskAssigningServiceEventConsumer;
        this.managedExecutor = managedExecutor;
        this.userServiceConnector = userServiceConnector;
        this.startExecutionEvent = startExecutionEvent;
    }

    public void start() {
        if (this.syncIsEnabled()) {
            this.programNextExecution(this.config.getUserServiceSyncInterval());
        } else {
            LOGGER.warn("A zero duration was configured for the property kogito.task-assigning.user-service-sync-interval: {}, users information synchronization will be disabled.", (Object)this.config.getUserServiceSyncInterval());
        }
    }

    public void destroy() {
        this.destroyed.set(true);
    }

    private void programNextExecution(Duration nextStartTime) {
        if (!this.destroyed.get()) {
            this.scheduleExecution(nextStartTime, () -> this.startExecutionEvent.fire((Object)new StartExecution()));
        }
    }

    void scheduleExecution(Duration nextStartTime, Runnable command) {
        CompletableFuture.delayedExecutor(nextStartTime.toMillis(), TimeUnit.MILLISECONDS, (Executor)this.managedExecutor).execute(command);
    }

    void executeQuery(@Observes StartExecution evt) {
        if (!this.destroyed.get()) {
            this.loadUsersData().thenAccept(this::onQuerySuccessful).exceptionally(throwable -> {
                this.onQueryFailure((Throwable)throwable);
                return null;
            });
        }
    }

    private void onQuerySuccessful(List<User> users) {
        if (!this.destroyed.get()) {
            this.taskAssigningServiceEventConsumer.accept(new UserDataEvent(users, ZonedDateTime.now()));
            this.programNextExecution(this.config.getUserServiceSyncInterval());
        }
    }

    private void onQueryFailure(Throwable throwable) {
        this.service.failFast(throwable);
    }

    private boolean syncIsEnabled() {
        return !this.config.getUserServiceSyncInterval().isZero();
    }

    @Asynchronous
    @Retry(maxRetries=-1, delay=2000L, maxDuration=5L, durationUnit=ChronoUnit.MINUTES)
    @Timeout(value=10L, unit=ChronoUnit.MINUTES)
    public CompletionStage<List<User>> loadUsersData() {
        CompletableFuture<List<User>> future = new CompletableFuture<List<User>>();
        try {
            future.complete(this.userServiceConnector.findAllUsers());
        }
        catch (Exception e) {
            String msg = String.format("An error was produced during users information synchronization, error: %s", e.getMessage());
            LOGGER.warn(msg);
            future.completeExceptionally(new TaskAssigningException(msg, e));
        }
        return future;
    }

    static class StartExecution {
        StartExecution() {
        }
    }
}

