/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.config;

import java.net.URL;
import org.kie.kogito.taskassigning.ClientServices;
import org.kie.kogito.taskassigning.auth.AuthenticationCredentials;
import org.kie.kogito.taskassigning.auth.BasicAuthenticationCredentials;
import org.kie.kogito.taskassigning.auth.NoAuthenticationCredentials;
import org.kie.kogito.taskassigning.auth.OidcClientAuthenticationCredentials;
import org.kie.kogito.taskassigning.index.service.client.DataIndexServiceClient;
import org.kie.kogito.taskassigning.index.service.client.DataIndexServiceClientConfig;
import org.kie.kogito.taskassigning.process.service.client.ProcessServiceClient;
import org.kie.kogito.taskassigning.process.service.client.ProcessServiceClientConfig;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfigValidator;

public class TaskAssigningConfigUtil {
    private TaskAssigningConfigUtil() {
    }

    public static DataIndexServiceClient createDataIndexServiceClient(ClientServices clientServices, TaskAssigningConfig config) {
        TaskAssigningConfigValidator.of(config).validate();
        DataIndexServiceClientConfig clientServiceConfig = (DataIndexServiceClientConfig)DataIndexServiceClientConfig.newBuilder().serviceUrl(config.getDataIndexServerUrl().toString()).connectTimeoutMillis(config.getDataIndexConnectTimeoutDuration().toMillis()).readTimeoutMillis(config.getDataIndexReadTimeoutDuration().toMillis()).build();
        AuthenticationCredentials credentials = TaskAssigningConfigUtil.buildAuthenticationCredentials(config);
        return clientServices.dataIndexClientFactory().newClient(clientServiceConfig, credentials);
    }

    public static ProcessServiceClient createProcessServiceClient(ClientServices clientServices, TaskAssigningConfig config, URL serviceUrl) {
        TaskAssigningConfigValidator.of(config).validate();
        ProcessServiceClientConfig clientServiceConfig = (ProcessServiceClientConfig)ProcessServiceClientConfig.newBuilder().serviceUrl(serviceUrl.toString()).connectTimeoutMillis(config.getProcessRuntimeConnectTimeoutDuration().toMillis()).readTimeoutMillis(config.getProcessRuntimeReadTimeoutDuration().toMillis()).build();
        AuthenticationCredentials credentials = TaskAssigningConfigUtil.buildAuthenticationCredentials(config);
        return clientServices.processServiceClientFactory().newClient(clientServiceConfig, credentials);
    }

    private static AuthenticationCredentials buildAuthenticationCredentials(TaskAssigningConfig config) {
        NoAuthenticationCredentials credentials;
        if (config.isOidcClientSet()) {
            OidcClientAuthenticationCredentials.Builder builder = OidcClientAuthenticationCredentials.newBuilder();
            config.getOidcClient().ifPresent(arg_0 -> ((OidcClientAuthenticationCredentials.Builder)builder).oidcClient(arg_0));
            credentials = builder.build();
        } else if (config.isBasicAuthSet()) {
            BasicAuthenticationCredentials.Builder builder = BasicAuthenticationCredentials.newBuilder();
            config.getClientAuthUser().ifPresent(arg_0 -> ((BasicAuthenticationCredentials.Builder)builder).user(arg_0));
            config.getClientAuthPassword().ifPresent(arg_0 -> ((BasicAuthenticationCredentials.Builder)builder).password(arg_0));
            credentials = builder.build();
        } else {
            credentials = NoAuthenticationCredentials.INSTANCE;
        }
        return credentials;
    }
}

