/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.messaging;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.taskassigning.service.TaskAssigningException;
import org.kie.kogito.taskassigning.service.event.TaskAssigningServiceEventConsumer;
import org.kie.kogito.taskassigning.service.event.TaskDataEvent;
import org.kie.kogito.taskassigning.service.messaging.UserTaskEvent;
import org.kie.kogito.taskassigning.service.util.TaskUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ReactiveMessagingEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMessagingEventConsumer.class);
    private static final String KOGITO_USERTASKINSTANCES_EVENTS = "kogito-usertaskinstances-events";
    private final TaskAssigningServiceEventConsumer taskAssigningServiceEventConsumer;
    private final ManagedExecutor managedExecutor;
    private final AtomicBoolean failFast = new AtomicBoolean();

    @Inject
    public ReactiveMessagingEventConsumer(TaskAssigningServiceEventConsumer taskAssigningServiceEventConsumer, ManagedExecutor managedExecutor) {
        this.taskAssigningServiceEventConsumer = taskAssigningServiceEventConsumer;
        this.managedExecutor = managedExecutor;
    }

    @Incoming(value="kogito-usertaskinstances-events")
    @Acknowledgment(value=Acknowledgment.Strategy.MANUAL)
    public CompletionStage<Void> onUserTaskEvent(Message<UserTaskEvent> message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("UserTaskEvent received: {}", message.getPayload());
        }
        if (this.failFast.get()) {
            return message.nack((Throwable)new TaskAssigningException("Task assigning service is in fail fast mode and is not able to accept messages"));
        }
        this.managedExecutor.runAsync(() -> this.handleEvent((UserTaskEvent)message.getPayload()));
        return message.ack();
    }

    public void failFast() {
        this.failFast.set(true);
    }

    private void handleEvent(UserTaskEvent event) {
        this.taskAssigningServiceEventConsumer.accept(new TaskDataEvent(TaskUtil.fromUserTaskEvent(event)));
    }
}

