/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.processing;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kie.kogito.taskassigning.core.model.DefaultLabels;
import org.kie.kogito.taskassigning.model.processing.AttributesProcessor;

public abstract class AbstractDefaultAttributesProcessor<T>
implements AttributesProcessor<T> {
    private static final String SEPARATOR = ",";

    public void process(T entity, Map<String, Object> targetAttributes) {
        this.processAffinities(entity, targetAttributes);
        this.processSkills(entity, targetAttributes);
    }

    protected abstract Object getSkillsValue(T var1);

    protected abstract Object getAffinitiesValue(T var1);

    protected void processSkills(T entity, Map<String, Object> targetAttributes) {
        this.putIfNotEmpty(DefaultLabels.SKILLS.name(), AbstractDefaultAttributesProcessor.extractTokenizedValues(this.getSkillsValue(entity), SEPARATOR), targetAttributes);
    }

    protected void processAffinities(T entity, Map<String, Object> targetAttributes) {
        this.putIfNotEmpty(DefaultLabels.AFFINITIES.name(), AbstractDefaultAttributesProcessor.extractTokenizedValues(this.getAffinitiesValue(entity), SEPARATOR), targetAttributes);
    }

    protected void putIfNotEmpty(String attributeName, Set<Object> attributeValue, Map<String, Object> targetAttributes) {
        if (!attributeValue.isEmpty()) {
            targetAttributes.put(attributeName, attributeValue);
        }
    }

    public static Set<Object> extractTokenizedValues(Object attributeValue, String separator) {
        if (attributeValue == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(attributeValue.toString().split(separator)).map(StringUtils::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
    }
}

