/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.util;

import java.util.List;
import java.util.Map;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AddTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AddUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AssignTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.DisableUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.ReleaseTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.RemoveTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.RemoveUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.TaskInfoChangeProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.UserPropertyChangeProblemFactChange;
import org.kie.kogito.taskassigning.service.PlanningItem;
import org.kie.kogito.taskassigning.service.util.IndexedElement;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.slf4j.Logger;

public class TraceUtil {
    private static final String NEW_LINE = System.lineSeparator();
    private static final String TASK_WITH_NAME_FORMAT = " -> ({}, {})";

    private TraceUtil() {
    }

    public static void traceProgrammedChanges(Logger logger, List<RemoveTaskProblemFactChange> removedTasksChanges, List<ReleaseTaskProblemFactChange> releasedTasksChanges, Map<String, List<IndexedElement<AssignTaskProblemFactChange>>> changesByUserId, List<TaskInfoChangeProblemFactChange> taskPropertyChanges, List<AddTaskProblemFactChange> newTasksChanges, List<AddUserProblemFactChange> newUsersChanges, List<ProblemFactChange<TaskAssigningSolution>> usersChanges, List<RemoveUserProblemFactChange> removedUsersChanges) {
        logger.trace("***** Programmed changes *****");
        logger.trace("*** Removed tasks ***");
        logger.trace("Total tasks removed from solution is {}", (Object)removedTasksChanges.size());
        removedTasksChanges.forEach(change -> logger.trace(TASK_WITH_NAME_FORMAT, (Object)change.getTaskAssignment().getTask().getId(), (Object)change.getTaskAssignment().getTask().getName()));
        logger.trace("*** End of removed tasks ***{}", (Object)NEW_LINE);
        logger.trace("*** Released tasks ***");
        logger.trace("Total tasks released from solution is {}", (Object)releasedTasksChanges.size());
        releasedTasksChanges.forEach(change -> logger.trace(TASK_WITH_NAME_FORMAT, (Object)change.getTaskAssignment().getTask().getId(), (Object)change.getTaskAssignment().getTask().getName()));
        logger.trace("*** End of released tasks ***{}", (Object)NEW_LINE);
        logger.trace("*** Changes per user ***");
        logger.trace("Total users with programmed changes is {}", (Object)changesByUserId.size());
        changesByUserId.forEach((key, perUserChanges) -> {
            if (perUserChanges != null) {
                perUserChanges.forEach(change -> {
                    logger.trace("{}  AssignTaskToUserChanges for user: {}", (Object)NEW_LINE, key);
                    logger.trace("{}   -> taskId: {}, pinned: {}, index: {}", new Object[]{NEW_LINE, ((AssignTaskProblemFactChange)change.getElement()).getTaskAssignment().getTask().getId(), change.isPinned(), change.getIndex()});
                    logger.trace("  End of AssignTaskToUserChanges for user: {}", key);
                });
            }
        });
        logger.trace("*** End of changes per user ***{}", (Object)NEW_LINE);
        logger.trace("*** Task property changes ***");
        logger.trace("Total tasks with property changes is {}", (Object)taskPropertyChanges.size());
        taskPropertyChanges.forEach(change -> logger.trace(TASK_WITH_NAME_FORMAT, (Object)change.getTaskAssignment().getTask().getId(), (Object)change.getTaskAssignment().getTask().getName()));
        logger.trace("*** End of task property changes ***{}", (Object)NEW_LINE);
        logger.trace("*** New tasks ***");
        logger.trace("Total new tasks added to solution is {}", (Object)newTasksChanges.size());
        newTasksChanges.forEach(change -> logger.trace(TASK_WITH_NAME_FORMAT, (Object)change.getTaskAssignment().getTask().getId(), (Object)change.getTaskAssignment().getTask().getName()));
        logger.trace("*** End of new tasks ***{}", (Object)NEW_LINE);
        logger.trace("*** New users ***");
        logger.trace("Total new users added to solution is {}", (Object)newUsersChanges.size());
        newUsersChanges.forEach(change -> logger.trace(" -> {}", (Object)change.getUser()));
        logger.trace("*** End of new users ***{}", (Object)NEW_LINE);
        logger.trace("*** User changes ***");
        logger.trace("Total users with changes is {}", (Object)usersChanges.size());
        usersChanges.stream().filter(change -> change instanceof DisableUserProblemFactChange).forEach(change -> logger.trace(" -> disabled {}", (Object)((DisableUserProblemFactChange)change).getUser()));
        usersChanges.stream().filter(change -> change instanceof UserPropertyChangeProblemFactChange).forEach(change -> logger.trace(" -> modified {}", (Object)((UserPropertyChangeProblemFactChange)change).getUser()));
        logger.trace("*** End of user changes ***{}", (Object)NEW_LINE);
        logger.trace("*** Removed users ***");
        logger.trace("Total users removed from solution is {}", (Object)removedUsersChanges.size());
        removedUsersChanges.forEach(change -> logger.trace(" -> removed {}", (Object)change.getUser()));
        logger.trace("*** End of removed users ***");
        logger.trace("***** End of Programmed changes *****");
    }

    public static void traceSolution(Logger logger, TaskAssigningSolution solution) {
        logger.trace("*** Start of solution trace, with users = {} and tasks = {} ***", (Object)solution.getUserList().size(), (Object)solution.getTaskAssignmentList().size());
        for (User user : solution.getUserList()) {
            TaskAssignment nextElement = user.getNextElement();
            if (nextElement == null) {
                logger.trace("{} -> has no tasks", (Object)user.getId());
                continue;
            }
            while (nextElement != null) {
                logger.trace("{} -> {}, pinned: {}, priority: {}, state: {}", new Object[]{user.getId(), nextElement.getId(), nextElement.isPinned(), nextElement.getTask().getPriority(), nextElement.getTask().getState()});
                nextElement = nextElement.getNextElement();
            }
        }
        logger.trace("*** End of solution trace ***");
    }

    public static void tracePlanning(Logger logger, List<PlanningItem> planningItems) {
        logger.trace("*** Start of calculated planning trace with {} items ***", (Object)planningItems.size());
        planningItems.forEach(item -> logger.trace("{} -> {}", (Object)item.getTargetUser(), (Object)item.getTask().getId()));
        logger.trace("*** End of calculated planning trace ***");
    }
}

