/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.user.service.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;

public class DefLinesReader {
    private static final String CONNECTOR_CONFIG_PREFIX = "kogito.task-assigning.properties-connector.";
    private static final String USER_DEF_PREFIX = "kogito.task-assigning.properties-connector.user.";
    private static final String USER_DEF_PREFIX_REGEX = "(kogito\\.task-assigning\\.properties-connector\\.user\\.)";
    private static final String USER_NAME_REGEX = "([^.\\s]+)";
    private static final String GROUPS_REGEX = "(\\.groups)";
    private static final String USER_GROUP_DEF_REGEX = "(kogito\\.task-assigning\\.properties-connector\\.user\\.)([^.\\s]+)(\\.groups)";
    private static final String USER_ATTRIBUTE_NAME_REGEX = "([^.\\s]+)";
    private static final String ATTRIBUTE_REGEX = "(\\.attribute\\.)";
    private static final String USER_ATTRIBUTE_DEF_REGEX = "(kogito\\.task-assigning\\.properties-connector\\.user\\.)([^.\\s]+)(\\.attribute\\.)([^.\\s]+)";
    private static final Pattern GROUP_DEF_PATTERN = Pattern.compile("(kogito\\.task-assigning\\.properties-connector\\.user\\.)([^.\\s]+)(\\.groups)");
    private static final Pattern ATTRIBUTE_DEF_PATTERN = Pattern.compile("(kogito\\.task-assigning\\.properties-connector\\.user\\.)([^.\\s]+)(\\.attribute\\.)([^.\\s]+)");
    private static final String UNRECOGNIZED_PROPERTY = "The configured property name: %s, is not a configuration property supported by the PropertiesConnector. Valid examples are:  kogito.task-assigning.properties-connector.user.myUserName.groups=group1,group2 or kogito.task-assigning.properties-connector.user.myUserName.attribute.myAttributeName=someValue";

    private DefLinesReader() {
    }

    public static Map<String, List<DefLine>> readDefLines(Config config) {
        HashMap<String, List<DefLine>> result = new HashMap<String, List<DefLine>>();
        for (String propertyName : config.getPropertyNames()) {
            if (!propertyName.startsWith(CONNECTOR_CONFIG_PREFIX)) continue;
            String propertyValue = config.getOptionalValue(propertyName, String.class).orElse(null);
            if (GROUP_DEF_PATTERN.matcher(propertyName).matches()) {
                GroupsDefLine groupsDefLine = DefLinesReader.extractGroupsDefLine(propertyName, propertyValue);
                result.computeIfAbsent(groupsDefLine.getUserName(), p -> new ArrayList()).add(groupsDefLine);
                continue;
            }
            if (ATTRIBUTE_DEF_PATTERN.matcher(propertyName).matches()) {
                AttributeDefLine attributeDefLine = DefLinesReader.extractAttributeDefLine(propertyName, propertyValue);
                result.computeIfAbsent(attributeDefLine.getUserName(), p -> new ArrayList()).add(attributeDefLine);
                continue;
            }
            throw new IllegalArgumentException(String.format(UNRECOGNIZED_PROPERTY, propertyName));
        }
        return result;
    }

    private static GroupsDefLine extractGroupsDefLine(String propertyName, String value) {
        String[] split = propertyName.split(USER_DEF_PREFIX_REGEX);
        String[] subSplit = split[1].split(GROUPS_REGEX);
        String userName = subSplit[0];
        return new GroupsDefLine(userName, value);
    }

    private static AttributeDefLine extractAttributeDefLine(String propertyName, String value) {
        String[] split = propertyName.split(USER_DEF_PREFIX_REGEX);
        String[] subSplit = split[1].split(ATTRIBUTE_REGEX);
        String userName = subSplit[0];
        String attributeName = subSplit[1];
        return new AttributeDefLine(userName, attributeName, value);
    }

    public static class AttributeDefLine
    extends DefLine {
        private String attributeName;

        public AttributeDefLine(String userName, String attributeName, String value) {
            super(userName, value);
            this.attributeName = attributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String toString() {
            return "AttributeDefLine{userName='" + this.userName + "', value='" + this.value + "', attributeName='" + this.attributeName + "'}";
        }
    }

    public static class GroupsDefLine
    extends DefLine {
        public GroupsDefLine(String userName, String groups) {
            super(userName, groups);
        }

        public String toString() {
            return "GroupsDefLine{userName='" + this.userName + "', value='" + this.value + "'}";
        }
    }

    public static abstract class DefLine {
        protected String userName;
        protected String value;

        protected DefLine(String userName, String value) {
            this.userName = userName;
            this.value = value;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getValue() {
            return this.value;
        }
    }
}

