/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.user.service.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.kie.kogito.taskassigning.user.service.Group;
import org.kie.kogito.taskassigning.user.service.User;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.kie.kogito.taskassigning.user.service.properties.DefLinesReader;
import org.kie.kogito.taskassigning.user.service.properties.GroupImpl;
import org.kie.kogito.taskassigning.user.service.properties.UserImpl;

@ApplicationScoped
public class UserServicePropertiesConnector
implements UserServiceConnector {
    public static final String NAME = "PropertiesConnector";
    private final Map<String, User> users = new HashMap<String, User>();
    private final Config config;

    @Inject
    public UserServicePropertiesConnector(Config config) {
        this.config = config;
    }

    public String getName() {
        return NAME;
    }

    public void start() {
        Map<String, List<DefLinesReader.DefLine>> defLineByUser = DefLinesReader.readDefLines(this.config);
        for (Map.Entry<String, List<DefLinesReader.DefLine>> entry : defLineByUser.entrySet()) {
            User user = this.users.computeIfAbsent(entry.getKey(), userId -> new UserImpl((String)userId, (Set<Group>)new HashSet<Group>(), (Map<String, Object>)new HashMap<String, Object>()));
            for (DefLinesReader.DefLine userDefLine : entry.getValue()) {
                if (userDefLine instanceof DefLinesReader.GroupsDefLine) {
                    this.addGroups(user, (DefLinesReader.GroupsDefLine)userDefLine);
                    continue;
                }
                this.addAttribute(user, (DefLinesReader.AttributeDefLine)userDefLine);
            }
        }
    }

    private void addGroups(User user, DefLinesReader.GroupsDefLine groupsDefLine) {
        if (groupsDefLine != null && groupsDefLine.getValue() != null) {
            Stream.of(groupsDefLine.getValue().split(",")).forEach(groupName -> {
                if (!groupName.trim().isEmpty()) {
                    user.getGroups().add(new GroupImpl(groupName.trim()));
                }
            });
        }
    }

    private void addAttribute(User user, DefLinesReader.AttributeDefLine attributeDefLine) {
        user.getAttributes().put(attributeDefLine.getAttributeName(), attributeDefLine.getValue());
    }

    public List<User> findAllUsers() {
        return new ArrayList<User>(this.users.values());
    }

    public User findUser(String id) {
        return this.users.get(id);
    }
}

