/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import io.reactivex.BackpressureStrategy;
import io.reactivex.subjects.PublishSubject;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.kie.kogito.decision.DecisionModelResourcesProvider;
import org.kie.kogito.tracing.decision.BaseModelEventEmitter;
import org.reactivestreams.Publisher;

@Singleton
public class QuarkusModelEventEmitter
extends BaseModelEventEmitter {
    private final PublishSubject<String> eventSubject = PublishSubject.create();

    @Inject
    public QuarkusModelEventEmitter(DecisionModelResourcesProvider decisionModelResourcesProvider) {
        super(decisionModelResourcesProvider);
    }

    public void publishDecisionModels() {
        super.publishDecisionModels();
    }

    @Outgoing(value="kogito-tracing-model")
    public Publisher<String> getEventPublisher() {
        return this.eventSubject.toFlowable(BackpressureStrategy.BUFFER);
    }

    public void emit(String payload) {
        this.eventSubject.onNext((Object)payload);
    }
}

