/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.trusty.storage.infinispan;

import java.io.IOException;

import org.kie.kogito.trusty.storage.api.model.MessageExceptionField;

import com.fasterxml.jackson.databind.ObjectMapper;

public class MessageExceptionFieldMarshaller extends AbstractModelMarshaller<MessageExceptionField> {

    public MessageExceptionFieldMarshaller(ObjectMapper mapper) {
        super(mapper, MessageExceptionField.class);
    }

    @Override
    public MessageExceptionField readFrom(ProtoStreamReader reader) throws IOException {
        return new MessageExceptionField(
                reader.readString(MessageExceptionField.CLASS_NAME_FIELD),
                reader.readString(MessageExceptionField.MESSAGE_FIELD),
                reader.readObject(MessageExceptionField.CAUSE_FIELD, MessageExceptionField.class));
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, MessageExceptionField input) throws IOException {
        writer.writeString(MessageExceptionField.CLASS_NAME_FIELD, input.getClassName());
        writer.writeString(MessageExceptionField.MESSAGE_FIELD, input.getMessage());
        writer.writeObject(MessageExceptionField.CAUSE_FIELD, input.getCause(), MessageExceptionField.class);
    }
}
