/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.redis;

import io.quarkus.runtime.Startup;
import io.redisearch.Schema;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.kie.kogito.persistence.redis.index.RedisCreateIndexEvent;
import org.kie.kogito.persistence.redis.index.RedisIndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class IndexProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexProvider.class);
    private RedisIndexManager indexManager;

    @Inject
    public IndexProvider(RedisIndexManager redisIndexManager) {
        this.indexManager = redisIndexManager;
    }

    @PostConstruct
    public void createIndexes() {
        LOGGER.debug("Creating redis indexes for Trusty Service.");
        this.createDecisionStorageIndex();
        this.createModelsStorageIndex();
        this.createLIMEResultsStorageIndex();
        this.createCounterfactualRequestsStorageIndex();
        this.createCounterfactualResultsStorageIndex();
        LOGGER.debug("Creation of redis indexes completed.");
    }

    private void createDecisionStorageIndex() {
        RedisCreateIndexEvent decisionIndexEvent = new RedisCreateIndexEvent("decisions");
        decisionIndexEvent.withField(new Schema.Field("executionId", Schema.FieldType.FullText, false));
        decisionIndexEvent.withField(new Schema.Field("executionTimestamp", Schema.FieldType.Numeric, true));
        this.indexManager.createIndex(decisionIndexEvent);
    }

    private void createModelsStorageIndex() {
        RedisCreateIndexEvent modelIndexEvent = new RedisCreateIndexEvent("models");
        this.indexManager.createIndex(modelIndexEvent);
    }

    private void createLIMEResultsStorageIndex() {
        RedisCreateIndexEvent explainabilityIndexEvent = new RedisCreateIndexEvent("limeResults");
        this.indexManager.createIndex(explainabilityIndexEvent);
    }

    private void createCounterfactualRequestsStorageIndex() {
        RedisCreateIndexEvent counterfactualsIndexEvent = new RedisCreateIndexEvent("counterfactualRequests");
        counterfactualsIndexEvent.withField(new Schema.Field("executionId", Schema.FieldType.FullText, false));
        counterfactualsIndexEvent.withField(new Schema.Field("counterfactualId", Schema.FieldType.FullText, false));
        this.indexManager.createIndex(counterfactualsIndexEvent);
    }

    private void createCounterfactualResultsStorageIndex() {
        RedisCreateIndexEvent counterfactualResultsIndexEvent = new RedisCreateIndexEvent("counterfactualResults");
        counterfactualResultsIndexEvent.withField(new Schema.Field("executionId", Schema.FieldType.FullText, false));
        counterfactualResultsIndexEvent.withField(new Schema.Field("counterfactualId", Schema.FieldType.FullText, false));
        counterfactualResultsIndexEvent.withField(new Schema.Field("sequenceId", Schema.FieldType.FullText, true));
        this.indexManager.createIndex(counterfactualResultsIndexEvent);
    }
}

