/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.app;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import org.acme.travels.VisaApplication;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.kogito.monitoring.process.PrometheusProcessEventListener;

public class VisaApplicationPrometheusProcessEventListener
extends PrometheusProcessEventListener {
    protected final Counter numberOfVisaApplicationsApproved = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("acme_travels_visas_approved_total")).help("Approved visa applications")).labelNames(new String[]{"app_id", "country", "duration", "nationality"})).register();
    protected final Counter numberOfVisaApplicationsRejected = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("acme_travels_visas_rejected_total")).help("Rejected visa applications")).labelNames(new String[]{"app_id", "country", "duration", "nationality"})).register();
    private String identifier;

    public VisaApplicationPrometheusProcessEventListener(String identifier) {
        super(identifier);
        this.identifier = identifier;
    }

    public void cleanup() {
        CollectorRegistry.defaultRegistry.unregister((Collector)this.numberOfVisaApplicationsApproved);
        CollectorRegistry.defaultRegistry.unregister((Collector)this.numberOfVisaApplicationsRejected);
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        super.afterProcessCompleted(event);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        if (processInstance.getProcessId().equals("visaApplications")) {
            VisaApplication application = (VisaApplication)processInstance.getVariable("visaApplication");
            if (application.isApproved()) {
                ((Counter.Child)this.numberOfVisaApplicationsApproved.labels(new String[]{this.identifier, this.safeValue(application.getCountry()), String.valueOf(application.getDuration()), this.safeValue(application.getNationality())})).inc();
            } else {
                ((Counter.Child)this.numberOfVisaApplicationsRejected.labels(new String[]{this.identifier, this.safeValue(application.getCountry()), String.valueOf(application.getDuration()), this.safeValue(application.getNationality())})).inc();
            }
        }
    }

    protected String safeValue(String value) {
        if (value == null) {
            return "unknown";
        }
        return value;
    }
}

