/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.cdi.Kjar;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutorService;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.remote.common.exception.RestOperationException;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.async.JobResultManager;
import org.kie.remote.services.rest.async.cmd.DeploymentCmd;
import org.kie.remote.services.rest.async.cmd.JobType;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentDescriptor;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/deployment/{deploymentId: [\\w\\.-]+(:[\\w\\.-]+){2,2}(:[\\w\\.-]*){0,2}}")
@RequestScoped
public class DeploymentResource
extends ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);
    @Context
    private HttpHeaders headers;
    @PathParam(value="deploymentId")
    private String deploymentId;
    @Inject
    @Kjar
    private KModuleDeploymentService deploymentService;
    @Inject
    private ExecutorService jobExecutor;
    @Inject
    private JobResultManager jobResultMgr;
    private final AtomicLong jobIdGen = new AtomicLong(0L);

    protected KModuleDeploymentUnit createDeploymentUnit(String deploymentId, JaxbDeploymentDescriptor descriptor) {
        String[] gavKK = deploymentId.split(":");
        KModuleDeploymentUnit deployUnit = new KModuleDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
        if (gavKK.length > 3) {
            deployUnit.setKbaseName(gavKK[3]);
        }
        if (gavKK.length > 4) {
            deployUnit.setKsessionName(gavKK[4]);
        }
        if (descriptor != null) {
            DeploymentDescriptor realDepDesc = DeploymentResource.convertToDeploymentDescriptor(descriptor);
            deployUnit.setDeploymentDescriptor(realDepDesc);
        }
        return deployUnit;
    }

    private static DeploymentDescriptor convertToDeploymentDescriptor(JaxbDeploymentDescriptor jaxbDepDesc) {
        DeploymentDescriptorImpl depDescImpl = new DeploymentDescriptorImpl(jaxbDepDesc.getPersistenceUnit());
        depDescImpl.setAuditPersistenceUnit(jaxbDepDesc.getAuditPersistenceUnit());
        depDescImpl.setAuditMode(jaxbDepDesc.getAuditMode());
        depDescImpl.setPersistenceMode(jaxbDepDesc.getPersistenceMode());
        depDescImpl.setRuntimeStrategy(jaxbDepDesc.getRuntimeStrategy());
        depDescImpl.setMarshallingStrategies(jaxbDepDesc.getMarshallingStrategies());
        depDescImpl.setEventListeners(jaxbDepDesc.getEventListeners());
        depDescImpl.setTaskEventListeners(jaxbDepDesc.getTaskEventListeners());
        depDescImpl.setGlobals(jaxbDepDesc.getGlobals());
        depDescImpl.setWorkItemHandlers(jaxbDepDesc.getWorkItemHandlers());
        depDescImpl.setEnvironmentEntries(jaxbDepDesc.getEnvironmentEntries());
        depDescImpl.setConfiguration(jaxbDepDesc.getConfiguration());
        depDescImpl.setRequiredRoles(jaxbDepDesc.getRequiredRoles());
        return depDescImpl;
    }

    static JaxbDeploymentUnit convertKModuleDepUnitToJaxbDepUnit(KModuleDeploymentUnit kDepUnit) {
        JaxbDeploymentUnit jDepUnit = new JaxbDeploymentUnit(kDepUnit.getGroupId(), kDepUnit.getArtifactId(), kDepUnit.getVersion(), kDepUnit.getKbaseName(), kDepUnit.getKsessionName());
        jDepUnit.setStrategy(kDepUnit.getStrategy());
        return jDepUnit;
    }

    @GET
    public Response getConfig() {
        JaxbDeploymentUnit jaxbDepUnit = this.determineStatus(true);
        logger.debug("Returning deployment unit information for " + this.deploymentId);
        return DeploymentResource.createCorrectVariant(jaxbDepUnit, this.headers);
    }

    JaxbDeploymentUnit determineStatus(boolean checkDeploymentService) {
        JaxbDeploymentUnit jaxbDepUnit;
        DeployedUnit deployedUnit;
        if (checkDeploymentService && (deployedUnit = this.deploymentService.getDeployedUnit(this.deploymentId)) != null) {
            KModuleDeploymentUnit depUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
            JaxbDeploymentUnit jaxbDepUnit2 = DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(depUnit);
            jaxbDepUnit2.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED);
            return jaxbDepUnit2;
        }
        JaxbDeploymentJobResult jobResult = this.jobResultMgr.getMostRecentJob(this.deploymentId);
        if (jobResult != null) {
            JaxbDeploymentUnit jaxbDepUnit3 = jobResult.getDeploymentUnit();
            return jaxbDepUnit3;
        }
        String[] gavKK = this.deploymentId.split(":");
        switch (gavKK.length) {
            case 3: {
                jaxbDepUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
                break;
            }
            case 4: {
                jaxbDepUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2], gavKK[3], null);
                break;
            }
            case 5: {
                jaxbDepUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2], gavKK[3], gavKK[4]);
                break;
            }
            default: {
                throw RestOperationException.notFound((String)("Invalid deployment id: " + this.deploymentId));
            }
        }
        jaxbDepUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.NONEXISTENT);
        return jaxbDepUnit;
    }

    @POST
    @Path(value="/deploy")
    public Response deploy(JaxbDeploymentDescriptor deployDescriptor) {
        JaxbDeploymentJobResult jobResult;
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(this.deploymentId);
        if (deployedUnit != null) {
            KModuleDeploymentUnit kDepUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
            JaxbDeploymentUnit jaxbDepUnit = DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(kDepUnit);
            jobResult = new JaxbDeploymentJobResult(null, "The deployment already exists and must be first undeployed!", jaxbDepUnit, JobType.DEPLOY.toString());
            jobResult.setSuccess(Boolean.valueOf(false));
        } else {
            Map<String, String[]> params = this.getRequestParams();
            String oper = this.getRelativePath();
            String strategy = DeploymentResource.getStringParam("strategy", false, params, oper);
            String mergeMode = DeploymentResource.getStringParam("mergemode", false, params, oper);
            KModuleDeploymentUnit deploymentUnit = this.createDeploymentUnit(this.deploymentId, deployDescriptor);
            if (strategy != null) {
                RuntimeStrategy runtimeStrategy;
                strategy = strategy.toUpperCase();
                try {
                    runtimeStrategy = RuntimeStrategy.valueOf((String)strategy);
                }
                catch (IllegalArgumentException iae) {
                    throw RestOperationException.badRequest((String)("Runtime strategy '" + strategy + "' does not exist."));
                }
                deploymentUnit.setStrategy(runtimeStrategy);
            }
            if (mergeMode != null) {
                MergeMode mode;
                mergeMode = mergeMode.toUpperCase();
                try {
                    mode = MergeMode.valueOf((String)mergeMode);
                }
                catch (IllegalArgumentException iae) {
                    throw RestOperationException.badRequest((String)("Merge mode '" + mergeMode + "' does not exist."));
                }
                deploymentUnit.setMergeMode(mode);
            }
            jobResult = this.scheduleDeploymentJobRequest(JobType.DEPLOY, deploymentUnit);
        }
        return DeploymentResource.createCorrectVariant(jobResult, this.headers, Response.Status.ACCEPTED);
    }

    @POST
    @Path(value="/undeploy")
    public Response undeploy() {
        JaxbDeploymentJobResult jobResult;
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(this.deploymentId);
        if (deployedUnit != null) {
            KModuleDeploymentUnit deploymentUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
            jobResult = this.scheduleDeploymentJobRequest(JobType.UNDEPLOY, deploymentUnit);
        } else {
            String explanation;
            JaxbDeploymentUnit depUnit = this.determineStatus(false);
            switch (depUnit.getStatus()) {
                case ACCEPTED: 
                case DEPLOYED: 
                case DEPLOYING: {
                    explanation = "The deployment can not be undeployed because the initial deployment has not yet fully completed.";
                    break;
                }
                case DEPLOY_FAILED: {
                    explanation = "The deployment can not be undeployed because the initial deployment failed.";
                    break;
                }
                case NONEXISTENT: 
                case UNDEPLOYED: 
                case UNDEPLOYING: {
                    explanation = "The deployment can not be undeployed because it has already been undeployed (or is currently being undeployed)";
                    break;
                }
                case UNDEPLOY_FAILED: {
                    explanation = "The last undeployment failed, but the deployment unit is no longer present (and can not be undeployed, thus). There is probably a very high load on this server. Turning on debugging may provide insight.";
                    logger.debug("Stack trace:", new Throwable());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown deployment unit status: " + depUnit.getStatus());
                }
            }
            jobResult = new JaxbDeploymentJobResult(null, explanation, depUnit, JobType.UNDEPLOY.toString());
            jobResult.setSuccess(Boolean.valueOf(false));
        }
        return DeploymentResource.createCorrectVariant(jobResult, this.headers, Response.Status.ACCEPTED);
    }

    private JaxbDeploymentJobResult scheduleDeploymentJobRequest(JobType jobType, KModuleDeploymentUnit deploymentUnit) {
        CommandContext ctx = new CommandContext();
        ctx.setData("DeploymentUnit", (Object)deploymentUnit);
        ctx.setData("JobType", (Object)jobType);
        ctx.setData("businessKey", (Object)this.deploymentId);
        ctx.setData("retries", (Object)0);
        String jobTypeLower = jobType.toString().toLowerCase();
        String jobId = "" + System.currentTimeMillis() + "-" + this.jobIdGen.incrementAndGet();
        ctx.setData("JobId", (Object)jobId);
        JaxbDeploymentJobResult jobResult = new JaxbDeploymentJobResult(jobId, jobTypeLower + " job accepted.", DeploymentResource.convertKModuleDepUnitToJaxbDepUnit(deploymentUnit), jobType.toString());
        jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.ACCEPTED);
        logger.debug("{} job [{}] for deployment '{}' created.", new Object[]{jobType.toString(), jobId, deploymentUnit.getIdentifier()});
        this.jobResultMgr.putJob(jobResult.getJobId(), jobResult, jobType);
        try {
            Long executorJobId = this.jobExecutor.scheduleRequest(DeploymentCmd.class.getName(), ctx);
            jobResult.setIdentifier(executorJobId);
            jobResult.setSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            String msg = "Unable to " + jobType.toString().toLowerCase() + " deployment '" + this.deploymentId + "': " + e.getClass().getSimpleName() + " thrown [" + e.getMessage() + "]";
            logger.error(msg, (Throwable)e);
            jobResult.setExplanation(msg);
            jobResult.setSuccess(Boolean.valueOf(false));
        }
        return jobResult;
    }
}

