/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.QueryContextImpl;
import org.jbpm.services.cdi.Kjar;
import org.kie.internal.query.QueryContext;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.remote.services.rest.DeploymentResource;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnitList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinitionList;

@Path(value="/deployment")
@RequestScoped
public class DeploymentsResource
extends ResourceBase {
    @Context
    private HttpHeaders headers;
    @Inject
    @Kjar
    private KModuleDeploymentService deploymentService;
    @Inject
    private DeploymentInfoBean deploymentInfoBean;
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    private DefinitionService bpmn2DataService;

    @GET
    public Response listDeployments() {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        int[] pageInfo = DeploymentsResource.getPageNumAndPageSize(params, oper);
        int maxNumResults = DeploymentsResource.getMaxNumResultsNeeded(pageInfo);
        ArrayList<String> deploymentIds = new ArrayList<String>(this.deploymentInfoBean.getDeploymentIds());
        Collections.sort(deploymentIds);
        JaxbDeploymentUnitList jaxbDepUnitList = new JaxbDeploymentUnitList();
        List depUnitList = jaxbDepUnitList.getDeploymentUnitList();
        for (String deploymentId : deploymentIds) {
            DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
            if (deployedUnit == null) continue;
            JaxbDeploymentUnit jaxbDepUnit = DeploymentResource.convertKModuleDepUnitToJaxbDepUnit((KModuleDeploymentUnit)deployedUnit.getDeploymentUnit());
            jaxbDepUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED);
            depUnitList.add(jaxbDepUnit);
            if (depUnitList.size() != maxNumResults) continue;
            break;
        }
        JaxbDeploymentUnitList resultList = DeploymentsResource.paginateAndCreateResult(pageInfo, depUnitList, new JaxbDeploymentUnitList());
        return DeploymentsResource.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/processes")
    public Response listProcessDefinitions() {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        int[] pageInfo = DeploymentsResource.getPageNumAndPageSize(params, oper);
        int maxNumResults = DeploymentsResource.getMaxNumResultsNeeded(pageInfo);
        ArrayList<String> deploymentIds = new ArrayList<String>(this.deploymentInfoBean.getDeploymentIds());
        Collections.sort(deploymentIds);
        JaxbProcessDefinitionList jaxbProcDefList = new JaxbProcessDefinitionList();
        List procDefList = jaxbProcDefList.getProcessDefinitionList();
        block6: for (String deploymentId : deploymentIds) {
            ArrayList processIdList;
            try {
                processIdList = new ArrayList(this.runtimeDataService.getProcessIds(deploymentId, (QueryContext)new QueryContextImpl(Integer.valueOf(pageInfo[0]), Integer.valueOf(pageInfo[1]))));
                Collections.sort(processIdList);
            }
            catch (Exception e) {
                logger.debug("Unable to retrieve process ids for deployment '{}': {}", new Object[]{deploymentId, e.getMessage(), e});
                continue;
            }
            for (String processId : processIdList) {
                Map variables;
                ProcessDefinition processAssetDesc;
                block9: {
                    try {
                        processAssetDesc = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentId, processId);
                        if (processAssetDesc == null) {
                            logger.error("No process definition information available for process definition '{}' in deployment '{}'!", (Object)processId, (Object)deploymentId);
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        logger.debug("Unable to retrieve process definition for process '{}' in deployment '{}': {}", new Object[]{processId, deploymentId, e.getMessage(), e});
                    }
                    continue;
                }
                JaxbProcessDefinition jaxbProcDef = this.convertProcAssetDescToJaxbProcDef(processAssetDesc);
                try {
                    variables = this.bpmn2DataService.getProcessVariables(deploymentId, processId);
                }
                catch (Exception e) {
                    logger.debug("Unable to retrieve process definition data for process '{}' in deployment '{}': {}", new Object[]{processId, deploymentId, e.getMessage(), e});
                    continue;
                }
                jaxbProcDef.setVariables(variables);
                procDefList.add(jaxbProcDef);
                if (procDefList.size() != maxNumResults) continue;
                break block6;
            }
        }
        JaxbProcessDefinitionList resultList = DeploymentsResource.paginateAndCreateResult(pageInfo, procDefList, new JaxbProcessDefinitionList());
        return DeploymentsResource.createCorrectVariant(resultList, this.headers);
    }
}

