/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessIdsCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.GetWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.util.StringUtils;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.remote.common.exception.RestOperationException;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.util.FormURLGenerator;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceFormResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItem;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;

@Path(value="/runtime/{deploymentId: [\\w\\.-]+(:[\\w\\.-]+){2,2}(:[\\w\\.-]*){0,2}}")
@RequestScoped
public class RuntimeResource
extends ResourceBase {
    @Context
    protected HttpHeaders headers;
    @PathParam(value="deploymentId")
    protected String deploymentId;
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    private DefinitionService bpmn2DataService;
    @Inject
    private FormURLGenerator formURLGenerator;

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return this.restProcessJaxbCommandsRequest(cmdsRequest);
    }

    @GET
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/")
    public Response process_defId(@PathParam(value="processDefId") String processId) {
        ProcessDefinition processAssetDescList = this.runtimeDataService.getProcessesByDeploymentIdProcessId(this.deploymentId, processId);
        JaxbProcessDefinition jaxbProcDef = this.convertProcAssetDescToJaxbProcDef(processAssetDescList);
        Map variables = this.bpmn2DataService.getProcessVariables(this.deploymentId, processId);
        jaxbProcDef.setVariables(variables);
        return RuntimeResource.createCorrectVariant(jaxbProcDef, this.headers);
    }

    @POST
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response process_defId_start(@PathParam(value="processDefId") String processId) {
        Map<String, String[]> requestParams = this.getRequestParams();
        String oper = this.getRelativePath();
        Map<String, Object> params = RuntimeResource.extractMapFromParams(requestParams, oper);
        ProcessInstance result = this.startProcessInstance(processId, params);
        JaxbProcessInstanceResponse responseObj = new JaxbProcessInstanceResponse(result, this.getRequestUri());
        return RuntimeResource.createCorrectVariant(responseObj, this.headers);
    }

    @POST
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/startform")
    public Response process_defId_startform(@PathParam(value="processDefId") String processId) {
        List result = (List)this.processRequestBean.doKieSessionOperation((Command<?>)new GetProcessIdsCommand(), this.deploymentId, null);
        if (result != null && result.contains(processId)) {
            String formUrl;
            String opener = "";
            List openers = this.headers.getRequestHeader("host");
            if (openers.size() == 1) {
                opener = (String)openers.get(0);
            }
            if (!StringUtils.isEmpty((CharSequence)(formUrl = this.formURLGenerator.generateFormProcessURL(this.getBaseUri(), processId, this.deploymentId, opener)))) {
                JaxbProcessInstanceFormResponse response = new JaxbProcessInstanceFormResponse(formUrl, this.getRequestUri());
                return RuntimeResource.createCorrectVariant(response, this.headers);
            }
        }
        throw RestOperationException.notFound((String)("Process " + processId + " is not available."));
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}")
    public Response process_instance_procInstId(@PathParam(value="procInstId") Long procInstId) {
        ProcessInstance result = this.getProcessInstance(procInstId, true);
        return RuntimeResource.createCorrectVariant(new JaxbProcessInstanceResponse(result), this.headers);
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/abort")
    public Response process_instance_procInstId_abort(@PathParam(value="procInstId") Long procInstId) {
        AbortProcessInstanceCommand cmd = new AbortProcessInstanceCommand();
        cmd.setProcessInstanceId(procInstId);
        try {
            this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().startsWith("Could not find process instance")) {
                throw RestOperationException.notFound((String)("Process instance " + procInstId + " is not available."));
            }
            throw iae;
        }
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/signal")
    public Response process_instance_procInstId_signal(@PathParam(value="procInstId") Long procInstId) {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        String eventType = RuntimeResource.getStringParam("signal", true, params, oper);
        Object event = RuntimeResource.getObjectParam("event", false, params, oper);
        SignalEventCommand cmd = new SignalEventCommand(procInstId.longValue(), eventType, event);
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}/variable/{varName: [\\w\\.-]+}")
    public Response process_instance_procInstId_variable_varName(@PathParam(value="procInstId") Long procInstId, @PathParam(value="varName") String varName) {
        Object procVar = this.processRequestBean.getVariableObjectInstanceFromRuntime(this.deploymentId, procInstId, varName);
        QName rootElementName = this.getRootElementName(procVar);
        JAXBElement jaxbElem = new JAXBElement(rootElementName, procVar.getClass(), procVar);
        return RuntimeResource.createCorrectVariant(jaxbElem, this.headers);
    }

    @POST
    @Path(value="/signal")
    public Response signal() {
        String oper = this.getRelativePath();
        Map<String, String[]> requestParams = this.getRequestParams();
        String eventType = RuntimeResource.getStringParam("signal", true, requestParams, oper);
        Object event = RuntimeResource.getObjectParam("event", false, requestParams, oper);
        this.processRequestBean.doKieSessionOperation((Command<?>)new SignalEventCommand(eventType, event), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, requestParams, oper, true));
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    @GET
    @Path(value="/workitem/{workItemId: [0-9-]+}")
    public Response workitem_workItemId(@PathParam(value="workItemId") Long workItemId) {
        String oper = this.getRelativePath();
        WorkItem workItem = (WorkItem)this.processRequestBean.doKieSessionOperation((Command<?>)new GetWorkItemCommand(workItemId.longValue()), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, this.getRequestParams(), oper, true));
        if (workItem == null) {
            throw RestOperationException.notFound((String)("WorkItem " + workItemId + " does not exist."));
        }
        return RuntimeResource.createCorrectVariant(new JaxbWorkItem((org.kie.api.runtime.process.WorkItem)workItem), this.headers);
    }

    @POST
    @Path(value="/workitem/{workItemId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public Response worktiem_workItemId_oper(@PathParam(value="workItemId") Long workItemId, @PathParam(value="oper") String operation) {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        CompleteWorkItemCommand cmd = null;
        if ("complete".equalsIgnoreCase(operation.trim())) {
            Map<String, Object> results = RuntimeResource.extractMapFromParams(params, operation);
            cmd = new CompleteWorkItemCommand(workItemId.longValue(), results);
        } else if ("abort".equalsIgnoreCase(operation.toLowerCase())) {
            cmd = new AbortWorkItemCommand(workItemId.longValue());
        } else {
            throw RestOperationException.badRequest((String)("Unsupported operation: " + oper));
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, params, oper, true));
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    @POST
    @Path(value="/withvars/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response withvars_process_processDefId_start(@PathParam(value="processDefId") String processId) {
        Map<String, String[]> requestParams = this.getRequestParams();
        String oper = this.getRelativePath();
        Map<String, Object> params = RuntimeResource.extractMapFromParams(requestParams, oper);
        ProcessInstance procInst = this.startProcessInstance(processId, params);
        Map<String, String> vars = this.getVariables(procInst.getId());
        JaxbProcessInstanceWithVariablesResponse resp = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.getRequestUri());
        return RuntimeResource.createCorrectVariant(resp, this.headers);
    }

    @GET
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}")
    public Response withvars_process_instance_procInstId(@PathParam(value="procInstId") Long procInstId) {
        ProcessInstance procInst = this.getProcessInstance(procInstId, true);
        Map<String, String> vars = this.getVariables(procInstId);
        JaxbProcessInstanceWithVariablesResponse responseObj = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.getRequestUri());
        return RuntimeResource.createCorrectVariant(responseObj, this.headers);
    }

    @POST
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}/signal")
    public Response withvars_process_instance_procInstid_signal(@PathParam(value="procInstId") Long procInstId) {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        String eventType = RuntimeResource.getStringParam("signal", true, params, oper);
        Object event = RuntimeResource.getObjectParam("event", false, params, oper);
        this.processRequestBean.doKieSessionOperation((Command<?>)new SignalEventCommand(procInstId.longValue(), eventType, event), this.deploymentId, procInstId);
        ProcessInstance processInstance = this.getProcessInstance(procInstId, false);
        Map<String, String> vars = this.getVariables(processInstance.getId());
        return RuntimeResource.createCorrectVariant(new JaxbProcessInstanceWithVariablesResponse(processInstance, vars), this.headers);
    }

    private ProcessInstance getProcessInstance(long procInstId, boolean throwEx) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(Long.valueOf(procInstId));
        cmd.setReadOnly(true);
        Object procInstResult = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId);
        if (procInstResult != null) {
            return (ProcessInstance)procInstResult;
        }
        if (throwEx) {
            throw RestOperationException.notFound((String)("Unable to retrieve process instance " + procInstId + " which may have been completed. Please see the history operations."));
        }
        return null;
    }

    private Map<String, String> getVariables(long processInstanceId) {
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindVariableInstancesCommand(processInstanceId), this.deploymentId, processInstanceId);
        List varInstLogList = (List)result;
        HashMap<String, String> vars = new HashMap<String, String>();
        if (varInstLogList.isEmpty()) {
            return vars;
        }
        HashMap<String, VariableInstanceLog> varLogMap = new HashMap<String, VariableInstanceLog>();
        for (VariableInstanceLog variableInstanceLog : varInstLogList) {
            String varId = variableInstanceLog.getVariableId();
            VariableInstanceLog prevVarLog = varLogMap.put(varId, variableInstanceLog);
            if (prevVarLog == null || !prevVarLog.getDate().after(variableInstanceLog.getDate())) continue;
            varLogMap.put(varId, prevVarLog);
        }
        for (Map.Entry entry : varLogMap.entrySet()) {
            vars.put((String)entry.getKey(), ((VariableInstanceLog)entry.getValue()).getValue());
        }
        return vars;
    }

    private ProcessInstance startProcessInstance(String processId, Map<String, Object> params) {
        Object result = null;
        try {
            result = this.processRequestBean.doKieSessionOperation((Command<?>)new StartProcessCommand(processId, params), this.deploymentId, null);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().startsWith("Unknown process ID")) {
                throw RestOperationException.notFound((String)("Process '" + processId + "' is not known to this deployment."));
            }
            throw iae;
        }
        return (ProcessInstance)result;
    }

    protected QName getRootElementName(Object object) {
        boolean xmlRootElemAnnoFound = false;
        Class<?> objClass = object.getClass();
        XmlRootElement xmlRootElemAnno = objClass.getAnnotation(XmlRootElement.class);
        logger.debug("Getting XML root element annotation for " + object.getClass().getName());
        if (xmlRootElemAnno != null) {
            xmlRootElemAnnoFound = true;
            return new QName(xmlRootElemAnno.name());
        }
        for (Annotation anno : objClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            if (!XmlRootElement.class.getName().equals(annoClass.getName())) continue;
            xmlRootElemAnnoFound = true;
            try {
                Method nameMethod = annoClass.getMethod("name", new Class[0]);
                Object nameVal = nameMethod.invoke((Object)anno, new Object[0]);
                if (!(nameVal instanceof String)) continue;
                return new QName((String)nameVal);
            }
            catch (Exception e) {
                throw RestOperationException.internalServerError((String)"Unable to retrieve XmlRootElement info via reflection", (Exception)e);
            }
        }
        if (!xmlRootElemAnnoFound) {
            String errorMsg = "Unable to serialize " + object.getClass().getName() + " instance " + "because it is missing a " + XmlRootElement.class.getName() + " annotation with a name value.";
            throw RestOperationException.internalServerError((String)errorMsg);
        }
        return null;
    }
}

