/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.cdi;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.command.AuditCommand;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.task.commands.GetContentCommand;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.jbpm.services.task.commands.GetTaskContentCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.command.Command;
import org.kie.api.task.model.Task;
import org.kie.remote.common.exception.RestOperationException;
import org.kie.remote.common.jaxb.JaxbRequestStatus;
import org.kie.remote.services.jaxb.JaxbCommandsRequest;
import org.kie.remote.services.jaxb.JaxbCommandsResponse;
import org.kie.remote.services.util.ExecuteAndSerializeCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProcessRequestBean {
    private static final Logger logger = LoggerFactory.getLogger(ProcessRequestBean.class);
    @Inject
    private ProcessService processService;
    @Inject
    private UserTaskService userTaskService;
    private static final String PERSISTENCE_UNIT_NAME = "org.jbpm.domain";
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;
    private AuditLogService auditLogService;

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setUserTaskService(UserTaskService userTaskService) {
        this.userTaskService = userTaskService;
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    @PostConstruct
    public void initAuditLogService() {
        this.auditLogService = new JPAAuditLogService(this.emf);
        if (this.emf == null) {
            ((JPAAuditLogService)this.auditLogService).setPersistenceUnitName(PERSISTENCE_UNIT_NAME);
        }
    }

    public AuditLogService getAuditLogService() {
        return this.auditLogService;
    }

    public void processCommand(Command cmd, JaxbCommandsRequest request, int i, JaxbCommandsResponse jaxbResponse) {
        String version = request.getVersion();
        if (version == null) {
            version = "pre-6.0.3";
        }
        if (!version.equals("6.2.0.1")) {
            logger.warn("Request received from client version [{}] while server is version [{}]! THIS MAY CAUSE PROBLEMS!", (Object)version, (Object)"6.2.0.1");
        }
        jaxbResponse.setVersion("6.2.0.1");
        String cmdName = cmd.getClass().getSimpleName();
        logger.debug("Processing command " + cmdName);
        String errMsg = "Unable to execute " + cmdName + "/" + i;
        Object cmdResult = null;
        try {
            if (cmd instanceof TaskCommand) {
                TaskCommand taskCmd = (TaskCommand)cmd;
                cmdResult = this.doTaskOperation(taskCmd.getTaskId(), request.getDeploymentId(), request.getProcessInstanceId(), null, taskCmd);
            } else if (cmd instanceof AuditCommand) {
                AuditCommand auditCmd = (AuditCommand)cmd;
                auditCmd.setAuditLogService(this.getAuditLogService());
                cmdResult = auditCmd.execute(null);
            } else {
                cmdResult = this.doKieSessionOperation(cmd, request.getDeploymentId(), request.getProcessInstanceId());
            }
        }
        catch (PermissionDeniedException pde) {
            logger.warn(errMsg, (Throwable)pde);
            jaxbResponse.addException((Exception)((Object)pde), i, cmd, JaxbRequestStatus.PERMISSIONS_CONFLICT);
        }
        catch (Exception e) {
            logger.warn(errMsg, (Throwable)e);
            jaxbResponse.addException(e, i, cmd, JaxbRequestStatus.FAILURE);
        }
        if (cmdResult != null) {
            try {
                jaxbResponse.addResult(cmdResult, i, cmd);
            }
            catch (Exception e) {
                errMsg = "Unable to add result from " + cmdName + "/" + i;
                logger.error(errMsg, (Throwable)e);
                jaxbResponse.addException(e, i, cmd, JaxbRequestStatus.FAILURE);
            }
        }
    }

    public Object doKieSessionOperation(Command<?> cmd, String deploymentId, Long processInstanceId) {
        if (deploymentId == null) {
            throw new org.kie.remote.services.exception.DeploymentNotFoundException("No deployment id supplied! Could not retrieve runtime to execute " + cmd.getClass().getSimpleName());
        }
        try {
            Object result = this.processService.execute(deploymentId, cmd);
            return result;
        }
        catch (ProcessInstanceNotFoundException e) {
            throw RestOperationException.notFound((String)("Process instance " + processInstanceId + " could not be found!"));
        }
        catch (DeploymentNotFoundException e) {
            throw RestOperationException.notFound((String)e.getMessage());
        }
        catch (RuntimeException re) {
            throw RestOperationException.internalServerError((String)re.getMessage(), (Exception)re);
        }
    }

    public Object getVariableObjectInstanceFromRuntime(String deploymentId, long processInstanceId, String varName) {
        String errorMsg = "Unable to retrieve variable '" + varName + "' from process instance " + processInstanceId;
        try {
            Object procVar = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), varName);
            return procVar;
        }
        catch (ProcessInstanceNotFoundException e) {
            throw RestOperationException.notFound((String)("Process instance " + processInstanceId + " could not be found!"));
        }
        catch (DeploymentNotFoundException e) {
            throw RestOperationException.notFound((String)e.getMessage());
        }
        catch (RuntimeException re) {
            throw RestOperationException.internalServerError((String)re.getMessage(), (Exception)re);
        }
    }

    private Object doTaskOperation(Long taskId, String deploymentId, Long processInstanceId, Task task, TaskCommand<?> cmd) {
        if (cmd instanceof GetTaskCommand || cmd instanceof GetContentCommand || cmd instanceof GetTaskContentCommand) {
            cmd = new ExecuteAndSerializeCommand(cmd);
        }
        try {
            return this.userTaskService.execute(deploymentId, (Command)cmd);
        }
        catch (TaskNotFoundException e) {
            throw RestOperationException.notFound((String)("Task " + taskId + " could not be found!"));
        }
        catch (ProcessInstanceNotFoundException e) {
            throw RestOperationException.notFound((String)("Process instance " + processInstanceId + " could not be found!"));
        }
        catch (DeploymentNotFoundException e) {
            throw RestOperationException.notFound((String)e.getMessage());
        }
        catch (RuntimeException re) {
            throw RestOperationException.internalServerError((String)re.getMessage(), (Exception)re);
        }
    }

    public Object doRestTaskOperation(Long taskId, String deploymentId, Long processInstanceId, Task task, TaskCommand<?> cmd) {
        try {
            return this.doTaskOperation(taskId, deploymentId, processInstanceId, task, cmd);
        }
        catch (PermissionDeniedException pde) {
            throw RestOperationException.conflict((String)pde.getMessage(), (Exception)((Object)pde));
        }
        catch (RuntimeException re) {
            throw re;
        }
    }
}

