/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.jms;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.bind.JAXBContext;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.identity.JAASUserGroupCallbackImpl;
import org.jbpm.services.task.identity.adapter.UserGroupAdapter;
import org.kie.api.command.Command;
import org.kie.remote.common.jaxb.JaxbRequestStatus;
import org.kie.remote.services.AcceptedCommands;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.remote.services.cdi.ProcessRequestBean;
import org.kie.remote.services.exception.KieRemoteServicesInternalError;
import org.kie.remote.services.exception.KieRemoteServicesRuntimeException;
import org.kie.remote.services.jaxb.JaxbCommandsRequest;
import org.kie.remote.services.jaxb.JaxbCommandsResponse;
import org.kie.remote.services.jms.RetryTrackerSingleton;
import org.kie.remote.services.jms.request.BackupIdentityProviderProducer;
import org.kie.remote.services.jms.security.JmsUserGroupAdapter;
import org.kie.remote.services.jms.security.UserPassCallbackHandler;
import org.kie.remote.services.rest.jaxb.DynamicJaxbContext;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.SerializationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMessageBean
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(RequestMessageBean.class);
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory factory;
    private Session session;
    private Connection connection;
    @Inject
    private RetryTrackerSingleton retryTracker;
    @Inject
    protected DeploymentInfoBean runtimeMgrMgr;
    @Inject
    protected ProcessRequestBean processRequestBean;
    @Inject
    private BackupIdentityProviderProducer backupIdentityProviderProducer;
    @Inject
    private DynamicJaxbContext dynamicJaxbContext;
    private String RESPONSE_QUEUE_NAME = null;
    private static String RESPONSE_QUEUE_NAME_PROPERTY = "kie.services.jms.queues.response";
    private static final String ID_NECESSARY = "This id is needed to be able to match a request to a response message.";
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";

    @PostConstruct
    public void init() {
        this.RESPONSE_QUEUE_NAME = System.getProperty(RESPONSE_QUEUE_NAME_PROPERTY, "queue/KIE.RESPONSE.ALL");
        try {
            this.connection = this.factory.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.connection.start();
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to open new session to send response messages";
            logger.error(errMsg, (Throwable)jmse);
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
    }

    @PreDestroy
    public void cleanup() {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to close " + (this.connection == null ? "session" : "connection");
            logger.error(errMsg, (Throwable)jmse);
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void onMessage(Message message) {
        SerializationProvider serializationProvider;
        String msgId = null;
        boolean redelivered = false;
        try {
            msgId = message.getJMSMessageID();
            redelivered = message.getJMSRedelivered();
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to retrieve JMS " + (msgId == null ? "redelivered flag" : "message id") + " from JMS message. Message will not be returned to queue.";
            logger.warn(errMsg, (Throwable)jmse);
        }
        if (redelivered) {
            if (this.retryTracker.maxRetriesReached(msgId)) {
                logger.warn("Maximum number of retries (" + this.retryTracker.getMaximumLimitRetries() + ") reached for message " + msgId);
                logger.warn("Acknowledging message but NOT processing it.");
                return;
            }
            logger.warn("Retry number " + this.retryTracker.incrementRetries(msgId) + " of message " + msgId);
        }
        String msgCorrId = null;
        JaxbCommandsResponse jaxbResponse = null;
        try {
            msgCorrId = message.getJMSCorrelationID();
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to retrieve JMS correlation id from message! This id is needed to be able to match a request to a response message.";
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
        int serializationType = -1;
        try {
            serializationType = !message.propertyExists("serialization") ? 0 : message.getIntProperty("serialization");
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to get properties from message " + msgCorrId + ".";
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
        switch (serializationType) {
            case 0: {
                serializationProvider = this.getJaxbSerializationProvider(message);
                break;
            }
            default: {
                throw new KieRemoteServicesInternalError("Unknown serialization type: " + serializationType);
            }
        }
        JaxbCommandsRequest cmdsRequest = RequestMessageBean.deserializeRequest(message, msgCorrId, serializationProvider, serializationType);
        this.backupIdentityProviderProducer.createBackupIdentityProvider(cmdsRequest.getUser());
        cmdsRequest.setUserPass(this.getUserPass(message));
        jaxbResponse = this.jmsProcessJaxbCommandsRequest(cmdsRequest);
        Message msg = RequestMessageBean.serializeResponse(this.session, msgCorrId, serializationType, serializationProvider, jaxbResponse);
        serializationProvider.dispose();
        this.sendResponse(msgCorrId, serializationType, msg);
        if (redelivered) {
            this.retryTracker.clearRetries(msgId);
        }
    }

    private void sendResponse(String msgCorrId, int serializationType, Message msg) {
        try {
            msg.setJMSCorrelationID(msgCorrId);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to set correlation id of response to msg id " + msgCorrId;
            logger.error(errMsg, (Throwable)jmse);
            return;
        }
        try {
            Queue responseQueue = (Queue)new InitialContext().lookup(this.RESPONSE_QUEUE_NAME);
            MessageProducer producer = this.session.createProducer((Destination)responseQueue);
            producer.send(msg);
        }
        catch (NamingException ne) {
            String errMsg = "Unable to lookup response queue " + this.RESPONSE_QUEUE_NAME + " to send msg " + msgCorrId + " (Is " + RESPONSE_QUEUE_NAME_PROPERTY + " incorrect?).";
            logger.error(errMsg, (Throwable)ne);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to send msg " + msgCorrId + " to " + this.RESPONSE_QUEUE_NAME;
            logger.error(errMsg, (Throwable)jmse);
        }
    }

    private static JaxbCommandsRequest deserializeRequest(Message message, String msgId, SerializationProvider serializationProvider, int serializationType) {
        JaxbCommandsRequest cmdMsg = null;
        try {
            String msgStrContent = null;
            switch (serializationType) {
                case 0: {
                    msgStrContent = ((BytesMessage)message).readUTF();
                    cmdMsg = (JaxbCommandsRequest)serializationProvider.deserialize(msgStrContent);
                    break;
                }
                default: {
                    throw new KieRemoteServicesRuntimeException("Unknown serialization type when deserializing message " + msgId + ":" + serializationType);
                }
            }
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to read information from message " + msgId + ".";
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
        catch (Exception e) {
            String errMsg = "Unable to serialize String to " + JaxbCommandsRequest.class.getSimpleName() + " [msg id: " + msgId + "].";
            throw new KieRemoteServicesInternalError(errMsg, e);
        }
        return cmdMsg;
    }

    private SerializationProvider getJaxbSerializationProvider(Message message) {
        JaxbSerializationProvider serializationProvider;
        try {
            if (message.propertyExists("deploymentId")) {
                String deploymentId = message.getStringProperty("deploymentId");
                DynamicJaxbContext.setDeploymentJaxbContext(deploymentId);
            } else {
                DynamicJaxbContext.setDeploymentJaxbContext("**DEFAULT");
            }
            serializationProvider = new JaxbSerializationProvider((JAXBContext)this.dynamicJaxbContext);
        }
        catch (JMSException jmse) {
            throw new KieRemoteServicesInternalError("Unable to check or read JMS message for property.", jmse);
        }
        catch (SerializationException se) {
            throw new KieRemoteServicesRuntimeException("Unable to load classes needed for JAXB deserialization.", se);
        }
        return serializationProvider;
    }

    private static Message serializeResponse(Session session, String msgId, int serializationType, SerializationProvider serializationProvider, JaxbCommandsResponse jaxbResponse) {
        BytesMessage byteMsg = null;
        try {
            String msgStr;
            byteMsg = session.createBytesMessage();
            byteMsg.setIntProperty("serialization", serializationType);
            switch (serializationType) {
                case 0: {
                    msgStr = serializationProvider.serialize((Object)jaxbResponse);
                    break;
                }
                default: {
                    throw new KieRemoteServicesRuntimeException("Unknown serialization type when deserializing message " + msgId + ":" + serializationType);
                }
            }
            byteMsg.writeUTF(msgStr);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to create response message or write to it [msg id: " + msgId + "].";
            throw new KieRemoteServicesRuntimeException(errMsg, jmse);
        }
        catch (Exception e) {
            String errMsg = "Unable to serialize " + jaxbResponse.getClass().getSimpleName() + " to a String.";
            throw new KieRemoteServicesInternalError(errMsg, e);
        }
        return byteMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JaxbCommandsResponse jmsProcessJaxbCommandsRequest(JaxbCommandsRequest request) {
        JaxbCommandsResponse jaxbResponse = new JaxbCommandsResponse(request);
        List<Command> commands = request.getCommands();
        if (commands != null) {
            UserGroupAdapter userGroupAdapter = null;
            try {
                for (int i = 0; i < commands.size(); ++i) {
                    Command cmd = commands.get(i);
                    if (!AcceptedCommands.getSet().contains(cmd.getClass())) {
                        String cmdName = cmd.getClass().getName();
                        String errMsg = cmdName + " is not a supported command and will not be executed.";
                        logger.warn(errMsg);
                        UnsupportedOperationException uoe = new UnsupportedOperationException(errMsg);
                        jaxbResponse.addException(uoe, i, cmd, JaxbRequestStatus.FORBIDDEN);
                        continue;
                    }
                    if (cmd instanceof TaskCommand && userGroupAdapter == null) {
                        userGroupAdapter = this.getUserFromMessageAndLookupAndInjectGroups(request.getUserPass());
                    }
                    this.processRequestBean.processCommand(cmd, request, i, jaxbResponse);
                }
            }
            finally {
                this.clearUserGroupAdapter(userGroupAdapter);
            }
        }
        if (commands == null || commands.isEmpty()) {
            logger.info("Commands request object with no commands sent!");
        }
        return jaxbResponse;
    }

    private UserGroupAdapter getUserFromMessageAndLookupAndInjectGroups(String[] userPass) {
        JmsUserGroupAdapter jmsUserGroupAdapter = null;
        try {
            if (userPass == null) {
                logger.warn("Unable to retrieve user and password from message: NOT injecting group information.");
                return null;
            }
            Subject msgSubject = this.tryLogin(userPass);
            if (msgSubject == null) {
                logger.warn("Unable to login to JAAS with received user and password.");
                return null;
            }
            List<Principal> roles = this.getGroupsFromSubject(msgSubject);
            String[] rolesArr = new String[roles.size()];
            for (int i = 0; i < rolesArr.length; ++i) {
                rolesArr[i] = roles.get(i).getName();
            }
            JmsUserGroupAdapter newUserGroupAdapter = new JmsUserGroupAdapter(userPass[0], rolesArr);
            JAASUserGroupCallbackImpl.addExternalUserGroupAdapter((UserGroupAdapter)newUserGroupAdapter);
            jmsUserGroupAdapter = newUserGroupAdapter;
        }
        catch (Exception e) {
            logger.warn("Unable to retrieve group information for user in message: " + e.getMessage(), (Throwable)e);
        }
        return jmsUserGroupAdapter;
    }

    private void clearUserGroupAdapter(UserGroupAdapter userGroupAdapter) {
        if (userGroupAdapter != null) {
            JAASUserGroupCallbackImpl.clearExternalUserGroupAdapter();
        }
    }

    private String[] getUserPass(Message msg) {
        String prop = USERNAME_PROPERTY;
        try {
            String user = null;
            String pass = null;
            if (msg.propertyExists(prop)) {
                user = msg.getStringProperty(prop);
            }
            if (msg.propertyExists(prop = PASSWORD_PROPERTY)) {
                pass = msg.getStringProperty(prop);
            }
            if (user != null && pass != null) {
                String[] userPass = new String[]{user, pass};
                return userPass;
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve '" + prop + "' from JMS message.", (Throwable)e);
        }
        return null;
    }

    private Subject tryLogin(String[] userPass) throws LoginException {
        try {
            UserPassCallbackHandler handler = new UserPassCallbackHandler(userPass);
            LoginContext lc = new LoginContext("kie-jms-login-context", handler);
            lc.login();
            return lc.getSubject();
        }
        catch (Exception e) {
            logger.error("Unable to login via JAAS with message supplied user and password", (Throwable)e);
            return null;
        }
    }

    private List<Principal> getGroupsFromSubject(Subject subject) {
        ArrayList<Principal> userGroups = new ArrayList<Principal>();
        for (Principal principal : subject.getPrincipals()) {
            if (!(principal instanceof Group) || !"Roles".equalsIgnoreCase(principal.getName())) continue;
            Enumeration groups = ((Group)principal).members();
            while (groups.hasMoreElements()) {
                Principal groupPrincipal = (Principal)groups.nextElement();
                userGroups.add(groupPrincipal);
            }
        }
        return userGroups;
    }
}

