/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.services.task.audit.commands.DeleteBAMTaskSummariesCommand;
import org.jbpm.services.task.commands.ActivateTaskCommand;
import org.jbpm.services.task.commands.ClaimNextAvailableTaskCommand;
import org.jbpm.services.task.commands.ClaimTaskCommand;
import org.jbpm.services.task.commands.CompleteTaskCommand;
import org.jbpm.services.task.commands.DelegateTaskCommand;
import org.jbpm.services.task.commands.ExitTaskCommand;
import org.jbpm.services.task.commands.FailTaskCommand;
import org.jbpm.services.task.commands.ForwardTaskCommand;
import org.jbpm.services.task.commands.GetContentCommand;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.jbpm.services.task.commands.GetTasksByVariousFieldsCommand;
import org.jbpm.services.task.commands.NominateTaskCommand;
import org.jbpm.services.task.commands.ReleaseTaskCommand;
import org.jbpm.services.task.commands.ResumeTaskCommand;
import org.jbpm.services.task.commands.SkipTaskCommand;
import org.jbpm.services.task.commands.StartTaskCommand;
import org.jbpm.services.task.commands.StopTaskCommand;
import org.jbpm.services.task.commands.SuspendTaskCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.impl.model.xml.JaxbContent;
import org.jbpm.services.task.impl.model.xml.JaxbTask;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.remote.common.exception.RestOperationException;
import org.kie.remote.services.jaxb.JaxbCommandsRequest;
import org.kie.remote.services.jaxb.JaxbCommandsResponse;
import org.kie.remote.services.jaxb.JaxbTaskSummaryListResponse;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.RuntimeResourceImpl;
import org.kie.remote.services.util.FormURLGenerator;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskFormResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/task")
@RequestScoped
public class TaskResourceImpl
extends ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeResourceImpl.class);
    @Context
    protected HttpHeaders headers;
    @Inject
    private FormURLGenerator formURLGenerator;
    @Inject
    protected IdentityProvider identityProvider;
    private static String[] allowedOperations = new String[]{"activate", "claim", "claimnextavailable", "complete", "delegate", "exit", "fail", "forward", "release", "resume", "skip", "start", "stop", "suspend", "nominate", "content"};
    private static String[] allowedQueryParams = new String[]{"workItemId", "taskId", "businessAdministrator", "potentialOwner", "status", "taskOwner", "processInstanceId", "language", "union"};

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return this.restProcessJaxbCommandsRequest(cmdsRequest);
    }

    @GET
    @Path(value="/query")
    public Response query() {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        for (String queryParam : params.keySet()) {
            boolean allowed = false;
            for (String allowedParam : allowedQueryParams) {
                if (!allowedParam.equalsIgnoreCase(queryParam) && !paginationParams.contains(queryParam)) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            throw RestOperationException.badRequest((String)(queryParam + " is an unknown and unsupported query param for the task query operation."));
        }
        List<Long> workItemIds = TaskResourceImpl.getLongListParam(allowedQueryParams[0], false, params, "query", true);
        List<Long> taskIds = TaskResourceImpl.getLongListParam(allowedQueryParams[1], false, params, "query", true);
        List<Long> procInstIds = TaskResourceImpl.getLongListParam(allowedQueryParams[6], false, params, "query", true);
        List<String> busAdmins = TaskResourceImpl.getStringListParamAsList(allowedQueryParams[2], false, params, "query");
        List<String> potOwners = TaskResourceImpl.getStringListParamAsList(allowedQueryParams[3], false, params, "query");
        List<String> taskOwners = TaskResourceImpl.getStringListParamAsList(allowedQueryParams[5], false, params, "query");
        List<String> language = TaskResourceImpl.getStringListParamAsList(allowedQueryParams[7], false, params, "query");
        String unionStr = TaskResourceImpl.getStringParam(allowedQueryParams[8], false, params, "query");
        boolean union = Boolean.parseBoolean(unionStr);
        List<String> statusStrList = TaskResourceImpl.getStringListParamAsList(allowedQueryParams[4], false, params, "query");
        List<Status> statuses = TaskResourceImpl.convertStringListToStatusList(statusStrList);
        int[] pageInfo = TaskResourceImpl.getPageNumAndPageSize(params, oper);
        int maxResults = TaskResourceImpl.getMaxNumResultsNeeded(pageInfo);
        GetTasksByVariousFieldsCommand queryCmd = new GetTasksByVariousFieldsCommand(workItemIds, taskIds, procInstIds, busAdmins, potOwners, taskOwners, statuses, language, union, Integer.valueOf(maxResults));
        List results = (List)this.doRestTaskOperation(null, (TaskCommand<?>)queryCmd);
        logger.debug("{} results found.", (Object)results.size());
        JaxbTaskSummaryListResponse resultList = TaskResourceImpl.paginateAndCreateResult(pageInfo, results, new JaxbTaskSummaryListResponse());
        logger.debug("Returning {} results after pagination.", (Object)resultList.getList().size());
        return TaskResourceImpl.createCorrectVariant((Object)resultList, this.headers);
    }

    @GET
    @Path(value="/{taskId: [0-9-]+}")
    public Response taskId(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        JaxbTask task = (JaxbTask)this.doRestTaskOperation(taskId, (TaskCommand<?>)cmd);
        if (task == null) {
            throw RestOperationException.notFound((String)("Task " + taskId + " could not be found."));
        }
        return TaskResourceImpl.createCorrectVariant(task, this.headers);
    }

    @POST
    @Path(value="/{taskId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public Response taskId_oper(@PathParam(value="taskId") long taskId, @PathParam(value="oper") String operation) {
        Map<String, String[]> params = this.getRequestParams();
        operation = TaskResourceImpl.checkThatOperationExists(operation, allowedOperations);
        String oper = this.getRelativePath();
        String userId = this.identityProvider.getName();
        logger.debug("Executing " + operation + " on task " + taskId + " by user " + userId);
        ActivateTaskCommand cmd = null;
        if ("activate".equalsIgnoreCase(operation)) {
            cmd = new ActivateTaskCommand(taskId, userId);
        } else if ("claim".equalsIgnoreCase(operation)) {
            cmd = new ClaimTaskCommand(taskId, userId);
        } else if ("claimnextavailable".equalsIgnoreCase(operation)) {
            cmd = new ClaimNextAvailableTaskCommand(userId);
        } else if ("complete".equalsIgnoreCase(operation)) {
            Map<String, Object> data = TaskResourceImpl.extractMapFromParams(params, operation);
            cmd = new CompleteTaskCommand(taskId, userId, data);
        } else if ("delegate".equalsIgnoreCase(operation)) {
            String targetEntityId = TaskResourceImpl.getStringParam("targetEntityId", true, params, oper);
            cmd = new DelegateTaskCommand(taskId, userId, targetEntityId);
        } else if ("exit".equalsIgnoreCase(operation)) {
            cmd = new ExitTaskCommand(taskId, userId);
        } else if ("fail".equalsIgnoreCase(operation)) {
            Map<String, Object> data = TaskResourceImpl.extractMapFromParams(params, oper);
            cmd = new FailTaskCommand(taskId, userId, data);
        } else if ("forward".equalsIgnoreCase(operation)) {
            String targetEntityId = TaskResourceImpl.getStringParam("targetEntityId", true, params, oper);
            cmd = new ForwardTaskCommand(taskId, userId, targetEntityId);
        } else if ("release".equalsIgnoreCase(operation)) {
            cmd = new ReleaseTaskCommand(taskId, userId);
        } else if ("resume".equalsIgnoreCase(operation)) {
            cmd = new ResumeTaskCommand(taskId, userId);
        } else if ("skip".equalsIgnoreCase(operation)) {
            cmd = new SkipTaskCommand(taskId, userId);
        } else if ("start".equalsIgnoreCase(operation)) {
            cmd = new StartTaskCommand(taskId, userId);
        } else if ("stop".equalsIgnoreCase(operation)) {
            cmd = new StopTaskCommand(taskId, userId);
        } else if ("suspend".equalsIgnoreCase(operation)) {
            cmd = new SuspendTaskCommand(taskId, userId);
        } else if ("nominate".equalsIgnoreCase(operation)) {
            List<OrganizationalEntity> potentialOwners = TaskResourceImpl.getOrganizationalEntityListFromParams(params, true, oper);
            cmd = new NominateTaskCommand(taskId, userId, potentialOwners);
        } else {
            throw RestOperationException.badRequest((String)("Unsupported operation: " + oper));
        }
        this.doRestTaskOperation(taskId, (TaskCommand<?>)cmd);
        return TaskResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    private static String checkThatOperationExists(String operation, String[] possibleOperations) {
        for (String oper : possibleOperations) {
            if (!oper.equals(operation.trim().toLowerCase())) continue;
            return oper;
        }
        throw RestOperationException.badRequest((String)("Operation '" + operation + "' is not supported on tasks."));
    }

    @GET
    @Path(value="/{taskId: [0-9-]+}/content")
    public Response taskId_content(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        Object result = this.doRestTaskOperation(taskId, (TaskCommand<?>)cmd);
        if (result == null) {
            throw RestOperationException.notFound((String)("Task " + taskId + " could not be found."));
        }
        Task task = (Task)result;
        long contentId = task.getTaskData().getDocumentContentId();
        JaxbContent content = null;
        if (contentId <= -1L) {
            throw RestOperationException.notFound((String)("Content for task " + taskId + " could not be found."));
        }
        cmd = new GetContentCommand(Long.valueOf(contentId));
        result = this.processRequestBean.doRestTaskOperation(taskId, task.getTaskData().getDeploymentId(), task.getTaskData().getProcessInstanceId(), task, (TaskCommand<?>)cmd);
        content = (JaxbContent)result;
        return TaskResourceImpl.createCorrectVariant(content, this.headers);
    }

    @GET
    @Path(value="/{taskId: [0-9-]+}/showTaskForm")
    public Response taskId_form(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        Object result = this.doRestTaskOperation(taskId, (TaskCommand<?>)cmd);
        if (result != null) {
            String formUrl;
            String opener = "";
            List openers = this.headers.getRequestHeader("host");
            if (openers.size() == 1) {
                opener = (String)openers.get(0);
            }
            if (!StringUtils.isEmpty((CharSequence)(formUrl = this.formURLGenerator.generateFormTaskURL(this.getBaseUri(), taskId, opener)))) {
                JaxbTaskFormResponse response = new JaxbTaskFormResponse(formUrl, this.getRequestUri());
                return TaskResourceImpl.createCorrectVariant(response, this.headers);
            }
        }
        throw RestOperationException.notFound((String)("Task " + taskId + " could not be found."));
    }

    @GET
    @Path(value="/content/{contentId: [0-9-]+}")
    public Response content_contentId(@PathParam(value="contentId") long contentId) {
        GetContentCommand cmd = new GetContentCommand(Long.valueOf(contentId));
        JaxbContent content = (JaxbContent)this.doRestTaskOperation(null, (TaskCommand<?>)cmd);
        if (content == null) {
            throw RestOperationException.notFound((String)("Content " + contentId + " could not be found."));
        }
        return TaskResourceImpl.createCorrectVariant(new JaxbContent((Content)content), this.headers);
    }

    @POST
    @Path(value="/history/bam/clear")
    public Response bam_clear() {
        this.doRestTaskOperation(null, (TaskCommand<?>)new DeleteBAMTaskSummariesCommand());
        return TaskResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRelativePath()), this.headers);
    }

    private Object doRestTaskOperation(Long taskId, TaskCommand<?> cmd) {
        return this.processRequestBean.doRestTaskOperation(taskId, null, null, null, cmd);
    }
}

