/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jbpm.process.audit.VariableInstanceLog;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.api.HistoryResource;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbProcessInstanceLog;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;

@Path(value="/history")
@RequestScoped
public class HistoryResourceImpl
extends ResourceBase
implements HistoryResource {
    @Context
    private HttpHeaders headers;

    @POST
    @Path(value="/clear")
    public Response clear() {
        this.getAuditLogService().clear();
        return HistoryResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    @GET
    @Path(value="/instances")
    public Response instances() {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        List procInstLogResults = this.getAuditLogService().findProcessInstances();
        ArrayList results = new ArrayList(procInstLogResults);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/instance/{procInstId: [0-9]+}")
    public Response instance_procInstId(@PathParam(value="procInstId") long procInstId) {
        org.jbpm.process.audit.ProcessInstanceLog procInstLog = this.getAuditLogService().findProcessInstance(procInstId);
        JaxbProcessInstanceLog jaxbProcLog = new JaxbProcessInstanceLog((ProcessInstanceLog)procInstLog);
        return HistoryResourceImpl.createCorrectVariant(jaxbProcLog, this.headers);
    }

    @GET
    @Path(value="/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}")
    public Response instance_procInstid_oper(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List result = null;
        if ("child".equalsIgnoreCase(operation)) {
            result = this.getAuditLogService().findSubProcessInstances(procInstId.longValue());
        } else if ("node".equalsIgnoreCase(operation)) {
            result = this.getAuditLogService().findNodeInstances(procInstId.longValue());
        } else if ("variable".equalsIgnoreCase(operation)) {
            result = this.getAuditLogService().findVariableInstances(procInstId.longValue());
        } else {
            throw KieRemoteRestOperationException.badRequest("Unsupported operation: " + oper);
        }
        List varInstLogList = result;
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, varInstLogList, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}/{logId: [a-zA-Z0-9-:\\._]+}")
    public Response instance_procInstId_oper_logId(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation, @PathParam(value="logId") String logId) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List result = null;
        if ("node".equalsIgnoreCase(operation)) {
            result = this.getAuditLogService().findNodeInstances(procInstId.longValue(), logId);
        } else if ("variable".equalsIgnoreCase(operation)) {
            result = this.getAuditLogService().findVariableInstances(procInstId.longValue(), logId);
        } else {
            throw KieRemoteRestOperationException.badRequest("Unsupported operation: " + oper);
        }
        List varInstLogList = result;
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, varInstLogList, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/process/{processDefId: [a-zA-Z0-9-:\\._]+}")
    public Response process_procDefId(@PathParam(value="processDefId") String processId) {
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> procInstLogList;
        Map<String, String[]> params = this.getRequestParams();
        Number statusParam = HistoryResourceImpl.getNumberParam("status", false, params, this.getRelativePath(), false);
        String oper = this.getRelativePath();
        int[] pageInfo = HistoryResourceImpl.getPageNumAndPageSize(params, oper);
        List<Object> result = statusParam != null ? (statusParam.intValue() == 1 ? this.getAuditLogService().findActiveProcessInstances(processId) : this.getAuditLogService().findProcessInstances(processId)) : this.getAuditLogService().findProcessInstances(processId);
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> filteredProcLogList = procInstLogList = result;
        if (statusParam != null && !statusParam.equals(1)) {
            filteredProcLogList = new ArrayList<org.jbpm.process.audit.ProcessInstanceLog>();
            for (int i = 0; i < procInstLogList.size() && filteredProcLogList.size() < HistoryResourceImpl.getMaxNumResultsNeeded(pageInfo); ++i) {
                org.jbpm.process.audit.ProcessInstanceLog procLog = (org.jbpm.process.audit.ProcessInstanceLog)procInstLogList.get(i);
                if (!procLog.getStatus().equals(statusParam.intValue())) continue;
                filteredProcLogList.add(procLog);
            }
        }
        ArrayList results = new ArrayList(filteredProcLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(pageInfo, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/variable/{varId: [a-zA-Z0-9-:\\._]+}")
    public Response variable_varId(@PathParam(value="varId") String variableId) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, null, params, oper);
        ArrayList<VariableInstanceLog> results = new ArrayList<VariableInstanceLog>(varLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/variable/{varId: [a-zA-Z0-9-:\\._]+}/value/{value: [a-zA-Z0-9-:\\._]+}")
    public Response variable_varId_value_valueVal(@PathParam(value="varId") String variableId, @PathParam(value="value") String value) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, value, params, oper);
        ArrayList<VariableInstanceLog> results = new ArrayList<VariableInstanceLog>(varLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/variable/{varId: [a-zA-Z0-9-:\\._]+}/instances")
    public Response variable_varId_instances(@PathParam(value="varId") String variableId) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, null, params, oper);
        int[] pageInfo = HistoryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxNumResults = HistoryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        List<org.jbpm.process.audit.ProcessInstanceLog> procInstLogList = this.getProcessInstanceLogsByVariable(varLogList, maxNumResults);
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> results = new ArrayList<org.jbpm.process.audit.ProcessInstanceLog>(procInstLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(pageInfo, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/variable/{varId: [a-zA-Z0-9-:\\.]+}/value/{value: [a-zA-Z0-9-:\\._]+}/instances")
    public Response variable_varId_value_valueVal_instances(@PathParam(value="varId") String variableId, @PathParam(value="value") String value) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, value, params, oper);
        int[] pageInfo = HistoryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxNumResults = HistoryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        List<org.jbpm.process.audit.ProcessInstanceLog> procInstLogList = this.getProcessInstanceLogsByVariable(varLogList, maxNumResults);
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> results = new ArrayList<org.jbpm.process.audit.ProcessInstanceLog>(procInstLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(pageInfo, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    private List<VariableInstanceLog> internalGetVariableInstancesByVarAndValue(String varId, String value, Map<String, String[]> params, String oper) {
        String activeProcsParam = HistoryResourceImpl.getStringParam("activeProcesses", false, params, oper);
        boolean onlyActiveProcesses = false;
        if (activeProcsParam != null) {
            onlyActiveProcesses = Boolean.parseBoolean(activeProcsParam);
        }
        List result = value == null ? this.getAuditLogService().findVariableInstancesByName(varId, onlyActiveProcesses) : this.getAuditLogService().findVariableInstancesByNameAndValue(varId, value, onlyActiveProcesses);
        return result;
    }

    private List<org.jbpm.process.audit.ProcessInstanceLog> getProcessInstanceLogsByVariable(List<VariableInstanceLog> varLogList, int maxNumResults) {
        int numVarLogs = varLogList.size();
        int numProcInsts = 0;
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> resultList = new ArrayList<org.jbpm.process.audit.ProcessInstanceLog>();
        for (int i = 0; i < numVarLogs && numProcInsts < maxNumResults; ++i) {
            long procInstId = varLogList.get(i).getProcessInstanceId();
            org.jbpm.process.audit.ProcessInstanceLog procInstlog = this.getAuditLogService().findProcessInstance(procInstId);
            if (procInstlog == null) continue;
            resultList.add(procInstlog);
            ++numProcInsts;
        }
        return resultList;
    }
}

