/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.services.task.commands.GetTasksByVariousFieldsCommand;
import org.jbpm.services.task.commands.TaskQueryDataCommand;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.data.QueryData;
import org.kie.remote.services.jaxb.JaxbTaskSummaryListResponse;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.QueryResourceData;
import org.kie.remote.services.rest.query.RemoteServicesQueryCommandBuilder;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstance;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryProcessInstanceInfo;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryProcessInstanceResult;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryTaskInfo;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryTaskResult;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbVariableInfo;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskSummary;

@RequestScoped
@Path(value="/query/")
public class QueryResourceImpl
extends ResourceBase {
    @Context
    private HttpHeaders headers;
    @Inject
    private IdentityProvider identityProvider;
    private static final String[] allowedQueryParams = new String[]{"workItemId", "taskId", "businessAdministrator", "potentialOwner", "status", "taskOwner", "processInstanceId", "language", "union"};

    void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    @GET
    @Path(value="/runtime/task")
    public Response queryTasks() {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        int[] pageInfo = QueryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxNumResults = QueryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        JaxbQueryTaskResult result = this.queryTasksAndVariables(params, pageInfo, maxNumResults);
        return QueryResourceImpl.createCorrectVariant(result, this.headers);
    }

    @GET
    @Path(value="/runtime/process")
    public Response queryProcessInstances() {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        int[] pageInfo = QueryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxNumResults = QueryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        JaxbQueryProcessInstanceResult result = this.queryProcessInstancesAndVariables(params, pageInfo, maxNumResults);
        return QueryResourceImpl.createCorrectVariant(null, this.headers);
    }

    JaxbQueryTaskResult queryTasksAndVariables(Map<String, String[]> queryParams, int[] pageInfo, int maxResults) {
        ArrayDeque<ActionData> actionDataQueue = new ArrayDeque<ActionData>();
        for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
            Integer action;
            String orig_param = entry.getKey();
            if (paginationParams.contains(orig_param)) continue;
            String[] paramParts = orig_param.split("_");
            String param = paramParts[0];
            if (paramParts.length >= 2) {
                if (paramParts.length > 2) {
                    throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
                }
                action = QueryResourceData.paramNameActionMap.get(paramParts[0]);
                if (action == null) {
                    throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
                }
                ActionData actionData = new ActionData(orig_param, action, entry.getValue());
                actionDataQueue.add(actionData);
                if ("min".equals(paramParts[1])) {
                    actionData.min = true;
                    continue;
                }
                if ("max".equals(paramParts[1])) {
                    actionData.max = true;
                    continue;
                }
                if ("re".equals(paramParts[1])) {
                    actionData.regex = true;
                    continue;
                }
                throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
            }
            action = QueryResourceData.paramNameActionMap.get(param);
            if (action != null) {
                actionDataQueue.add(new ActionData(orig_param, action, entry.getValue()));
                continue;
            }
            throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
        }
        Boolean workFlowInstanceVariables = null;
        if (queryParams.containsKey(QueryResourceData.metaRuntimeParams[0]) || queryParams.containsKey(QueryResourceData.metaRuntimeParamsShort[0])) {
            workFlowInstanceVariables = true;
            queryParams.remove(QueryResourceData.metaRuntimeParams[0]);
            queryParams.remove(QueryResourceData.metaRuntimeParamsShort[0]);
        }
        if (queryParams.containsKey(QueryResourceData.metaRuntimeParams[1]) || queryParams.containsKey(QueryResourceData.metaRuntimeParamsShort[1])) {
            if (workFlowInstanceVariables.booleanValue()) {
                throw KieRemoteRestOperationException.badRequest("Only one of the 'memory' and 'history' query parameters may be specified.");
            }
            workFlowInstanceVariables = false;
            queryParams.remove(QueryResourceData.metaRuntimeParams[1]);
            queryParams.remove(QueryResourceData.metaRuntimeParamsShort[1]);
        }
        if (workFlowInstanceVariables == null) {
            workFlowInstanceVariables = false;
        }
        RemoteServicesQueryCommandBuilder taskQueryBuilder = new RemoteServicesQueryCommandBuilder(this.identityProvider.getName());
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        if (workFlowInstanceVariables.booleanValue()) {
            HashMap hashMap = new HashMap();
        }
        varInstLogQueryBuilder.last();
        while (!actionDataQueue.isEmpty()) {
            ActionData actionData = (ActionData)actionDataQueue.poll();
            String[] data = actionData.data;
            int action = actionData.action;
            switch (action) {
                case 0: {
                    assert ("processinstanceid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstanceid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    taskQueryBuilder.processInstanceId(longData);
                    varInstLogQueryBuilder.processInstanceId(longData);
                    break;
                }
                case 1: {
                    assert ("processid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processid";
                    QueryResourceImpl.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.processId(data);
                    varInstLogQueryBuilder.processId(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 2: {
                    assert ("workitemid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : workitemid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    taskQueryBuilder.workItemId(longData);
                    varInstLogQueryBuilder.workItemId(longData);
                    break;
                }
                case 3: {
                    assert ("deploymentid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : deploymentid";
                    taskQueryBuilder.deploymentId(data);
                    varInstLogQueryBuilder.deploymentId(data);
                    break;
                }
                case 4: {
                    assert ("taskid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : taskid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    taskQueryBuilder.taskId(longData);
                    varInstLogQueryBuilder.taskId(longData);
                    break;
                }
                case 5: {
                    assert ("initiator".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : initiator";
                    QueryResourceImpl.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.initiator(data);
                    varInstLogQueryBuilder.initiator(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 6: {
                    assert ("stakeholder".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : stakeholder";
                    QueryResourceImpl.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.stakeHolder(data);
                    varInstLogQueryBuilder.stakeHolder(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 7: {
                    assert ("potentialowner".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : potentialowner";
                    taskQueryBuilder.potentialOwner(data);
                    varInstLogQueryBuilder.potentialOwner(data);
                    break;
                }
                case 8: {
                    assert ("taskowner".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : taskowner";
                    taskQueryBuilder.taskOwner(data);
                    varInstLogQueryBuilder.taskOwner(data);
                    break;
                }
                case 9: {
                    assert ("businessadmin".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : businessadmin";
                    taskQueryBuilder.businessAdmin(data);
                    varInstLogQueryBuilder.businessAdmin(data);
                    break;
                }
                case 10: {
                    assert ("taskstatus".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : taskstatus";
                    Status[] statuses = QueryResourceData.getTaskStatuses(data);
                    taskQueryBuilder.taskStatus(statuses);
                    varInstLogQueryBuilder.taskStatus(statuses);
                    break;
                }
                case 11: {
                    assert ("processinstancestatus".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstancestatus";
                    int[] intData = QueryResourceData.getInts(action, data);
                    taskQueryBuilder.processInstanceStatus(intData);
                    varInstLogQueryBuilder.processInstanceStatus(intData);
                    break;
                }
                case 12: {
                    assert ("processversion".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processversion";
                    QueryResourceImpl.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.processVersion(data);
                    varInstLogQueryBuilder.processVersion(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 13: {
                    assert ("startdate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : startdate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (actionData.min || actionData.max) {
                        if (dateData.length != 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.param + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            taskQueryBuilder.startDateMin(dateData[0]);
                            varInstLogQueryBuilder.startDateMin(dateData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        taskQueryBuilder.startDateMax(dateData[0]);
                        varInstLogQueryBuilder.startDateMax(dateData[0]);
                        actionData.max = false;
                        break;
                    }
                    taskQueryBuilder.startDate(dateData);
                    varInstLogQueryBuilder.startDate(dateData);
                    break;
                }
                case 14: {
                    assert ("enddate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : enddate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (actionData.min || actionData.max) {
                        if (dateData.length > 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.param + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            taskQueryBuilder.endDateMin(dateData[0]);
                            varInstLogQueryBuilder.endDateMin(dateData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        taskQueryBuilder.endDateMax(dateData[0]);
                        varInstLogQueryBuilder.endDateMax(dateData[0]);
                        actionData.max = false;
                        break;
                    }
                    taskQueryBuilder.startDate(dateData);
                    varInstLogQueryBuilder.startDate(dateData);
                    break;
                }
                case 15: {
                    assert ("varid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varid";
                    if (actionData.regex && workFlowInstanceVariables.booleanValue()) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter " + "when retrieving in-memory process variables");
                    }
                    QueryResourceImpl.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.variableId(data);
                    varInstLogQueryBuilder.last().variableId(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 16: {
                    assert ("varvalue".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varvalue";
                    if (actionData.regex && workFlowInstanceVariables.booleanValue()) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter " + "when retrieving in-memory process variables");
                    }
                    QueryResourceImpl.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.value(data);
                    varInstLogQueryBuilder.value(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                default: {
                    throw KieRemoteRestOperationException.internalServerError("Please contact the developers: this state should not be possible.");
                }
            }
            if (!actionData.min && !actionData.max && !actionData.regex) continue;
            throw KieRemoteRestOperationException.notFound("Query parameter '" + actionData.param + "' is not supported.");
        }
        TaskQueryDataCommand taskCmd = taskQueryBuilder.createTaskQueryDataCommand();
        List taskSummaries = (List)this.doRestTaskOperation(taskCmd);
        QueryData varLogQueryData = varInstLogQueryBuilder.getQueryData();
        List varLogs = this.getAuditLogService().queryVariableInstanceLogs(varLogQueryData);
        List<JaxbVariableInfo> procVars = null;
        if (workFlowInstanceVariables.booleanValue()) {
            for (VariableInstanceLog varLog : varLogs) {
            }
        }
        JaxbQueryTaskResult result = QueryResourceImpl.createQueryTaskResult(taskSummaries, varLogs, procVars);
        return result;
    }

    private static void setRegexOnOff(ActionData actionData, boolean on, RemoteServicesQueryCommandBuilder ... queryCmdBuilders) {
        if (actionData.regex) {
            if (on) {
                for (RemoteServicesQueryCommandBuilder queryCmdBuilder : queryCmdBuilders) {
                    queryCmdBuilder.like();
                }
            } else {
                for (RemoteServicesQueryCommandBuilder queryCmdBuilder : queryCmdBuilders) {
                    queryCmdBuilder.equals();
                }
                actionData.regex = false;
            }
        }
    }

    private static JaxbQueryTaskResult createQueryTaskResult(List<TaskSummary> taskSummaries, List<VariableInstanceLog> varLogs, List<JaxbVariableInfo> processVariables) {
        JaxbQueryTaskInfo taskInfo;
        long procInstId;
        JaxbQueryTaskResult result = new JaxbQueryTaskResult();
        HashMap<Long, JaxbQueryTaskInfo> procInstIdTaskInfoMap = new HashMap<Long, JaxbQueryTaskInfo>();
        for (TaskSummary taskSum : taskSummaries) {
            procInstId = taskSum.getProcessInstanceId();
            taskInfo = QueryResourceImpl.getQueryTaskInfo(procInstId, procInstIdTaskInfoMap);
            taskInfo.getTaskSummaries().add(new JaxbTaskSummary(taskSum));
        }
        for (VariableInstanceLog varLog : varLogs) {
            procInstId = varLog.getProcessInstanceId();
            taskInfo = QueryResourceImpl.getQueryTaskInfo(procInstId, procInstIdTaskInfoMap);
            taskInfo.getVariables().add(new JaxbVariableInfo(varLog));
        }
        result.getTaskInfoList().addAll(procInstIdTaskInfoMap.values());
        return result;
    }

    private static JaxbQueryProcessInstanceInfo getQueryProcessInstanceInfo(long procInstId, Map<Long, JaxbQueryProcessInstanceInfo> procInstIdProcInstInfoMap) {
        JaxbQueryProcessInstanceInfo procInstInfo = procInstIdProcInstInfoMap.get(procInstId);
        if (procInstInfo == null) {
            procInstInfo = new JaxbQueryProcessInstanceInfo();
            procInstIdProcInstInfoMap.put(procInstId, procInstInfo);
        }
        return procInstInfo;
    }

    private static JaxbQueryTaskInfo getQueryTaskInfo(long procInstId, Map<Long, JaxbQueryTaskInfo> procInstIdTaskInfoMap) {
        JaxbQueryTaskInfo taskInfo = procInstIdTaskInfoMap.get(procInstId);
        if (taskInfo == null) {
            taskInfo = new JaxbQueryTaskInfo(procInstId);
            procInstIdTaskInfoMap.put(procInstId, taskInfo);
        }
        return taskInfo;
    }

    JaxbQueryProcessInstanceResult queryProcessInstancesAndVariables(Map<String, String[]> queryParams, int[] pageInfo, int maxResults) {
        ActionData actionData;
        ArrayDeque<ActionData> actionDataQueue = new ArrayDeque<ActionData>();
        for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
            Integer action;
            String orig_param = entry.getKey();
            if (paginationParams.contains(orig_param)) continue;
            String[] paramParts = orig_param.split("_");
            String param = paramParts[0];
            if (paramParts.length >= 2) {
                if (paramParts.length > 2) {
                    throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
                }
                action = QueryResourceData.paramNameActionMap.get(paramParts[0]);
                if (action == null) {
                    throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
                }
                actionData = new ActionData(orig_param, action, entry.getValue());
                actionDataQueue.add(actionData);
                if ("min".equals(paramParts[1])) {
                    actionData.min = true;
                    continue;
                }
                if ("max".equals(paramParts[1])) {
                    actionData.max = true;
                    continue;
                }
                if ("re".equals(paramParts[1])) {
                    actionData.regex = true;
                    continue;
                }
                throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
            }
            action = QueryResourceData.paramNameActionMap.get(param);
            if (action != null) {
                actionDataQueue.add(new ActionData(orig_param, action, entry.getValue()));
                continue;
            }
            throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
        }
        Boolean workFlowInstanceVariables = null;
        if (queryParams.containsKey(QueryResourceData.metaRuntimeParams[0]) || queryParams.containsKey(QueryResourceData.metaRuntimeParamsShort[0])) {
            workFlowInstanceVariables = true;
            queryParams.remove(QueryResourceData.metaRuntimeParams[0]);
            queryParams.remove(QueryResourceData.metaRuntimeParamsShort[0]);
        }
        if (queryParams.containsKey(QueryResourceData.metaRuntimeParams[1]) || queryParams.containsKey(QueryResourceData.metaRuntimeParamsShort[1])) {
            if (workFlowInstanceVariables.booleanValue()) {
                throw KieRemoteRestOperationException.badRequest("Only one of the 'memory' and 'history' query parameters may be specified.");
            }
            workFlowInstanceVariables = false;
            queryParams.remove(QueryResourceData.metaRuntimeParams[1]);
            queryParams.remove(QueryResourceData.metaRuntimeParamsShort[1]);
        }
        if (workFlowInstanceVariables == null) {
            workFlowInstanceVariables = false;
        }
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        if (workFlowInstanceVariables.booleanValue()) {
            HashMap hashMap = new HashMap();
        }
        varInstLogQueryBuilder.last();
        while (!actionDataQueue.isEmpty()) {
            actionData = (ActionData)actionDataQueue.poll();
            String[] data = actionData.data;
            int action = actionData.action;
            switch (action) {
                case 0: {
                    assert ("processinstanceid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstanceid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    varInstLogQueryBuilder.processInstanceId(longData);
                    break;
                }
                case 1: {
                    assert ("processid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processid";
                    QueryResourceImpl.setRegexOnOff(actionData, true, varInstLogQueryBuilder);
                    varInstLogQueryBuilder.processId(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, varInstLogQueryBuilder);
                    break;
                }
                case 2: {
                    assert ("workitemid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : workitemid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    varInstLogQueryBuilder.workItemId(longData);
                    break;
                }
                case 3: {
                    assert ("deploymentid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : deploymentid";
                    varInstLogQueryBuilder.deploymentId(data);
                    break;
                }
                case 11: {
                    assert ("processinstancestatus".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstancestatus";
                    int[] intData = QueryResourceData.getInts(action, data);
                    varInstLogQueryBuilder.processInstanceStatus(intData);
                    break;
                }
                case 12: {
                    assert ("processversion".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processversion";
                    QueryResourceImpl.setRegexOnOff(actionData, true, varInstLogQueryBuilder);
                    varInstLogQueryBuilder.processVersion(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, varInstLogQueryBuilder);
                    break;
                }
                case 13: {
                    assert ("startdate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : startdate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (actionData.min || actionData.max) {
                        if (dateData.length != 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.param + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            varInstLogQueryBuilder.startDateMin(dateData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        varInstLogQueryBuilder.startDateMax(dateData[0]);
                        actionData.max = false;
                        break;
                    }
                    varInstLogQueryBuilder.startDate(dateData);
                    break;
                }
                case 14: {
                    assert ("enddate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : enddate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (actionData.min || actionData.max) {
                        if (dateData.length > 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.param + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            varInstLogQueryBuilder.endDateMin(dateData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        varInstLogQueryBuilder.endDateMax(dateData[0]);
                        actionData.max = false;
                        break;
                    }
                    varInstLogQueryBuilder.startDate(dateData);
                    break;
                }
                case 15: {
                    assert ("varid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varid";
                    if (actionData.regex && workFlowInstanceVariables.booleanValue()) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter " + "when retrieving in-memory process variables");
                    }
                    QueryResourceImpl.setRegexOnOff(actionData, true, varInstLogQueryBuilder);
                    varInstLogQueryBuilder.variableId(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, varInstLogQueryBuilder);
                    varInstLogQueryBuilder.last();
                    break;
                }
                case 16: {
                    assert ("varvalue".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varvalue";
                    if (actionData.regex && workFlowInstanceVariables.booleanValue()) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter " + "when retrieving in-memory process variables");
                    }
                    QueryResourceImpl.setRegexOnOff(actionData, true, varInstLogQueryBuilder);
                    varInstLogQueryBuilder.value(data);
                    QueryResourceImpl.setRegexOnOff(actionData, false, varInstLogQueryBuilder);
                    break;
                }
                default: {
                    throw KieRemoteRestOperationException.internalServerError("Please contact the developers: this state should not be possible.");
                }
            }
            if (!actionData.min && !actionData.max && !actionData.regex) continue;
            throw KieRemoteRestOperationException.notFound("Query parameter '" + actionData.param + "' is not supported.");
        }
        QueryData queryData = varInstLogQueryBuilder.getQueryData();
        List varLogs = this.getAuditLogService().queryVariableInstanceLogs(queryData);
        List procLogs = this.getAuditLogService().queryProcessInstanceLogs(queryData);
        List<JaxbVariableInfo> procVars = null;
        JaxbQueryProcessInstanceResult result = QueryResourceImpl.createProcessInstanceResult(procLogs, varLogs, procVars);
        return result;
    }

    private static JaxbQueryProcessInstanceResult createProcessInstanceResult(List<ProcessInstanceLog> procLogs, List<VariableInstanceLog> varLogs, List<JaxbVariableInfo> processVariables) {
        JaxbQueryProcessInstanceInfo taskInfo;
        long procInstId;
        JaxbQueryProcessInstanceResult result = new JaxbQueryProcessInstanceResult();
        HashMap<Long, JaxbQueryProcessInstanceInfo> procInstIdProcInstInfoMap = new HashMap<Long, JaxbQueryProcessInstanceInfo>();
        for (ProcessInstanceLog procLog : procLogs) {
            procInstId = procLog.getProcessInstanceId();
            taskInfo = QueryResourceImpl.getQueryProcessInstanceInfo(procInstId, procInstIdProcInstInfoMap);
            taskInfo.setProcessInstance(new JaxbProcessInstance(procLog));
        }
        for (VariableInstanceLog varLog : varLogs) {
            procInstId = varLog.getProcessInstanceId();
            taskInfo = QueryResourceImpl.getQueryProcessInstanceInfo(procInstId, procInstIdProcInstInfoMap);
            taskInfo.getVariables().add(new JaxbVariableInfo(varLog));
        }
        result.getProcessInstanceInfoList().addAll(procInstIdProcInstInfoMap.values());
        return result;
    }

    @GET
    @Path(value="/task")
    public Response taskSummaryQuery() {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        for (String queryParam : params.keySet()) {
            boolean allowed = false;
            for (String allowedParam : allowedQueryParams) {
                if (!allowedParam.equalsIgnoreCase(queryParam) && !paginationParams.contains(queryParam)) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            throw KieRemoteRestOperationException.badRequest(queryParam + " is an unknown and unsupported query param for the task query operation.");
        }
        List<Long> workItemIds = QueryResourceImpl.getLongListParam(allowedQueryParams[0], false, params, "query", true);
        List<Long> taskIds = QueryResourceImpl.getLongListParam(allowedQueryParams[1], false, params, "query", true);
        List<Long> procInstIds = QueryResourceImpl.getLongListParam(allowedQueryParams[6], false, params, "query", true);
        List<String> busAdmins = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[2], false, params, "query");
        List<String> potOwners = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[3], false, params, "query");
        List<String> taskOwners = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[5], false, params, "query");
        List<String> language = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[7], false, params, "query");
        String unionStr = QueryResourceImpl.getStringParam(allowedQueryParams[8], false, params, "query");
        boolean union = Boolean.parseBoolean(unionStr);
        List<String> statusStrList = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[4], false, params, "query");
        List<Status> statuses = QueryResourceImpl.convertStringListToStatusList(statusStrList);
        int[] pageInfo = QueryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxResults = QueryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        GetTasksByVariousFieldsCommand queryCmd = new GetTasksByVariousFieldsCommand(workItemIds, taskIds, procInstIds, busAdmins, potOwners, taskOwners, statuses, language, union, Integer.valueOf(maxResults));
        queryCmd.setUserId(this.identityProvider.getName());
        List results = (List)this.doRestTaskOperationWithTaskId((Long)null, queryCmd);
        logger.debug("{} results found.", (Object)results.size());
        JaxbTaskSummaryListResponse resultList = QueryResourceImpl.paginateAndCreateResult(pageInfo, results, new JaxbTaskSummaryListResponse());
        logger.debug("Returning {} results after pagination.", (Object)resultList.getList().size());
        return QueryResourceImpl.createCorrectVariant((Object)resultList, this.headers);
    }

    private class ActionData {
        public final String param;
        public final int action;
        public final String[] data;
        public boolean regex = false;
        public boolean min = false;
        public boolean max = false;

        public ActionData(String param, int action, String[] data) {
            this.param = param;
            this.action = action;
            this.data = data;
        }

        public ActionData(String param, int action) {
            this(param, action, null);
        }
    }
}

