/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.exception;

public class KieRemoteRestOperationException
extends RuntimeException {
    private static final long serialVersionUID = 3065096836333886139L;
    protected Integer status = null;

    public KieRemoteRestOperationException(String s) {
        super(s);
    }

    protected KieRemoteRestOperationException(String s, Status status) {
        super(s);
        this.status = status.getValue();
    }

    public KieRemoteRestOperationException(String s, Throwable throwable) {
        super(s, throwable);
    }

    protected KieRemoteRestOperationException(String s, Throwable throwable, Status status) {
        super(s, throwable);
        this.status = status.getValue();
    }

    public int getStatus() {
        return this.status;
    }

    public static KieRemoteRestOperationException badRequest(String msg) {
        return new KieRemoteRestOperationException(msg, Status.BAD_REQUEST);
    }

    public static KieRemoteRestOperationException forbidden(String msg) {
        return new KieRemoteRestOperationException(msg, Status.FORBIDDEN);
    }

    public static KieRemoteRestOperationException conflict(String msg, Exception e) {
        return new KieRemoteRestOperationException(msg, e, Status.CONFLICT);
    }

    public static KieRemoteRestOperationException notFound(String msg) {
        return new KieRemoteRestOperationException(msg, Status.NOT_FOUND);
    }

    public static KieRemoteRestOperationException internalServerError(String msg) {
        return new KieRemoteRestOperationException(msg, Status.INTERNAL_SERVER_ERROR);
    }

    public static KieRemoteRestOperationException internalServerError(String msg, Exception e) {
        return new KieRemoteRestOperationException(msg, e, Status.INTERNAL_SERVER_ERROR);
    }

    public static enum Status {
        BAD_REQUEST(400),
        FORBIDDEN(403),
        NOT_FOUND(404),
        CONFLICT(409),
        INTERNAL_SERVER_ERROR(500),
        METHOD_NOT_ALLOWED(405),
        GONE(410),
        PRE_CONDITION_FAILED(412),
        NOT_ACCEPTABLE(406),
        UNSUPPORTED_MEDIA_TYPE(415),
        UNAUTHORIZED(401);

        private final int status;

        private Status(int s) {
            this.status = s;
        }

        public int getValue() {
            return this.status;
        }
    }
}

