/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.jaxb;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import org.jbpm.services.cdi.Deploy;
import org.jbpm.services.cdi.Undeploy;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.remote.services.cdi.DeploymentProcessedEvent;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DynamicJaxbContext
extends JAXBContext {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJaxbContext.class);
    private static ConcurrentHashMap<String, JAXBContext> contextsCache = new ConcurrentHashMap();
    private static ThreadLocal<JAXBContext> requestJaxbContextLocal;
    @Inject
    DeploymentInfoBean deploymentInfoBean;
    private static AtomicInteger instanceCreated;

    public DynamicJaxbContext() {
        if (!instanceCreated.compareAndSet(0, 1)) {
            logger.debug("Instance {} of the {} created!", (Object)instanceCreated.incrementAndGet(), (Object)DynamicJaxbContext.class.getSimpleName());
        }
    }

    public static void setDeploymentJaxbContext(String deploymentId) {
        JAXBContext jaxbContext = contextsCache.get(deploymentId);
        if (jaxbContext == null) {
            logger.debug("No JAXBContext available for deployment '" + deploymentId + "', using default JAXBContext instance.");
            jaxbContext = contextsCache.get("**DEFAULT");
        }
        requestJaxbContextLocal.set(jaxbContext);
    }

    public static void clearDeploymentJaxbContext() {
        requestJaxbContextLocal.set(null);
    }

    private JAXBContext getRequestContext() {
        JAXBContext requestJaxbContext = requestJaxbContextLocal.get();
        if (requestJaxbContext == null) {
            throw new IllegalStateException("No jaxb context available for request!");
        }
        return requestJaxbContext;
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = this.getRequestContext();
        if (context != null) {
            return context.createUnmarshaller();
        }
        throw new IllegalStateException("No Unmarshaller available: JAXBContext instance could be found for this request!");
    }

    public Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = this.getRequestContext();
        if (context != null) {
            return context.createMarshaller();
        }
        throw new IllegalStateException("No Marshaller available: JAXBContext instance could be found for this request!");
    }

    public Validator createValidator() throws JAXBException {
        JAXBContext context = this.getRequestContext();
        if (context != null) {
            return context.createValidator();
        }
        throw new IllegalStateException("No Validator available: JAXBContext instance could be found for this request!");
    }

    public void setupDeploymentJaxbContext(@Observes @Deploy DeploymentProcessedEvent event) {
        String deploymentId = event.getDeploymentId();
        this.setupDeploymentJaxbContext(deploymentId);
    }

    public void cleanUpOnUndeploy(@Observes @Undeploy DeploymentProcessedEvent event) {
        String deploymentId = event.getDeploymentId();
        JAXBContext deploymentJaxbContext = contextsCache.remove(deploymentId);
        if (deploymentJaxbContext == null) {
            logger.error("JAXB context instance could not be found when undeploying deployment '" + deploymentId + "'!");
        }
    }

    private static void setupDefaultJaxbContext() {
        try {
            Class[] types = JaxbSerializationProvider.getAllBaseJaxbClasses((boolean)false);
            JAXBContext defaultJaxbContext = JAXBContext.newInstance((Class[])types);
            contextsCache.put("**DEFAULT", defaultJaxbContext);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to create new " + JAXBContext.class.getSimpleName() + " instance.", e);
        }
    }

    private void setupDeploymentJaxbContext(String deploymentId) {
        Collection<Class<?>> depClasses;
        if (contextsCache.contains(deploymentId)) {
            logger.error("JAXB context instance already found when deploying deployment '" + deploymentId + "'!");
            contextsCache.remove(deploymentId);
        }
        if ((depClasses = this.deploymentInfoBean.getDeploymentClasses(deploymentId)).size() == 0) {
            JAXBContext defaultJaxbContext = contextsCache.get("**DEFAULT");
            contextsCache.put(deploymentId, defaultJaxbContext);
            return;
        }
        HashSet<Class> allClasses = new HashSet<Class>(Arrays.asList(JaxbSerializationProvider.getAllBaseJaxbClasses((boolean)false)));
        allClasses.addAll(depClasses);
        Class[] allClassesArr = allClasses.toArray(new Class[allClasses.size()]);
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])allClassesArr);
            contextsCache.put(deploymentId, jaxbContext);
        }
        catch (JAXBException jaxbe) {
            String errMsg = "Unable to instantiate JAXBContext for deployment '" + deploymentId + "'.";
            throw new IllegalStateException(errMsg, jaxbe);
        }
    }

    public JAXBContext getDeploymentJaxbContext(String deploymentId) {
        JAXBContext jaxbContext = contextsCache.get(deploymentId);
        if (jaxbContext == null) {
            logger.debug("No JAXBContext available for deployment '" + deploymentId + "', using default JAXBContext instance.");
            jaxbContext = contextsCache.get("**DEFAULT");
        }
        return jaxbContext;
    }

    static {
        DynamicJaxbContext.setupDefaultJaxbContext();
        requestJaxbContextLocal = new ThreadLocal();
        instanceCreated = new AtomicInteger(0);
    }
}

