/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.api.HistoryResource;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbProcessInstanceLog;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;

@RequestScoped
public class HistoryResourceImpl
extends ResourceBase
implements HistoryResource {
    @Context
    private HttpHeaders headers;

    public Response clear() {
        this.getAuditLogService().clear();
        return HistoryResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    public Response getProcessInstanceLogs() {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        List procInstLogResults = this.getAuditLogService().findProcessInstances();
        this.sortProcessInstanceLogs(procInstLogResults);
        ArrayList results = new ArrayList(procInstLogResults);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    public Response getProcessInstanceLog(long procInstId) {
        org.jbpm.process.audit.ProcessInstanceLog procInstLog = this.getAuditLogService().findProcessInstance(procInstId);
        JaxbProcessInstanceLog jaxbProcLog = new JaxbProcessInstanceLog((ProcessInstanceLog)procInstLog);
        return HistoryResourceImpl.createCorrectVariant(jaxbProcLog, this.headers);
    }

    public Response getInstanceLogsByProcInstId(Long instId, String logType) {
        List varInstLogList;
        List result;
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        if ("child".equalsIgnoreCase(logType)) {
            varInstLogList = result = this.getAuditLogService().findSubProcessInstances(instId.longValue());
            this.sortProcessInstanceLogs(varInstLogList);
        } else if ("node".equalsIgnoreCase(logType)) {
            varInstLogList = result = this.getAuditLogService().findNodeInstances(instId.longValue());
            this.sortNodeInstanceLogs(varInstLogList);
        } else if ("variable".equalsIgnoreCase(logType)) {
            varInstLogList = result = this.getAuditLogService().findVariableInstances(instId.longValue());
            this.sortVariableInstanceLogs(varInstLogList);
        } else {
            throw KieRemoteRestOperationException.badRequest("Unsupported operation: " + oper);
        }
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, varInstLogList, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    public Response getInstanceLogsByProcInstIdByLogId(Long procInstId, String operation, String logId) {
        List varInstLogList;
        List result;
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        if ("node".equalsIgnoreCase(operation)) {
            varInstLogList = result = this.getAuditLogService().findNodeInstances(procInstId.longValue(), logId);
            this.sortNodeInstanceLogs(varInstLogList);
        } else if ("variable".equalsIgnoreCase(operation)) {
            varInstLogList = result = this.getAuditLogService().findVariableInstances(procInstId.longValue(), logId);
            this.sortVariableInstanceLogs(varInstLogList);
        } else {
            throw KieRemoteRestOperationException.badRequest("Unsupported operation: " + oper);
        }
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, varInstLogList, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    public Response getProcessInstanceLogsByProcessId(String processId) {
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> procInstLogList;
        Map<String, String[]> params = this.getRequestParams();
        Number statusParam = HistoryResourceImpl.getNumberParam("status", false, params, this.getRelativePath(), false);
        String oper = this.getRelativePath();
        int[] pageInfo = HistoryResourceImpl.getPageNumAndPageSize(params, oper);
        List<Object> result = statusParam != null ? (statusParam.intValue() == 1 ? this.getAuditLogService().findActiveProcessInstances(processId) : this.getAuditLogService().findProcessInstances(processId)) : this.getAuditLogService().findProcessInstances(processId);
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> filteredProcLogList = procInstLogList = result;
        if (statusParam != null && !statusParam.equals(1)) {
            filteredProcLogList = new ArrayList<org.jbpm.process.audit.ProcessInstanceLog>();
            for (int i = 0; i < procInstLogList.size() && filteredProcLogList.size() < HistoryResourceImpl.getMaxNumResultsNeeded(pageInfo); ++i) {
                org.jbpm.process.audit.ProcessInstanceLog procLog = (org.jbpm.process.audit.ProcessInstanceLog)procInstLogList.get(i);
                if (!procLog.getStatus().equals(statusParam.intValue())) continue;
                filteredProcLogList.add(procLog);
            }
        }
        this.sortProcessInstanceLogs((List<org.jbpm.process.audit.ProcessInstanceLog>)filteredProcLogList);
        ArrayList results = new ArrayList(filteredProcLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(pageInfo, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    public Response getVariableInstanceLogsByVariableId(String variableId) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List<VariableInstanceLog> varInstLogList = this.internalGetVariableInstancesByVarAndValue(variableId, null, params, oper);
        this.sortVariableInstanceLogs(varInstLogList);
        ArrayList<VariableInstanceLog> results = new ArrayList<VariableInstanceLog>(varInstLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    public Response getVariableInstanceLogsByVariableIdByVariableValue(String variableId, String value) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List<VariableInstanceLog> varInstLogList = this.internalGetVariableInstancesByVarAndValue(variableId, value, params, oper);
        this.sortVariableInstanceLogs(varInstLogList);
        ArrayList<VariableInstanceLog> results = new ArrayList<VariableInstanceLog>(varInstLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(params, oper, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    public Response getProcessInstanceLogsByVariableId(String variableId) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, null, params, oper);
        int[] pageInfo = HistoryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxNumResults = HistoryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        List<org.jbpm.process.audit.ProcessInstanceLog> procInstLogList = this.getProcessInstanceLogsByVariable(varLogList, maxNumResults);
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> results = new ArrayList<org.jbpm.process.audit.ProcessInstanceLog>(procInstLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(pageInfo, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    public Response getProcessInstanceLogsByVariableIdByVariableValue(String variableId, String value) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, value, params, oper);
        int[] pageInfo = HistoryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxNumResults = HistoryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        List<org.jbpm.process.audit.ProcessInstanceLog> procInstLogList = this.getProcessInstanceLogsByVariable(varLogList, maxNumResults);
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> results = new ArrayList<org.jbpm.process.audit.ProcessInstanceLog>(procInstLogList);
        JaxbHistoryLogList resultList = HistoryResourceImpl.paginateAndCreateResult(pageInfo, results, new JaxbHistoryLogList());
        return HistoryResourceImpl.createCorrectVariant(resultList, this.headers);
    }

    private List<VariableInstanceLog> internalGetVariableInstancesByVarAndValue(String varId, String value, Map<String, String[]> params, String oper) {
        String activeProcsParam = HistoryResourceImpl.getStringParam("activeProcesses", false, params, oper);
        boolean onlyActiveProcesses = false;
        if (activeProcsParam != null) {
            onlyActiveProcesses = Boolean.parseBoolean(activeProcsParam);
        }
        List result = value == null ? this.getAuditLogService().findVariableInstancesByName(varId, onlyActiveProcesses) : this.getAuditLogService().findVariableInstancesByNameAndValue(varId, value, onlyActiveProcesses);
        return result;
    }

    private List<org.jbpm.process.audit.ProcessInstanceLog> getProcessInstanceLogsByVariable(List<VariableInstanceLog> varLogList, int maxNumResults) {
        int numVarLogs = varLogList.size();
        int numProcInsts = 0;
        ArrayList<org.jbpm.process.audit.ProcessInstanceLog> resultList = new ArrayList<org.jbpm.process.audit.ProcessInstanceLog>();
        for (int i = 0; i < numVarLogs && numProcInsts < maxNumResults; ++i) {
            long procInstId = varLogList.get(i).getProcessInstanceId();
            org.jbpm.process.audit.ProcessInstanceLog procInstlog = this.getAuditLogService().findProcessInstance(procInstId);
            if (procInstlog == null) continue;
            resultList.add(procInstlog);
            ++numProcInsts;
        }
        return resultList;
    }

    private void sortProcessInstanceLogs(List<org.jbpm.process.audit.ProcessInstanceLog> procInstLogList) {
        Collections.sort(procInstLogList, new Comparator<org.jbpm.process.audit.ProcessInstanceLog>(){

            @Override
            public int compare(org.jbpm.process.audit.ProcessInstanceLog o1, org.jbpm.process.audit.ProcessInstanceLog o2) {
                if (!o1.getExternalId().equals(o2.getExternalId())) {
                    return o1.getExternalId().compareTo(o2.getExternalId());
                }
                if (!o1.getProcessId().equals(o2.getProcessId())) {
                    return o1.getProcessId().compareTo(o2.getProcessId());
                }
                return o1.getProcessInstanceId().compareTo(o2.getProcessInstanceId());
            }
        });
    }

    private void sortNodeInstanceLogs(List<NodeInstanceLog> procInstLogList) {
        Collections.sort(procInstLogList, new Comparator<NodeInstanceLog>(){

            @Override
            public int compare(NodeInstanceLog o1, NodeInstanceLog o2) {
                if (!o1.getExternalId().equals(o2.getExternalId())) {
                    return o1.getExternalId().compareTo(o2.getExternalId());
                }
                if (!o1.getProcessId().equals(o2.getProcessId())) {
                    return o1.getProcessId().compareTo(o2.getProcessId());
                }
                if (!o1.getProcessInstanceId().equals(o2.getProcessInstanceId())) {
                    return o1.getProcessInstanceId().compareTo(o2.getProcessInstanceId());
                }
                if (!o1.getNodeId().equals(o2.getNodeId())) {
                    return o1.getNodeId().compareTo(o2.getNodeId());
                }
                return o1.getNodeInstanceId().compareTo(o2.getNodeInstanceId());
            }
        });
    }

    private void sortVariableInstanceLogs(List<VariableInstanceLog> varInstLogList) {
        Collections.sort(varInstLogList, new Comparator<VariableInstanceLog>(){

            @Override
            public int compare(VariableInstanceLog o1, VariableInstanceLog o2) {
                if (!o1.getExternalId().equals(o2.getExternalId())) {
                    return o1.getExternalId().compareTo(o2.getExternalId());
                }
                if (!o1.getProcessId().equals(o2.getProcessId())) {
                    return o1.getProcessId().compareTo(o2.getProcessId());
                }
                if (!o1.getProcessInstanceId().equals(o2.getProcessInstanceId())) {
                    return o1.getProcessInstanceId().compareTo(o2.getProcessInstanceId());
                }
                if (!o1.getVariableId().equals(o2.getVariableId())) {
                    return o1.getVariableId().compareTo(o2.getVariableId());
                }
                return o1.getVariableInstanceId().compareTo(o2.getVariableInstanceId());
            }
        });
    }
}

