/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.services.task.commands.GetTasksByVariousFieldsCommand;
import org.kie.api.task.model.Status;
import org.kie.remote.services.jaxb.JaxbTaskSummaryListResponse;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.InternalProcInstQueryHelper;
import org.kie.remote.services.rest.query.InternalTaskQueryHelper;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryProcessInstanceResult;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryTaskResult;

@RequestScoped
@Path(value="/query/")
public class QueryResourceImpl
extends ResourceBase {
    @Context
    private HttpHeaders headers;
    @Inject
    private IdentityProvider identityProvider;
    private static final String[] allowedQueryParams = new String[]{"workItemId", "taskId", "businessAdministrator", "potentialOwner", "status", "taskOwner", "processInstanceId", "language", "union"};

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    @GET
    @Path(value="/runtime/task")
    public Response queryTasks() {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        int[] pageInfo = QueryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxNumResults = QueryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        InternalTaskQueryHelper queryHelper = new InternalTaskQueryHelper(this);
        JaxbQueryTaskResult result = queryHelper.queryTasksAndVariables(this.identityProvider.getName(), params, pageInfo, maxNumResults);
        queryHelper.dispose();
        return QueryResourceImpl.createCorrectVariant(result, this.headers);
    }

    @GET
    @Path(value="/runtime/process")
    public Response queryProcessInstances() {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        int[] pageInfo = QueryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxNumResults = QueryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        InternalProcInstQueryHelper queryHelper = new InternalProcInstQueryHelper(this);
        JaxbQueryProcessInstanceResult result = queryHelper.queryProcessInstancesAndVariables(params, pageInfo, maxNumResults);
        queryHelper.dispose();
        return QueryResourceImpl.createCorrectVariant(result, this.headers);
    }

    @GET
    @Path(value="/task")
    public Response taskSummaryQuery() {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        for (String queryParam : params.keySet()) {
            boolean allowed = false;
            for (String allowedParam : allowedQueryParams) {
                if (!allowedParam.equalsIgnoreCase(queryParam) && !paginationParams.contains(queryParam)) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            throw KieRemoteRestOperationException.badRequest(queryParam + " is an unknown and unsupported query param for the task query operation.");
        }
        List<Long> workItemIds = QueryResourceImpl.getLongListParam(allowedQueryParams[0], false, params, "query", true);
        List<Long> taskIds = QueryResourceImpl.getLongListParam(allowedQueryParams[1], false, params, "query", true);
        List<Long> procInstIds = QueryResourceImpl.getLongListParam(allowedQueryParams[6], false, params, "query", true);
        List<String> busAdmins = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[2], false, params, "query");
        List<String> potOwners = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[3], false, params, "query");
        List<String> taskOwners = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[5], false, params, "query");
        List<String> language = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[7], false, params, "query");
        String unionStr = QueryResourceImpl.getStringParam(allowedQueryParams[8], false, params, "query");
        boolean union = Boolean.parseBoolean(unionStr);
        List<String> statusStrList = QueryResourceImpl.getStringListParamAsList(allowedQueryParams[4], false, params, "query");
        List<Status> statuses = QueryResourceImpl.convertStringListToStatusList(statusStrList);
        int[] pageInfo = QueryResourceImpl.getPageNumAndPageSize(params, oper);
        int maxResults = QueryResourceImpl.getMaxNumResultsNeeded(pageInfo);
        GetTasksByVariousFieldsCommand queryCmd = new GetTasksByVariousFieldsCommand(workItemIds, taskIds, procInstIds, busAdmins, potOwners, taskOwners, statuses, language, union, Integer.valueOf(maxResults));
        queryCmd.setUserId(this.identityProvider.getName());
        List results = (List)this.doRestTaskOperationWithTaskId((Long)null, queryCmd);
        logger.debug("{} results found.", (Object)results.size());
        JaxbTaskSummaryListResponse resultList = QueryResourceImpl.paginateAndCreateResult(pageInfo, results, new JaxbTaskSummaryListResponse());
        logger.debug("Returning {} results after pagination.", (Object)resultList.getList().size());
        return QueryResourceImpl.createCorrectVariant((Object)resultList, this.headers);
    }
}

