/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.util.ArrayDeque;
import java.util.Map;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.ActionData;
import org.kie.remote.services.rest.query.QueryResourceData;
import org.kie.remote.services.rest.query.RemoteServicesQueryCommandBuilder;

public abstract class AbstractInternalQueryHelper {
    protected ResourceBase resourceBase;

    public AbstractInternalQueryHelper(ResourceBase resourceBase) {
        this.resourceBase = resourceBase;
    }

    public void dispose() {
        this.resourceBase = null;
    }

    protected static void setRegexOnOff(ActionData actionData, boolean on, RemoteServicesQueryCommandBuilder ... queryCmdBuilders) {
        if (actionData.regex) {
            if (on) {
                for (RemoteServicesQueryCommandBuilder queryCmdBuilder : queryCmdBuilders) {
                    queryCmdBuilder.like();
                }
            } else {
                for (RemoteServicesQueryCommandBuilder queryCmdBuilder : queryCmdBuilders) {
                    queryCmdBuilder.equals();
                }
                actionData.regex = false;
            }
        }
    }

    protected ArrayDeque<ActionData> fillActionDataQueueFromQueryParams(Map<String, String[]> queryParams, Map<String, String> varValueMap, Map<String, String> varRegexMap) {
        ArrayDeque<ActionData> actionDataQueue = new ArrayDeque<ActionData>();
        for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
            Integer action;
            String orig_param = entry.getKey();
            if (ResourceBase.paginationParams.contains(orig_param)) continue;
            String[] paramParts = orig_param.split("_");
            String param = paramParts[0];
            if (paramParts.length >= 2) {
                if ("var".equals(paramParts[0]) || "varregex".equals(paramParts[0]) || "vr".equals(paramParts[0])) {
                    String[] values = queryParams.get(orig_param);
                    if (values.length > 1) {
                        throw KieRemoteRestOperationException.badRequest("Only one value per variable parameter: '" + orig_param + "'");
                    }
                    String value = values[0];
                    String varName = null;
                    StringBuilder nameBuilder = new StringBuilder(paramParts[1]);
                    for (int i = 2; i < paramParts.length; ++i) {
                        nameBuilder.append("_").append(paramParts[i]);
                    }
                    varName = nameBuilder.toString();
                    Integer queryAction = QueryResourceData.paramNameActionMap.get(paramParts[0]);
                    String[] data = new String[]{varName};
                    ActionData actionData = new ActionData(orig_param, queryAction, data);
                    actionDataQueue.add(actionData);
                    if ("var".equals(paramParts[0])) {
                        varValueMap.put(varName, value);
                        continue;
                    }
                    varRegexMap.put(varName, value);
                    actionData.regex = true;
                    continue;
                }
                if (paramParts.length > 2) {
                    throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
                }
                action = QueryResourceData.paramNameActionMap.get(paramParts[0]);
                if (action == null) {
                    throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
                }
                ActionData actionData = new ActionData(orig_param, action, entry.getValue());
                actionDataQueue.add(actionData);
                if ("min".equals(paramParts[1])) {
                    actionData.min = true;
                    continue;
                }
                if ("max".equals(paramParts[1])) {
                    actionData.max = true;
                    continue;
                }
                if ("re".equals(paramParts[1])) {
                    actionData.regex = true;
                    continue;
                }
                throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
            }
            action = QueryResourceData.paramNameActionMap.get(param);
            if (action != null) {
                actionDataQueue.add(new ActionData(orig_param, action, entry.getValue()));
                continue;
            }
            throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
        }
        return actionDataQueue;
    }

    protected Boolean determineWorkFlowInstanceVariableUse(Map<String, String[]> queryParams) {
        Boolean workFlowInstanceVariables = null;
        if (queryParams.containsKey(QueryResourceData.metaRuntimeParams[0]) || queryParams.containsKey(QueryResourceData.metaRuntimeParamsShort[0])) {
            workFlowInstanceVariables = true;
            queryParams.remove(QueryResourceData.metaRuntimeParams[0]);
            queryParams.remove(QueryResourceData.metaRuntimeParamsShort[0]);
        }
        if (queryParams.containsKey(QueryResourceData.metaRuntimeParams[1]) || queryParams.containsKey(QueryResourceData.metaRuntimeParamsShort[1])) {
            if (workFlowInstanceVariables != null) {
                throw KieRemoteRestOperationException.badRequest("Only one of the 'memory' and 'history' query parameters may be specified.");
            }
            workFlowInstanceVariables = false;
            queryParams.remove(QueryResourceData.metaRuntimeParams[1]);
            queryParams.remove(QueryResourceData.metaRuntimeParamsShort[1]);
        }
        if (workFlowInstanceVariables == null) {
            workFlowInstanceVariables = false;
        }
        return workFlowInstanceVariables;
    }
}

