/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.audit.AuditLogService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.internal.query.data.QueryData;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.AbstractInternalQueryHelper;
import org.kie.remote.services.rest.query.ActionData;
import org.kie.remote.services.rest.query.QueryResourceData;
import org.kie.remote.services.rest.query.RemoteServicesQueryCommandBuilder;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstance;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryProcessInstanceInfo;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryProcessInstanceResult;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbVariableInfo;

public class InternalProcInstQueryHelper
extends AbstractInternalQueryHelper {
    public InternalProcInstQueryHelper(ResourceBase resourceBase) {
        super(resourceBase);
    }

    public JaxbQueryProcessInstanceResult queryProcessInstancesAndVariables(Map<String, String[]> queryParams, int[] pageInfo, int maxResults) {
        HashMap<String, String> varValueMap = new HashMap<String, String>();
        HashMap<String, String> varRegexMap = new HashMap<String, String>();
        Boolean workFlowInstanceVariables = this.determineWorkFlowInstanceVariableUse(queryParams);
        if (workFlowInstanceVariables.booleanValue()) {
            HashMap hashMap = new HashMap();
        }
        boolean onlyRetrieveLastVarLogs = true;
        String[] paramVals = queryParams.remove("all");
        if (paramVals != null) {
            onlyRetrieveLastVarLogs = false;
        }
        ArrayDeque<ActionData> actionDataQueue = this.fillActionDataQueueFromQueryParams(queryParams, varValueMap, varRegexMap);
        RemoteServicesQueryCommandBuilder instLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        if (onlyRetrieveLastVarLogs) {
            instLogQueryBuilder.last();
        }
        while (!actionDataQueue.isEmpty()) {
            ActionData actionData = actionDataQueue.poll();
            String[] data = actionData.paramData;
            int action = actionData.action;
            switch (action) {
                case 0: {
                    assert ("processinstanceid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstanceid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    if (actionData.min || actionData.max) {
                        if (longData.length > 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.paramName + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            instLogQueryBuilder.processInstanceIdMin(longData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        instLogQueryBuilder.processInstanceIdMax(longData[0]);
                        actionData.max = false;
                        break;
                    }
                    instLogQueryBuilder.processInstanceId(longData);
                    break;
                }
                case 1: {
                    assert ("processid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processid";
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, true, instLogQueryBuilder);
                    instLogQueryBuilder.processId(data);
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, false, instLogQueryBuilder);
                    break;
                }
                case 2: {
                    assert ("workitemid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : workitemid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    instLogQueryBuilder.workItemId(longData);
                    break;
                }
                case 3: {
                    assert ("deploymentid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : deploymentid";
                    instLogQueryBuilder.deploymentId(data);
                    break;
                }
                case 11: {
                    assert ("processinstancestatus".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstancestatus";
                    int[] intData = QueryResourceData.getInts(action, data);
                    instLogQueryBuilder.processInstanceStatus(intData);
                    break;
                }
                case 12: {
                    assert ("processversion".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processversion";
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, true, instLogQueryBuilder);
                    instLogQueryBuilder.processVersion(data);
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, false, instLogQueryBuilder);
                    break;
                }
                case 13: {
                    assert ("startdate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : startdate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (actionData.min || actionData.max) {
                        if (dateData.length != 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.paramName + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            instLogQueryBuilder.startDateMin(dateData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        instLogQueryBuilder.startDateMax(dateData[0]);
                        actionData.max = false;
                        break;
                    }
                    instLogQueryBuilder.startDate(dateData);
                    break;
                }
                case 14: {
                    assert ("enddate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : enddate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (actionData.min || actionData.max) {
                        if (dateData.length > 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.paramName + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            instLogQueryBuilder.endDateMin(dateData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        instLogQueryBuilder.endDateMax(dateData[0]);
                        actionData.max = false;
                        break;
                    }
                    instLogQueryBuilder.startDate(dateData);
                    break;
                }
                case 15: {
                    assert ("varid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varid";
                    if (actionData.regex && workFlowInstanceVariables.booleanValue()) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter " + "when retrieving in-memory process variables");
                    }
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, true, instLogQueryBuilder);
                    instLogQueryBuilder.variableId(data);
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, false, instLogQueryBuilder);
                    instLogQueryBuilder.last();
                    break;
                }
                case 16: {
                    assert ("varvalue".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varvalue";
                    if (actionData.regex && workFlowInstanceVariables.booleanValue()) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter when retrieving in-memory process variables");
                    }
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, true, instLogQueryBuilder);
                    instLogQueryBuilder.value(data);
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, false, instLogQueryBuilder);
                    break;
                }
                case 17: {
                    assert ("var".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : var";
                    instLogQueryBuilder.variableValue(data[0], (String)varValueMap.get(data[0]));
                    break;
                }
                case 18: {
                    assert ("varregex".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varregex";
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, true, instLogQueryBuilder);
                    instLogQueryBuilder.variableValue(data[0], (String)varRegexMap.get(data[0]));
                    InternalProcInstQueryHelper.setRegexOnOff(actionData, false, instLogQueryBuilder);
                    break;
                }
                default: {
                    throw KieRemoteRestOperationException.internalServerError("Please contact the developers: this state should not be possible.");
                }
            }
            if (!actionData.min && !actionData.max && !actionData.regex) continue;
            throw KieRemoteRestOperationException.notFound("Query parameter '" + actionData.paramName + "' is not supported.");
        }
        QueryData queryData = instLogQueryBuilder.getQueryData();
        AuditLogService auditLogService = this.resourceBase.getAuditLogService();
        List varLogs = auditLogService.queryVariableInstanceLogs(queryData);
        List procLogs = auditLogService.queryProcessInstanceLogs(queryData);
        List<JaxbVariableInfo> procVars = null;
        JaxbQueryProcessInstanceResult result = InternalProcInstQueryHelper.createProcessInstanceResult(procLogs, varLogs, procVars);
        return result;
    }

    private static JaxbQueryProcessInstanceResult createProcessInstanceResult(List<ProcessInstanceLog> procLogs, List<VariableInstanceLog> varLogs, List<JaxbVariableInfo> processVariables) {
        JaxbQueryProcessInstanceInfo taskInfo;
        long procInstId;
        JaxbQueryProcessInstanceResult result = new JaxbQueryProcessInstanceResult();
        HashMap<Long, JaxbQueryProcessInstanceInfo> procInstIdProcInstInfoMap = new HashMap<Long, JaxbQueryProcessInstanceInfo>();
        for (ProcessInstanceLog procLog : procLogs) {
            procInstId = procLog.getProcessInstanceId();
            taskInfo = InternalProcInstQueryHelper.getQueryProcessInstanceInfo(procInstId, procInstIdProcInstInfoMap);
            taskInfo.setProcessInstance(new JaxbProcessInstance(procLog));
        }
        for (VariableInstanceLog varLog : varLogs) {
            procInstId = varLog.getProcessInstanceId();
            taskInfo = InternalProcInstQueryHelper.getQueryProcessInstanceInfo(procInstId, procInstIdProcInstInfoMap);
            taskInfo.getVariables().add(new JaxbVariableInfo(varLog));
        }
        result.getProcessInstanceInfoList().addAll(procInstIdProcInstInfoMap.values());
        return result;
    }

    private static JaxbQueryProcessInstanceInfo getQueryProcessInstanceInfo(long procInstId, Map<Long, JaxbQueryProcessInstanceInfo> procInstIdProcInstInfoMap) {
        JaxbQueryProcessInstanceInfo procInstInfo = procInstIdProcInstInfoMap.get(procInstId);
        if (procInstInfo == null) {
            procInstInfo = new JaxbQueryProcessInstanceInfo();
            procInstIdProcInstInfoMap.put(procInstId, procInstInfo);
        }
        return procInstInfo;
    }
}

