/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.services.task.commands.TaskQueryDataCommand;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.data.QueryData;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.AbstractInternalQueryHelper;
import org.kie.remote.services.rest.query.ActionData;
import org.kie.remote.services.rest.query.QueryResourceData;
import org.kie.remote.services.rest.query.RemoteServicesQueryCommandBuilder;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryTaskInfo;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryTaskResult;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbVariableInfo;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskSummary;

public class InternalTaskQueryHelper
extends AbstractInternalQueryHelper {
    public InternalTaskQueryHelper(ResourceBase resourceBase) {
        super(resourceBase);
    }

    public JaxbQueryTaskResult queryTasksAndVariables(String identity, Map<String, String[]> queryParams, int[] pageInfo, int maxResults) {
        HashMap<String, String> varValueMap = new HashMap<String, String>();
        HashMap<String, String> varRegexMap = new HashMap<String, String>();
        Boolean workFlowInstanceVariables = this.determineWorkFlowInstanceVariableUse(queryParams);
        if (workFlowInstanceVariables.booleanValue()) {
            HashMap hashMap = new HashMap();
        }
        boolean retrieveAllVarLogs = true;
        String[] paramVals = queryParams.remove("all");
        if (paramVals != null) {
            retrieveAllVarLogs = false;
        }
        ArrayDeque<ActionData> actionDataQueue = this.fillActionDataQueueFromQueryParams(queryParams, varValueMap, varRegexMap);
        RemoteServicesQueryCommandBuilder taskQueryBuilder = new RemoteServicesQueryCommandBuilder(identity);
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        if (retrieveAllVarLogs) {
            varInstLogQueryBuilder.last();
        }
        while (!actionDataQueue.isEmpty()) {
            ActionData actionData = actionDataQueue.poll();
            String[] data = actionData.paramData;
            int action = actionData.action;
            switch (action) {
                case 0: {
                    assert ("processinstanceid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstanceid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    taskQueryBuilder.processInstanceId(longData);
                    varInstLogQueryBuilder.processInstanceId(longData);
                    if (actionData.min || actionData.max) {
                        if (longData.length > 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.paramName + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            varInstLogQueryBuilder.processInstanceIdMin(longData[0]);
                            taskQueryBuilder.processInstanceIdMin(longData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        varInstLogQueryBuilder.processInstanceIdMax(longData[0]);
                        taskQueryBuilder.processInstanceIdMax(longData[0]);
                        actionData.max = false;
                        break;
                    }
                    varInstLogQueryBuilder.processInstanceId(longData);
                    taskQueryBuilder.processInstanceId(longData);
                    break;
                }
                case 1: {
                    assert ("processid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processid";
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.processId(data);
                    varInstLogQueryBuilder.processId(data);
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 2: {
                    assert ("workitemid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : workitemid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    taskQueryBuilder.workItemId(longData);
                    varInstLogQueryBuilder.workItemId(longData);
                    break;
                }
                case 3: {
                    assert ("deploymentid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : deploymentid";
                    taskQueryBuilder.deploymentId(data);
                    varInstLogQueryBuilder.deploymentId(data);
                    break;
                }
                case 4: {
                    assert ("taskid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : taskid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    taskQueryBuilder.taskId(longData);
                    varInstLogQueryBuilder.taskId(longData);
                    break;
                }
                case 5: {
                    assert ("initiator".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : initiator";
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.initiator(data);
                    varInstLogQueryBuilder.initiator(data);
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 6: {
                    assert ("stakeholder".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : stakeholder";
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.stakeHolder(data);
                    varInstLogQueryBuilder.stakeHolder(data);
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 7: {
                    assert ("potentialowner".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : potentialowner";
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.potentialOwner(data);
                    varInstLogQueryBuilder.potentialOwner(data);
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 8: {
                    assert ("taskowner".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : taskowner";
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.taskOwner(data);
                    varInstLogQueryBuilder.taskOwner(data);
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 9: {
                    assert ("businessadmin".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : businessadmin";
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.businessAdmin(data);
                    varInstLogQueryBuilder.businessAdmin(data);
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 10: {
                    assert ("taskstatus".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : taskstatus";
                    Status[] statuses = QueryResourceData.getTaskStatuses(data);
                    taskQueryBuilder.taskStatus(statuses);
                    varInstLogQueryBuilder.taskStatus(statuses);
                    break;
                }
                case 11: {
                    assert ("processinstancestatus".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstancestatus";
                    int[] intData = QueryResourceData.getInts(action, data);
                    taskQueryBuilder.processInstanceStatus(intData);
                    varInstLogQueryBuilder.processInstanceStatus(intData);
                    break;
                }
                case 12: {
                    assert ("processversion".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processversion";
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.processVersion(data);
                    varInstLogQueryBuilder.processVersion(data);
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 13: {
                    assert ("startdate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : startdate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (actionData.min || actionData.max) {
                        if (dateData.length != 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.paramName + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            taskQueryBuilder.startDateMin(dateData[0]);
                            varInstLogQueryBuilder.startDateMin(dateData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        taskQueryBuilder.startDateMax(dateData[0]);
                        varInstLogQueryBuilder.startDateMax(dateData[0]);
                        actionData.max = false;
                        break;
                    }
                    taskQueryBuilder.startDate(dateData);
                    varInstLogQueryBuilder.startDate(dateData);
                    break;
                }
                case 14: {
                    assert ("enddate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : enddate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (actionData.min || actionData.max) {
                        if (dateData.length > 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + actionData.paramName + "' parameter is accepted");
                        }
                        if (actionData.min) {
                            taskQueryBuilder.endDateMin(dateData[0]);
                            varInstLogQueryBuilder.endDateMin(dateData[0]);
                            actionData.min = false;
                            break;
                        }
                        if (!actionData.max) break;
                        taskQueryBuilder.endDateMax(dateData[0]);
                        varInstLogQueryBuilder.endDateMax(dateData[0]);
                        actionData.max = false;
                        break;
                    }
                    taskQueryBuilder.startDate(dateData);
                    varInstLogQueryBuilder.startDate(dateData);
                    break;
                }
                case 15: {
                    assert ("varid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varid";
                    if (actionData.regex && workFlowInstanceVariables.booleanValue()) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter " + "when retrieving in-memory process variables");
                    }
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.variableId(data);
                    varInstLogQueryBuilder.last().variableId(data);
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 16: {
                    assert ("varvalue".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varvalue";
                    if (actionData.regex && workFlowInstanceVariables.booleanValue()) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter " + "when retrieving in-memory process variables");
                    }
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.value(data);
                    varInstLogQueryBuilder.value(data);
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                case 17: {
                    assert ("var".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : var";
                    taskQueryBuilder.variableValue(data[0], (String)varValueMap.get(data[0]));
                    varInstLogQueryBuilder.variableValue(data[0], (String)varValueMap.get(data[0]));
                    break;
                }
                case 18: {
                    assert ("varregex".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varregex";
                    InternalTaskQueryHelper.setRegexOnOff(actionData, true, taskQueryBuilder, varInstLogQueryBuilder);
                    taskQueryBuilder.variableValue(data[0], (String)varRegexMap.get(data[0]));
                    varInstLogQueryBuilder.variableValue(data[0], (String)varRegexMap.get(data[0]));
                    InternalTaskQueryHelper.setRegexOnOff(actionData, false, taskQueryBuilder, varInstLogQueryBuilder);
                    break;
                }
                default: {
                    throw KieRemoteRestOperationException.internalServerError("Please contact the developers: state [" + action + "] should not be possible.");
                }
            }
            if (!actionData.min && !actionData.max && !actionData.regex) continue;
            throw KieRemoteRestOperationException.notFound("Query parameter '" + actionData.paramName + "' is not supported.");
        }
        TaskQueryDataCommand taskCmd = taskQueryBuilder.createTaskQueryDataCommand();
        List taskSummaries = (List)this.resourceBase.doRestTaskOperation(taskCmd);
        QueryData varLogQueryData = varInstLogQueryBuilder.getQueryData();
        List varLogs = this.resourceBase.getAuditLogService().queryVariableInstanceLogs(varLogQueryData);
        List<JaxbVariableInfo> procVars = null;
        if (workFlowInstanceVariables.booleanValue()) {
            for (VariableInstanceLog varLog : varLogs) {
            }
        }
        JaxbQueryTaskResult result = InternalTaskQueryHelper.createQueryTaskResult(taskSummaries, varLogs, procVars);
        return result;
    }

    private static JaxbQueryTaskResult createQueryTaskResult(List<TaskSummary> taskSummaries, List<VariableInstanceLog> varLogs, List<JaxbVariableInfo> processVariables) {
        JaxbQueryTaskInfo taskInfo;
        long procInstId;
        JaxbQueryTaskResult result = new JaxbQueryTaskResult();
        HashMap<Long, JaxbQueryTaskInfo> procInstIdTaskInfoMap = new HashMap<Long, JaxbQueryTaskInfo>();
        for (TaskSummary taskSum : taskSummaries) {
            procInstId = taskSum.getProcessInstanceId();
            taskInfo = InternalTaskQueryHelper.createJaxbQueryTaskInfo(procInstId, procInstIdTaskInfoMap);
            taskInfo.getTaskSummaries().add(new JaxbTaskSummary(taskSum));
        }
        for (VariableInstanceLog varLog : varLogs) {
            procInstId = varLog.getProcessInstanceId();
            taskInfo = InternalTaskQueryHelper.createJaxbQueryTaskInfo(procInstId, procInstIdTaskInfoMap);
            taskInfo.getVariables().add(new JaxbVariableInfo(varLog));
        }
        result.getTaskInfoList().addAll(procInstIdTaskInfoMap.values());
        return result;
    }

    private static JaxbQueryTaskInfo createJaxbQueryTaskInfo(long procInstId, Map<Long, JaxbQueryTaskInfo> procInstIdTaskInfoMap) {
        JaxbQueryTaskInfo taskInfo = procInstIdTaskInfoMap.get(procInstId);
        if (taskInfo == null) {
            taskInfo = new JaxbQueryTaskInfo(procInstId);
            procInstIdTaskInfoMap.put(procInstId, taskInfo);
        }
        return taskInfo;
    }
}

